package com.zurrtum.create.mixin;

import com.zurrtum.create.content.contraptions.ContraptionHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.foundation.item.EntityItem;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_5568;
import net.minecraft.class_5579;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5579.class)
public class ServerEntityManagerMixin {
    @ModifyVariable(method = "addEntity(Lnet/minecraft/world/entity/EntityLike;Z)Z", at = @At("HEAD"), ordinal = 0, argsOnly = true)
    private class_5568 addEntity(class_5568 entity) {
        if (entity instanceof class_1542 itemEntity) {
            class_1799 stack = itemEntity.method_6983();
            if (stack.method_7909() instanceof EntityItem item) {
                class_1297 newEntity = item.createEntity(itemEntity.method_73183(), itemEntity, stack);
                if (newEntity != null) {
                    itemEntity.method_31472();
                    return newEntity;
                }
            }
        }
        return entity;
    }

    @Inject(method = "addEntity(Lnet/minecraft/world/entity/EntityLike;Z)Z", at = @At("HEAD"))
    private void addEntity(class_5568 entity, boolean existing, CallbackInfoReturnable<Boolean> cir) {
        ContraptionHandler.addSpawnedContraptionsToCollisionList(entity);
        if (!existing) {
            CapabilityMinecartController.attach(entity);
        }
    }
}
