/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.deployer.DeployerApplicationRecipe;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeType;

public class AllAssemblyRecipeNames {
    private static final Map<String, BiFunction<DynamicOps<JsonElement>, JsonObject, Component>> ALL = new HashMap<String, BiFunction<DynamicOps<JsonElement>, JsonObject, Component>>();

    public static Component get(DynamicOps<JsonElement> ops, JsonObject json) {
        String type = json.get("type").getAsString();
        BiFunction<DynamicOps<JsonElement>, JsonObject, Component> factory = ALL.get(type);
        if (factory != null) {
            return factory.apply(ops, json);
        }
        String name = type.startsWith("create:") ? type.replaceFirst("create:", "") : type.replaceFirst(":", ".");
        return Component.translatable((String)("create.recipe.assembly." + name));
    }

    public static void register(RecipeType<?> id, BiFunction<DynamicOps<JsonElement>, JsonObject, Component> factory) {
        ALL.put(id.toString(), factory);
    }

    public static void register() {
        AllAssemblyRecipeNames.register(AllRecipeTypes.DEPLOYING, DeployerApplicationRecipe::getDescriptionForAssembly);
        AllAssemblyRecipeNames.register(AllRecipeTypes.FILLING, FillingRecipe::getDescriptionForAssembly);
    }
}

