/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.contraptions.gantry.GantryContraptionEntity;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import com.zurrtum.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.depot.EjectorItemEntity;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class AllEntityTypes {
    public static final Set<EntityType<?>> NOT_SEND_VELOCITY = new HashSet();
    public static final EntityType<EjectorItemEntity> EJECTOR_ITEM = AllEntityTypes.register("ejector_item", EntityType.Builder.of(EjectorItemEntity::new, (MobCategory)MobCategory.MISC).noLootTable().sized(0.25f, 0.25f).eyeHeight(0.2125f).clientTrackingRange(6).updateInterval(20));
    public static final EntityType<OrientedContraptionEntity> ORIENTED_CONTRAPTION = AllEntityTypes.register("contraption", EntityType.Builder.of(OrientedContraptionEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).fireImmune());
    public static final EntityType<ControlledContraptionEntity> CONTROLLED_CONTRAPTION = AllEntityTypes.register("stationary_contraption", EntityType.Builder.of(ControlledContraptionEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(20).updateInterval(40).fireImmune());
    public static final EntityType<CarriageContraptionEntity> CARRIAGE_CONTRAPTION = AllEntityTypes.register("carriage_contraption", EntityType.Builder.of(CarriageContraptionEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(15).fireImmune());
    public static final EntityType<SuperGlueEntity> SUPER_GLUE = AllEntityTypes.register("super_glue", EntityType.Builder.of(SuperGlueEntity::new, (MobCategory)MobCategory.MISC).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).fireImmune());
    public static final EntityType<GantryContraptionEntity> GANTRY_CONTRAPTION = AllEntityTypes.register("gantry_contraption", EntityType.Builder.of(GantryContraptionEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(10).updateInterval(40).fireImmune());
    public static final EntityType<SeatEntity> SEAT = AllEntityTypes.register("seat", EntityType.Builder.of(SeatEntity::new, (MobCategory)MobCategory.MISC).updateInterval(Integer.MAX_VALUE).fireImmune().sized(0.25f, 0.35f));
    public static final EntityType<PotatoProjectileEntity> POTATO_PROJECTILE = AllEntityTypes.register("potato_projectile", EntityType.Builder.of(PotatoProjectileEntity::new, (MobCategory)MobCategory.MISC).clientTrackingRange(4).updateInterval(20).sized(0.25f, 0.25f));
    public static final EntityType<PackageEntity> PACKAGE = AllEntityTypes.register("package", EntityType.Builder.of(PackageEntity::new, (MobCategory)MobCategory.MISC).clientTrackingRange(10).updateInterval(3).sized(1.0f, 1.0f));
    public static final EntityType<BlueprintEntity> CRAFTING_BLUEPRINT = AllEntityTypes.register("crafting_blueprint", EntityType.Builder.of(BlueprintEntity::new, (MobCategory)MobCategory.MISC).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).fireImmune());

    private static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> type) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"create", (String)id));
        return (EntityType)Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceKey)key, (Object)type.build(key));
    }

    public static void register() {
        NOT_SEND_VELOCITY.add(SUPER_GLUE);
        NOT_SEND_VELOCITY.add(CONTROLLED_CONTRAPTION);
        NOT_SEND_VELOCITY.add(GANTRY_CONTRAPTION);
        NOT_SEND_VELOCITY.add(SEAT);
        NOT_SEND_VELOCITY.add(CRAFTING_BLUEPRINT);
    }
}

