/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsServerHandler;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlock;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.contraptions.glue.SuperGlueSelectionHelper;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import com.zurrtum.create.content.equipment.blueprint.BlueprintMenu;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxHandler;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.equipment.zapper.ZapperInteractionHandler;
import com.zurrtum.create.content.equipment.zapper.ZapperItem;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.kinetics.chainConveyor.ServerChainConveyorHandler;
import com.zurrtum.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.filter.AttributeFilterMenu;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterMenu;
import com.zurrtum.create.content.logistics.filter.PackageFilterMenu;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.PackagePortTarget;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsNetwork;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterBlock;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperCategoryMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.content.redstone.link.controller.LecternControllerBlockEntity;
import com.zurrtum.create.content.redstone.link.controller.LinkedControllerItem;
import com.zurrtum.create.content.redstone.link.controller.LinkedControllerServerHandler;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.zurrtum.create.content.schematics.SchematicInstances;
import com.zurrtum.create.content.schematics.SchematicPrinter;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.zurrtum.create.content.schematics.cannon.SchematicannonMenu;
import com.zurrtum.create.content.schematics.table.SchematicTableBlockEntity;
import com.zurrtum.create.content.schematics.table.SchematicTableMenu;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainIconType;
import com.zurrtum.create.content.trains.entity.TrainRelocator;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackPropagator;
import com.zurrtum.create.content.trains.track.TrackTargetingBlockItem;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettingsHandleBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.foundation.gui.menu.GhostItemMenu;
import com.zurrtum.create.foundation.gui.menu.IClearableMenu;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.c2s.ArmPlacementPacket;
import com.zurrtum.create.infrastructure.packet.c2s.BlueprintAssignCompleteRecipePacket;
import com.zurrtum.create.infrastructure.packet.c2s.BlueprintPreviewRequestPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ChainConveyorConnectionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ChainPackageInteractionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ClientMotionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ClipboardEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSchematicannonPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSequencedGearshiftPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSymmetryWandPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureThresholdSwitchPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureWorldshaperPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ContraptionColliderLockPacketRequest;
import com.zurrtum.create.infrastructure.packet.c2s.ContraptionInteractionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ControlsInputPacket;
import com.zurrtum.create.infrastructure.packet.c2s.CouplingCreationPacket;
import com.zurrtum.create.infrastructure.packet.c2s.CurvedTrackDestroyPacket;
import com.zurrtum.create.infrastructure.packet.c2s.CurvedTrackSelectionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.DisplayLinkConfigurationPacket;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorAwardPacket;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorElytraPacket;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorPlacementPacket;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorTriggerPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ElevatorContactEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ElevatorTargetFloorPacket;
import com.zurrtum.create.infrastructure.packet.c2s.FactoryPanelConfigurationPacket;
import com.zurrtum.create.infrastructure.packet.c2s.FactoryPanelConnectionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket;
import com.zurrtum.create.infrastructure.packet.c2s.GaugeObservedPacket;
import com.zurrtum.create.infrastructure.packet.c2s.GhostItemSubmitPacket;
import com.zurrtum.create.infrastructure.packet.c2s.HonkPacket;
import com.zurrtum.create.infrastructure.packet.c2s.InstantSchematicPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkSettingsPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerBindPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerInputPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerStopLecternPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LogisticalStockRequestPacket;
import com.zurrtum.create.infrastructure.packet.c2s.PackageOrderRequestPacket;
import com.zurrtum.create.infrastructure.packet.c2s.PackagePortConfigurationPacket;
import com.zurrtum.create.infrastructure.packet.c2s.PackagePortPlacementPacket;
import com.zurrtum.create.infrastructure.packet.c2s.PlaceExtendedCurvePacket;
import com.zurrtum.create.infrastructure.packet.c2s.RadialWrenchMenuSubmitPacket;
import com.zurrtum.create.infrastructure.packet.c2s.RedstoneRequesterConfigurationPacket;
import com.zurrtum.create.infrastructure.packet.c2s.RequestFloorListPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ScheduleEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.SchematicPlacePacket;
import com.zurrtum.create.infrastructure.packet.c2s.SchematicSyncPacket;
import com.zurrtum.create.infrastructure.packet.c2s.SchematicUploadPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ServerboundChainConveyorRidingPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StationEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperCategoryEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperCategoryHidingPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperCategoryRefundPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperLockPacket;
import com.zurrtum.create.infrastructure.packet.c2s.SuperGlueRemovalPacket;
import com.zurrtum.create.infrastructure.packet.c2s.SuperGlueSelectionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxDisposeAllPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxEquipPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrackGraphRequestPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainCollisionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainHUDUpdatePacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainRelocationPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ValueSettingsPacket;
import com.zurrtum.create.infrastructure.packet.s2c.BlueprintPreviewPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionColliderLockPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionRelocationPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ElevatorFloorListPacket;
import com.zurrtum.create.infrastructure.packet.s2c.HonkReturnPacket;
import com.zurrtum.create.infrastructure.packet.s2c.LimbSwingUpdatePacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrainEditReturnPacket;
import com.zurrtum.create.infrastructure.packet.s2c.WiFiEffectPacket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class AllHandle {
    public static void onConfigureSchematicannon(ServerGamePacketListenerImpl listener, ConfigureSchematicannonPacket packet) {
        AbstractContainerMenu abstractContainerMenu = listener.player.containerMenu;
        if (!(abstractContainerMenu instanceof SchematicannonMenu)) {
            return;
        }
        SchematicannonMenu menu = (SchematicannonMenu)abstractContainerMenu;
        SchematicannonBlockEntity be = (SchematicannonBlockEntity)menu.contentHolder;
        ConfigureSchematicannonPacket.Option option = packet.option();
        switch (option) {
            case DONT_REPLACE: 
            case REPLACE_ANY: 
            case REPLACE_EMPTY: 
            case REPLACE_SOLID: {
                be.replaceMode = option.ordinal();
                break;
            }
            case SKIP_MISSING: {
                be.skipMissing = packet.set();
                break;
            }
            case SKIP_BLOCK_ENTITIES: {
                be.replaceBlockEntities = packet.set();
                break;
            }
            case PLAY: {
                be.state = SchematicannonBlockEntity.State.RUNNING;
                be.statusMsg = "running";
                break;
            }
            case PAUSE: {
                be.state = SchematicannonBlockEntity.State.PAUSED;
                be.statusMsg = "paused";
                break;
            }
            case STOP: {
                be.state = SchematicannonBlockEntity.State.STOPPED;
                be.statusMsg = "stopped";
                break;
            }
        }
        be.sendUpdate = true;
    }

    private static void onBlockEntityConfiguration(ServerGamePacketListenerImpl listener, BlockPos pos, int distance, Predicate<BlockEntity> predicate) {
        ServerPlayer player = listener.player;
        if (player.isSpectator() || !player.mayBuild()) {
            return;
        }
        ServerLevel world = player.level();
        if (!world.isLoaded(pos)) {
            return;
        }
        if (!pos.closerThan((Vec3i)player.blockPosition(), (double)distance)) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (predicate.test(blockEntity)) {
            world.getChunkSource().blockChanged(pos);
            blockEntity.setChanged();
        }
    }

    public static void onConfigureThresholdSwitch(ServerGamePacketListenerImpl listener, ConfigureThresholdSwitchPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof ThresholdSwitchBlockEntity) {
                ThresholdSwitchBlockEntity be = (ThresholdSwitchBlockEntity)blockEntity;
                be.offWhenBelow = packet.offBelow();
                be.onWhenAbove = packet.onAbove();
                be.setInverted(packet.invert());
                be.inStacks = packet.inStacks();
                return true;
            }
            return false;
        });
    }

    public static void onConfigureSequencedGearshift(ServerGamePacketListenerImpl listener, ConfigureSequencedGearshiftPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof SequencedGearshiftBlockEntity) {
                SequencedGearshiftBlockEntity be = (SequencedGearshiftBlockEntity)blockEntity;
                be.run(-1);
                be.instructions = packet.instructions();
                return true;
            }
            return false;
        });
    }

    public static void onEjectorTrigger(ServerGamePacketListenerImpl listener, EjectorTriggerPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof EjectorBlockEntity) {
                EjectorBlockEntity be = (EjectorBlockEntity)blockEntity;
                be.activate();
                return true;
            }
            return false;
        });
    }

    public static void onStationEdit(ServerGamePacketListenerImpl listener, StationEditPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof StationBlockEntity) {
                StationBlockEntity be = (StationBlockEntity)blockEntity;
                ServerPlayer player = listener.player;
                Level level = be.getLevel();
                BlockPos blockPos = be.getBlockPos();
                BlockState blockState = level.getBlockState(blockPos);
                GlobalStation station = be.getStation();
                if (packet.dropSchedule()) {
                    if (station == null) {
                        return true;
                    }
                    be.dropSchedule(player, station.getPresentTrain());
                    return true;
                }
                if (packet.doorControl() != null) {
                    be.doorControls.set(packet.doorControl());
                }
                if (packet.name() != null && !packet.name().isBlank()) {
                    be.updateName(packet.name());
                }
                if (!(blockState.getBlock() instanceof StationBlock)) {
                    return true;
                }
                Boolean isAssemblyMode = (Boolean)blockState.getValue((Property)StationBlock.ASSEMBLING);
                boolean assemblyComplete = false;
                if (packet.tryAssemble() != null) {
                    if (!isAssemblyMode.booleanValue()) {
                        return true;
                    }
                    if (packet.tryAssemble().booleanValue()) {
                        be.assemble(player.getUUID());
                        assemblyComplete = station != null && station.getPresentTrain() != null;
                    } else if (be.tryDisassembleTrain(player) && be.tryEnterAssemblyMode()) {
                        be.refreshAssemblyInfo();
                    }
                    if (!assemblyComplete) {
                        return true;
                    }
                }
                if (packet.assemblyMode()) {
                    be.enterAssemblyMode(player);
                } else {
                    be.exitAssemblyMode();
                }
                return true;
            }
            return false;
        });
    }

    public static void onDisplayLinkConfiguration(ServerGamePacketListenerImpl listener, DisplayLinkConfigurationPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof DisplayLinkBlockEntity) {
                DisplayLinkBlockEntity be = (DisplayLinkBlockEntity)blockEntity;
                be.targetLine = packet.targetLine();
                CompoundTag configData = packet.configData();
                Identifier id = configData.read("Id", Identifier.CODEC).orElse(null);
                if (id == null) {
                    be.notifyUpdate();
                    return true;
                }
                DisplaySource source = DisplaySource.get(id);
                if (source == null) {
                    be.notifyUpdate();
                    return true;
                }
                if (be.activeSource == null || be.activeSource != source) {
                    be.activeSource = source;
                    be.setSourceConfig(configData.copy());
                } else {
                    be.getSourceConfig().merge(configData);
                }
                be.updateGatheredData();
                be.notifyUpdate();
                return true;
            }
            return false;
        });
    }

    public static void onCurvedTrackDestroy(ServerGamePacketListenerImpl listener, CurvedTrackDestroyPacket packet) {
        BlockPos pos = packet.pos();
        AllHandle.onBlockEntityConfiguration(listener, pos, (Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() + 16, blockEntity -> {
            if (blockEntity instanceof TrackBlockEntity) {
                TrackBlockEntity be = (TrackBlockEntity)blockEntity;
                ServerPlayer player = listener.player;
                ServerLevel world = player.level();
                int verifyDistance = (Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() * 4;
                if (!be.getBlockPos().closerThan((Vec3i)player.blockPosition(), (double)verifyDistance)) {
                    Create.LOGGER.warn(player.getScoreboardName() + " too far away from destroyed Curve track");
                    return true;
                }
                BlockPos targetPos = packet.targetPos();
                BezierConnection bezierConnection = be.getConnections().get(targetPos);
                be.removeConnection(targetPos);
                BlockEntity patt0$temp = world.getBlockEntity(targetPos);
                if (patt0$temp instanceof TrackBlockEntity) {
                    TrackBlockEntity other = (TrackBlockEntity)patt0$temp;
                    other.removeConnection(pos);
                }
                BlockState blockState = be.getBlockState();
                TrackPropagator.onRailRemoved((LevelAccessor)world, pos, blockState);
                if (packet.wrench()) {
                    AllSoundEvents.WRENCH_REMOVE.playOnServer((Level)world, (Vec3i)packet.soundSource(), 1.0f, world.random.nextFloat() * 0.5f + 0.5f);
                    if (!player.isCreative() && bezierConnection != null) {
                        bezierConnection.addItemsToPlayer((Player)player);
                    }
                } else if (!player.isCreative() && bezierConnection != null) {
                    bezierConnection.spawnItems((Level)world);
                }
                bezierConnection.spawnDestroyParticles((Level)world);
                SoundType soundtype = blockState.getSoundType();
                if (soundtype == null) {
                    return true;
                }
                world.playSound(null, packet.soundSource(), soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                return true;
            }
            return false;
        });
    }

    public static void onCurvedTrackSelection(ServerGamePacketListenerImpl listener, CurvedTrackSelectionPacket packet) {
        BlockPos pos = packet.pos();
        AllHandle.onBlockEntityConfiguration(listener, pos, (Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() + 16, blockEntity -> {
            if (blockEntity instanceof TrackBlockEntity) {
                TrackBlockEntity be = (TrackBlockEntity)blockEntity;
                ServerPlayer player = listener.player;
                ServerLevel world = player.level();
                if (player.getInventory().getSelectedSlot() != packet.slot()) {
                    return true;
                }
                ItemStack stack = player.getInventory().getItem(packet.slot());
                if (!(stack.getItem() instanceof TrackTargetingBlockItem)) {
                    return true;
                }
                if (player.isShiftKeyDown() && stack.has(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS)) {
                    player.displayClientMessage((Component)Component.translatable((String)"create.track_target.clear"), true);
                    stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
                    stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
                    stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
                    AllSoundEvents.CONTROLLER_CLICK.play((Level)world, null, (Vec3i)pos, 1.0f, 0.5f);
                    return true;
                }
                EdgePointType<TrackEdgePoint> type = stack.is((Item)AllItems.TRACK_SIGNAL) ? EdgePointType.SIGNAL : EdgePointType.STATION;
                MutableObject result = new MutableObject(null);
                BezierTrackPointLocation bezierTrackPointLocation = new BezierTrackPointLocation(packet.targetPos(), packet.segment());
                TrackTargetingBlockItem.withGraphLocation((Level)world, pos, packet.front(), bezierTrackPointLocation, type, (overlap, location) -> result.setValue((Object)overlap));
                if (((TrackTargetingBlockItem.OverlapResult)((Object)((Object)result.getValue()))).feedback != null) {
                    player.displayClientMessage((Component)Component.translatable((String)("create." + ((TrackTargetingBlockItem.OverlapResult)((Object)((Object)result.getValue()))).feedback)).withStyle(ChatFormatting.RED), true);
                    AllSoundEvents.DENY.play((Level)world, null, (Vec3i)pos, 0.5f, 1.0f);
                    return true;
                }
                stack.set(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS, (Object)pos);
                stack.set(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, (Object)packet.front());
                stack.set(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER, (Object)bezierTrackPointLocation);
                player.displayClientMessage((Component)Component.translatable((String)"create.track_target.set"), true);
                AllSoundEvents.CONTROLLER_CLICK.play((Level)world, null, (Vec3i)pos, 1.0f, 1.0f);
                return true;
            }
            return false;
        });
    }

    public static void onGaugeObserved(ServerGamePacketListenerImpl listener, GaugeObservedPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof StressGaugeBlockEntity) {
                StressGaugeBlockEntity be = (StressGaugeBlockEntity)blockEntity;
                be.onObserved();
            }
            return false;
        });
    }

    public static void onEjectorAward(ServerGamePacketListenerImpl listener, EjectorAwardPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof EjectorBlockEntity) {
                AllAdvancements.EJECTOR_MAXED.trigger(listener.player);
                return true;
            }
            return false;
        });
    }

    public static void onElevatorContactEdit(ServerGamePacketListenerImpl listener, ElevatorContactEditPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof ElevatorContactBlockEntity) {
                ElevatorContactBlockEntity be = (ElevatorContactBlockEntity)blockEntity;
                be.updateName(packet.shortName(), packet.longName());
                be.doorControls.set(packet.doorControl());
                return true;
            }
            return false;
        });
    }

    public static void onValueSettings(ServerGamePacketListenerImpl listener, ValueSettingsPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof SmartBlockEntity) {
                SmartBlockEntity be = (SmartBlockEntity)blockEntity;
                ServerPlayer player = listener.player;
                if (be instanceof FactoryPanelBlockEntity) {
                    FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)be;
                    for (ServerFactoryPanelBehaviour behaviour : fpbe.panels.values()) {
                        if (AllHandle.handleValueSettings(player, behaviour, packet)) break;
                    }
                } else {
                    ServerScrollValueBehaviour scrollValueBehaviour = be.getBehaviour(ServerScrollValueBehaviour.TYPE);
                    if (!AllHandle.handleValueSettings(player, scrollValueBehaviour, packet)) {
                        ServerFilteringBehaviour filteringBehaviour = be.getBehaviour(ServerFilteringBehaviour.TYPE);
                        AllHandle.handleValueSettings(player, filteringBehaviour, packet);
                    }
                }
                return true;
            }
            return false;
        });
    }

    private static boolean handleValueSettings(ServerPlayer player, ValueSettingsHandleBehaviour handle, ValueSettingsPacket packet) {
        if (handle == null || !handle.acceptsValueSettings() || packet.behaviourIndex() != handle.netId()) {
            return false;
        }
        if (packet.interactHand() != null) {
            handle.onShortInteract((Player)player, packet.interactHand(), packet.side(), packet.hitResult());
            return true;
        }
        handle.setValueSettings((Player)player, new ValueSettings(packet.row(), packet.value()), packet.ctrlDown());
        return true;
    }

    public static void onLogisticalStockRequest(ServerGamePacketListenerImpl listener, LogisticalStockRequestPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 4096, blockEntity -> {
            if (blockEntity instanceof StockCheckingBlockEntity) {
                StockCheckingBlockEntity be = (StockCheckingBlockEntity)blockEntity;
                be.getRecentSummary().divideAndSendTo(listener.player, packet.pos());
                return true;
            }
            return false;
        });
    }

    public static void onPackageOrderRequest(ServerGamePacketListenerImpl listener, PackageOrderRequestPacket packet) {
        ServerPlayer player = listener.player;
        ServerLevel world = player.level();
        BlockPos pos = packet.pos();
        AllHandle.onBlockEntityConfiguration(listener, pos, 20, blockEntity -> {
            if (blockEntity instanceof StockTickerBlockEntity) {
                StockTickerBlockEntity be = (StockTickerBlockEntity)blockEntity;
                PackageOrderWithCrafts order = packet.order();
                if (packet.encodeRequester()) {
                    if (!order.isEmpty()) {
                        AllSoundEvents.CONFIRM.playOnServer((Level)world, (Vec3i)pos);
                    }
                    player.closeContainer();
                    RedstoneRequesterBlock.programRequester(player, be, order, packet.address());
                    return true;
                }
                if (!order.isEmpty()) {
                    AllSoundEvents.STOCK_TICKER_REQUEST.playOnServer((Level)world, (Vec3i)pos);
                    AllAdvancements.STOCK_TICKER.trigger(player);
                    listener.server.getPlayerList().broadcast(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 32.0, world.dimension(), (Packet)new WiFiEffectPacket(pos));
                }
                be.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, order, null, packet.address());
                return true;
            }
            return false;
        });
    }

    public static void onChainConveyorConnection(ServerGamePacketListenerImpl listener, ChainConveyorConnectionPacket packet) {
        ServerPlayer player = listener.player;
        ServerLevel world = player.level();
        int maxRange = (Integer)AllConfigs.server().kinetics.maxChainConveyorLength.get() + 16;
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), maxRange, blockEntity -> {
            if (blockEntity instanceof ChainConveyorBlockEntity) {
                ChainConveyorBlockEntity be = (ChainConveyorBlockEntity)blockEntity;
                BlockPos targetPos = packet.targetPos();
                boolean connect = packet.connect();
                if (!be.getBlockPos().closerThan((Vec3i)targetPos, (double)(maxRange - 16 + 1))) {
                    return true;
                }
                BlockEntity patt0$temp = world.getBlockEntity(targetPos);
                if (!(patt0$temp instanceof ChainConveyorBlockEntity)) {
                    return true;
                }
                ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)patt0$temp;
                if (connect && !player.isCreative()) {
                    int chainCost = ChainConveyorBlockEntity.getChainCost(targetPos.subtract((Vec3i)be.getBlockPos()));
                    boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory((Player)player, packet.chain(), chainCost, true);
                    if (!hasEnough) {
                        return true;
                    }
                    ChainConveyorBlockEntity.getChainsFromInventory((Player)player, packet.chain(), chainCost, false);
                }
                if (!connect) {
                    if (!player.isCreative()) {
                        for (int chainCost = ChainConveyorBlockEntity.getChainCost(targetPos.subtract((Vec3i)packet.pos())); chainCost > 0; chainCost -= 64) {
                            player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)Items.IRON_CHAIN, Math.min(chainCost, 64)));
                        }
                    }
                    be.chainDestroyed(targetPos.subtract((Vec3i)be.getBlockPos()), false, true);
                    world.playSound(null, player.blockPosition(), SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS);
                }
                if (connect) {
                    if (!clbe.addConnectionTo(be.getBlockPos())) {
                        return true;
                    }
                } else {
                    clbe.removeConnectionTo(be.getBlockPos());
                }
                if (connect) {
                    if (!be.addConnectionTo(targetPos)) {
                        clbe.removeConnectionTo(be.getBlockPos());
                    }
                } else {
                    be.removeConnectionTo(targetPos);
                }
                return true;
            }
            return false;
        });
    }

    public static void onServerboundChainConveyorRiding(ServerGamePacketListenerImpl listener, ServerboundChainConveyorRidingPacket packet) {
        ServerPlayer sender = listener.player;
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), (Integer)AllConfigs.server().kinetics.maxChainConveyorLength.get() * 2, blockEntity -> {
            if (blockEntity instanceof ChainConveyorBlockEntity) {
                ChainConveyorBlockEntity be = (ChainConveyorBlockEntity)blockEntity;
                sender.fallDistance = 0.0;
                sender.connection.aboveGroundTickCount = 0;
                sender.connection.aboveGroundVehicleTickCount = 0;
                if (packet.stop()) {
                    ServerChainConveyorHandler.handleStopRidingPacket(listener.server, (Player)sender);
                } else {
                    ServerChainConveyorHandler.handleTTLPacket(listener.server, (Player)sender);
                }
                return true;
            }
            return false;
        });
    }

    public static void onChainPackageInteraction(ServerGamePacketListenerImpl listener, ChainPackageInteractionPacket packet) {
        ServerPlayer player = listener.player;
        int maxRange = (Integer)AllConfigs.server().kinetics.maxChainConveyorLength.get() + 16;
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), maxRange, blockEntity -> {
            if (blockEntity instanceof ChainConveyorBlockEntity) {
                ChainConveyorBlockEntity be = (ChainConveyorBlockEntity)blockEntity;
                BlockPos selectedConnection = packet.selectedConnection();
                float chainPosition = packet.chainPosition();
                if (packet.removingPackage()) {
                    List<ChainConveyorPackage> list;
                    float bestDiff = Float.POSITIVE_INFINITY;
                    ChainConveyorPackage best = null;
                    List<ChainConveyorPackage> list2 = list = selectedConnection.equals((Object)BlockPos.ZERO) ? be.getLoopingPackages() : be.getTravellingPackages().get(selectedConnection);
                    if (list == null || list.isEmpty()) {
                        return true;
                    }
                    for (ChainConveyorPackage liftPackage : list) {
                        float diff = Math.abs(selectedConnection == null ? AngleHelper.getShortestAngleDiff(liftPackage.chainPosition, chainPosition) : liftPackage.chainPosition - chainPosition);
                        if (diff > bestDiff) continue;
                        bestDiff = diff;
                        best = liftPackage;
                    }
                    if (player.getMainHandItem().isEmpty()) {
                        player.setItemInHand(InteractionHand.MAIN_HAND, best.item.copy());
                    } else {
                        player.getInventory().placeItemBackInInventory(best.item.copy());
                    }
                    list.remove(best);
                    be.sendData();
                } else {
                    ChainConveyorPackage chainConveyorPackage = new ChainConveyorPackage(chainPosition, player.getMainHandItem().copy());
                    if (!be.canAcceptPackagesFor(selectedConnection)) {
                        return true;
                    }
                    if (!player.isCreative()) {
                        player.getMainHandItem().shrink(1);
                        if (player.getMainHandItem().isEmpty()) {
                            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                        }
                    }
                    if (selectedConnection.equals((Object)BlockPos.ZERO)) {
                        be.addLoopingPackage(chainConveyorPackage);
                    } else {
                        be.addTravellingPackage(chainConveyorPackage, selectedConnection);
                    }
                }
                return true;
            }
            return false;
        });
    }

    public static void onPackagePortConfiguration(ServerGamePacketListenerImpl listener, PackagePortConfigurationPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof PackagePortBlockEntity) {
                PackagePortBlockEntity be = (PackagePortBlockEntity)blockEntity;
                if (be.addressFilter.equals(packet.newFilter()) && be.acceptsPackages == packet.acceptPackages()) {
                    return true;
                }
                be.addressFilter = packet.newFilter();
                be.acceptsPackages = packet.acceptPackages();
                be.filterChanged();
                return true;
            }
            return false;
        });
    }

    public static void onFactoryPanelConnection(ServerGamePacketListenerImpl listener, FactoryPanelConnectionPacket packet) {
        ServerPlayer player = listener.player;
        AllHandle.onBlockEntityConfiguration(listener, packet.toPos().pos(), 40, blockEntity -> {
            if (blockEntity instanceof FactoryPanelBlockEntity) {
                FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)blockEntity;
                ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)be.getLevel(), packet.toPos());
                if (behaviour != null) {
                    if (packet.relocate()) {
                        behaviour.moveTo(packet.fromPos(), player);
                    } else {
                        behaviour.addConnection(packet.fromPos());
                    }
                }
                return true;
            }
            return false;
        });
    }

    public static void onFactoryPanelConfiguration(ServerGamePacketListenerImpl listener, FactoryPanelConfigurationPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.position().pos(), 20, blockEntity -> {
            if (blockEntity instanceof FactoryPanelBlockEntity) {
                FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)blockEntity;
                ServerFactoryPanelBehaviour behaviour = be.panels.get((Object)packet.position().slot());
                if (behaviour == null) {
                    return false;
                }
                boolean reset = packet.reset();
                behaviour.recipeAddress = reset ? "" : packet.address();
                behaviour.recipeOutput = reset ? 1 : packet.outputAmount();
                behaviour.promiseClearingInterval = reset ? -1 : packet.promiseClearingInterval();
                List<Object> list = behaviour.activeCraftingArrangement = reset ? List.of() : packet.craftingArrangement();
                if (reset) {
                    behaviour.forceClearPromises = true;
                    behaviour.disconnectAll();
                    behaviour.setFilter(ItemStack.EMPTY);
                    behaviour.count = 0;
                    be.redraw = true;
                    return true;
                }
                if (packet.redstoneReset()) {
                    behaviour.disconnectAllLinks();
                    return true;
                }
                for (Map.Entry<FactoryPanelPosition, Integer> entry : packet.inputAmounts().entrySet()) {
                    FactoryPanelPosition key = entry.getKey();
                    FactoryPanelConnection connection = behaviour.targetedBy.get(key);
                    if (connection == null) continue;
                    connection.amount = entry.getValue();
                }
                FactoryPanelPosition removeConnection = packet.removeConnection();
                if (removeConnection != null) {
                    behaviour.targetedBy.remove(removeConnection);
                    behaviour.searchForCraftingRecipe();
                    ServerFactoryPanelBehaviour source = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)be.getLevel(), removeConnection);
                    if (source != null) {
                        source.targeting.remove(behaviour.getPanelPosition());
                        source.blockEntity.sendData();
                    }
                }
                if (packet.clearPromises()) {
                    behaviour.forceClearPromises = true;
                }
                return true;
            }
            return false;
        });
    }

    public static void onRedstoneRequesterConfiguration(ServerGamePacketListenerImpl listener, RedstoneRequesterConfigurationPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof RedstoneRequesterBlockEntity) {
                RedstoneRequesterBlockEntity be = (RedstoneRequesterBlockEntity)blockEntity;
                be.encodedTargetAdress = packet.address();
                List<BigItemStack> stacks = be.encodedRequest.stacks();
                List<Integer> amounts = packet.amounts();
                for (int i = 0; i < stacks.size() && i < amounts.size(); ++i) {
                    ItemStack stack = stacks.get((int)i).stack;
                    if (stack.isEmpty()) continue;
                    stacks.set(i, new BigItemStack(stack, amounts.get(i)));
                }
                if (!be.encodedRequest.orderedStacksMatchOrderedRecipes()) {
                    be.encodedRequest = PackageOrderWithCrafts.simple(be.encodedRequest.stacks());
                }
                be.allowPartialRequests = packet.allowPartial();
                return true;
            }
            return false;
        });
    }

    public static void onStockKeeperCategoryEdit(ServerGamePacketListenerImpl listener, StockKeeperCategoryEditPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof StockTickerBlockEntity) {
                StockTickerBlockEntity be = (StockTickerBlockEntity)blockEntity;
                be.categories = packet.schedule();
                return true;
            }
            return false;
        });
    }

    public static void onStockKeeperCategoryRefund(ServerGamePacketListenerImpl listener, StockKeeperCategoryRefundPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof StockTickerBlockEntity) {
                StockTickerBlockEntity be = (StockTickerBlockEntity)blockEntity;
                ItemStack filter = packet.filter();
                if (!filter.isEmpty() && filter.getItem() instanceof FilterItem) {
                    listener.player.getInventory().placeItemBackInInventory(filter);
                }
                return true;
            }
            return false;
        });
    }

    public static void onStockKeeperLock(ServerGamePacketListenerImpl listener, StockKeeperLockPacket packet) {
        ServerPlayer player = listener.player;
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof StockTickerBlockEntity) {
                StockTickerBlockEntity be = (StockTickerBlockEntity)blockEntity;
                if (!be.behaviour.mayAdministrate((Player)player)) {
                    return true;
                }
                LogisticsNetwork network = Create.LOGISTICS.logisticsNetworks.get(be.behaviour.freqId);
                if (network != null) {
                    network.locked = packet.lock();
                    Create.LOGISTICS.markDirty();
                }
                return true;
            }
            return false;
        });
    }

    public static void onStockKeeperCategoryHiding(ServerGamePacketListenerImpl listener, StockKeeperCategoryHidingPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            if (blockEntity instanceof StockTickerBlockEntity) {
                StockTickerBlockEntity be = (StockTickerBlockEntity)blockEntity;
                if (packet.indices().isEmpty()) {
                    be.hiddenCategoriesByPlayer.remove(listener.player.getUUID());
                    return false;
                }
                be.hiddenCategoriesByPlayer.put(listener.player.getUUID(), packet.indices());
                return true;
            }
            return false;
        });
    }

    public static void onSchematicPlace(ServerGamePacketListenerImpl listener, SchematicPlacePacket packet) {
        ServerPlayer player = listener.player;
        if (!player.isCreative()) {
            return;
        }
        ServerLevel world = player.level();
        SchematicPrinter printer = new SchematicPrinter();
        printer.loadSchematic(packet.stack(), (Level)world, !player.canUseGameMasterBlocks());
        if (!printer.isLoaded() || printer.isErrored()) {
            return;
        }
        boolean includeAir = (Boolean)AllConfigs.server().schematics.creativePrintIncludesAir.get();
        while (printer.advanceCurrentPos()) {
            if (!printer.shouldPlaceCurrent((Level)world)) continue;
            printer.handleCurrentTarget((pos, state, blockEntity) -> {
                boolean placingAir = state.isAir();
                if (placingAir && !includeAir) {
                    return;
                }
                CompoundTag data = BlockHelper.prepareBlockEntityData((Level)world, state, blockEntity);
                BlockHelper.placeSchematicBlock((Level)world, state, pos, null, data);
            }, (pos, entity) -> world.addFreshEntity(entity));
        }
    }

    public static void onSchematicUpload(ServerGamePacketListenerImpl listener, SchematicUploadPacket packet) {
        ServerPlayer player = listener.player;
        String schematic = packet.schematic();
        if (packet.code() == 0) {
            BlockPos pos = ((SchematicTableBlockEntity)((SchematicTableMenu)player.containerMenu).contentHolder).getBlockPos();
            Create.SCHEMATIC_RECEIVER.handleNewUpload(player, schematic, packet.size(), pos);
        } else if (packet.code() == 1) {
            Create.SCHEMATIC_RECEIVER.handleWriteRequest(player, schematic, packet.data());
        } else {
            Create.SCHEMATIC_RECEIVER.handleFinishedUpload(player, schematic);
        }
    }

    public static void onClearContainer(ServerGamePacketListenerImpl listener) {
        AbstractContainerMenu abstractContainerMenu = listener.player.containerMenu;
        if (!(abstractContainerMenu instanceof IClearableMenu)) {
            return;
        }
        IClearableMenu menu = (IClearableMenu)abstractContainerMenu;
        menu.clearContents();
    }

    public static void onFilterScreen(ServerGamePacketListenerImpl serverPlayNetworkHandler, FilterScreenPacket packet) {
        ServerPlayer player = serverPlayNetworkHandler.player;
        CompoundTag tag = packet.data() == null ? new CompoundTag() : packet.data();
        FilterScreenPacket.Option option = packet.option();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof FilterMenu) {
            FilterMenu c = (FilterMenu)abstractContainerMenu;
            if (option == FilterScreenPacket.Option.WHITELIST) {
                c.blacklist = false;
            }
            if (option == FilterScreenPacket.Option.BLACKLIST) {
                c.blacklist = true;
            }
            if (option == FilterScreenPacket.Option.RESPECT_DATA) {
                c.respectNBT = true;
            }
            if (option == FilterScreenPacket.Option.IGNORE_DATA) {
                c.respectNBT = false;
            }
            if (option == FilterScreenPacket.Option.UPDATE_FILTER_ITEM) {
                c.ghostInventory.setItem(tag.getIntOr("Slot", 0), tag.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY));
            }
        } else {
            abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof AttributeFilterMenu) {
                AttributeFilterMenu c = (AttributeFilterMenu)abstractContainerMenu;
                if (option == FilterScreenPacket.Option.WHITELIST) {
                    c.whitelistMode = AttributeFilterWhitelistMode.WHITELIST_DISJ;
                }
                if (option == FilterScreenPacket.Option.WHITELIST2) {
                    c.whitelistMode = AttributeFilterWhitelistMode.WHITELIST_CONJ;
                }
                if (option == FilterScreenPacket.Option.BLACKLIST) {
                    c.whitelistMode = AttributeFilterWhitelistMode.BLACKLIST;
                }
                if (option == FilterScreenPacket.Option.ADD_TAG) {
                    c.appendSelectedAttribute(ItemAttribute.loadStatic(packet.data(), (HolderLookup.Provider)player.registryAccess()), false);
                }
                if (option == FilterScreenPacket.Option.ADD_INVERTED_TAG) {
                    c.appendSelectedAttribute(ItemAttribute.loadStatic(packet.data(), (HolderLookup.Provider)player.registryAccess()), true);
                }
            } else {
                abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof PackageFilterMenu) {
                    PackageFilterMenu c = (PackageFilterMenu)abstractContainerMenu;
                    if (option == FilterScreenPacket.Option.UPDATE_ADDRESS) {
                        c.address = tag.getStringOr("Address", "");
                    }
                }
            }
        }
    }

    public static void onContraptionInteraction(ServerGamePacketListenerImpl listener, ContraptionInteractionPacket packet) {
        ServerPlayer sender = listener.player;
        Entity entityByID = sender.level().getEntity(packet.target());
        if (!(entityByID instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entityByID;
        AABB bb = contraptionEntity.getBoundingBox();
        double boundsExtra = Math.max(bb.getXsize(), bb.getYsize());
        double d = sender.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 10.0 + boundsExtra;
        if (!sender.hasLineOfSight(entityByID)) {
            d -= 3.0;
        }
        d *= d;
        if (sender.distanceToSqr(entityByID) > d) {
            return;
        }
        if (contraptionEntity.handlePlayerInteraction((Player)sender, packet.localPos(), packet.face(), packet.hand())) {
            sender.swing(packet.hand(), true);
        }
    }

    public static void onClientMotion(ServerGamePacketListenerImpl listener, ClientMotionPacket packet) {
        ServerPlayer sender = listener.player;
        sender.setDeltaMovement(packet.motion());
        sender.setOnGround(packet.onGround());
        if (packet.onGround()) {
            sender.causeFallDamage(sender.fallDistance, 1.0f, sender.damageSources().fall());
            sender.fallDistance = 0.0;
            sender.connection.aboveGroundTickCount = 0;
            sender.connection.aboveGroundVehicleTickCount = 0;
        }
        sender.level().getChunkSource().sendToTrackingPlayers((Entity)sender, (Packet)new LimbSwingUpdatePacket(sender.getId(), sender.position(), packet.limbSwing()));
    }

    public static void onArmPlacement(ServerGamePacketListenerImpl listener, ArmPlacementPacket packet) {
        ServerLevel world = listener.player.level();
        if (!world.isLoaded(packet.pos())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(packet.pos());
        if (!(blockEntity instanceof ArmBlockEntity)) {
            return;
        }
        ArmBlockEntity arm = (ArmBlockEntity)blockEntity;
        arm.interactionPointTag = packet.tag();
    }

    public static void onPackagePortPlacement(ServerGamePacketListenerImpl listener, PackagePortPlacementPacket packet) {
        ServerLevel world = listener.player.level();
        BlockPos pos = packet.pos();
        if (world == null || !world.isLoaded(pos)) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof PackagePortBlockEntity)) {
            return;
        }
        PackagePortBlockEntity ppbe = (PackagePortBlockEntity)blockEntity;
        PackagePortTarget target = packet.target();
        if (!target.canSupport(ppbe)) {
            return;
        }
        Vec3 targetLocation = target.getExactTargetLocation(ppbe, (LevelAccessor)world, pos);
        if (targetLocation == Vec3.ZERO || !targetLocation.closerThan((Position)Vec3.atBottomCenterOf((Vec3i)pos), (double)((Integer)AllConfigs.server().logistics.packagePortRange.get() + 2))) {
            return;
        }
        target.setup(ppbe, (LevelAccessor)world, pos);
        ppbe.target = target;
        ppbe.notifyUpdate();
        ppbe.use((Player)listener.player);
    }

    public static void onCouplingCreation(ServerGamePacketListenerImpl listener, CouplingCreationPacket packet) {
        CouplingHandler.tryToCoupleCarts((Player)listener.player, (Level)listener.player.level(), packet.id1(), packet.id2());
    }

    public static void onInstantSchematic(ServerGamePacketListenerImpl listener, InstantSchematicPacket packet) {
        Create.SCHEMATIC_RECEIVER.handleInstantSchematic(listener.player, packet.name(), (Level)listener.player.level(), packet.origin(), packet.bounds());
    }

    public static void onSchematicSync(ServerGamePacketListenerImpl listener, SchematicSyncPacket packet) {
        ServerPlayer player = listener.player;
        ItemStack stack = packet.slot() == -1 ? player.getMainHandItem() : player.getInventory().getItem(packet.slot());
        if (!stack.is((Item)AllItems.SCHEMATIC)) {
            return;
        }
        stack.set(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)packet.deployed());
        stack.set(AllDataComponents.SCHEMATIC_ANCHOR, (Object)packet.anchor());
        stack.set(AllDataComponents.SCHEMATIC_ROTATION, (Object)packet.rotation());
        stack.set(AllDataComponents.SCHEMATIC_MIRROR, (Object)packet.mirror());
        SchematicInstances.clearHash(stack);
    }

    public static void onLeftClick(ServerGamePacketListenerImpl listener) {
        ServerPlayer player = listener.player;
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof ZapperItem) {
            ZapperInteractionHandler.trySelect(stack, (Player)player);
        }
    }

    public static void onEjectorPlacement(ServerGamePacketListenerImpl listener, EjectorPlacementPacket packet) {
        BlockPos pos;
        ServerLevel world = listener.player.level();
        if (!world.isLoaded(pos = packet.pos())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockState state = world.getBlockState(pos);
        if (blockEntity instanceof EjectorBlockEntity) {
            EjectorBlockEntity ejector = (EjectorBlockEntity)blockEntity;
            ejector.setTarget(packet.h(), packet.v());
        }
        if (state.is((Block)AllBlocks.WEIGHTED_EJECTOR)) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EjectorBlock.HORIZONTAL_FACING, (Comparable)packet.facing()));
        }
    }

    public static void onEjectorElytra(ServerGamePacketListenerImpl listener, EjectorElytraPacket packet) {
        ServerLevel world = listener.player.level();
        if (!world.isLoaded(packet.pos())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(packet.pos());
        if (blockEntity instanceof EjectorBlockEntity) {
            EjectorBlockEntity ejector = (EjectorBlockEntity)blockEntity;
            ejector.deployElytra((Player)listener.player);
        }
    }

    private static void onLinkedController(ServerPlayer player, BlockPos pos, Consumer<BlockEntity> onLectern, Consumer<ItemStack> onStack) {
        if (pos != null) {
            if (onLectern != null) {
                onLectern.accept(player.level().getBlockEntity(pos));
            }
        } else if (onStack != null) {
            ItemStack controller = player.getMainHandItem();
            if (!controller.is((Item)AllItems.LINKED_CONTROLLER) && !(controller = player.getOffhandItem()).is((Item)AllItems.LINKED_CONTROLLER)) {
                return;
            }
            onStack.accept(controller);
        }
    }

    public static void onLinkedControllerInput(ServerGamePacketListenerImpl listener, LinkedControllerInputPacket packet) {
        ServerPlayer player = listener.player;
        Consumer<ItemStack> handleItem = stack -> {
            ServerLevel world = player.level();
            UUID uniqueID = player.getUUID();
            BlockPos pos = player.blockPosition();
            if (player.isSpectator() && packet.press()) {
                return;
            }
            LinkedControllerServerHandler.receivePressed((LevelAccessor)world, pos, uniqueID, packet.activatedButtons().stream().map(i -> LinkedControllerItem.toFrequency(stack, i)).collect(Collectors.toList()), packet.press());
        };
        AllHandle.onLinkedController(player, packet.lecternPos(), blockEntity -> {
            LecternControllerBlockEntity lectern;
            if (blockEntity instanceof LecternControllerBlockEntity && (lectern = (LecternControllerBlockEntity)blockEntity).isUsedBy((Player)player)) {
                handleItem.accept(lectern.getController());
            }
        }, handleItem);
    }

    public static void onLinkedControllerBind(ServerGamePacketListenerImpl listener, LinkedControllerBindPacket packet) {
        ServerPlayer player = listener.player;
        if (player.isSpectator()) {
            return;
        }
        AllHandle.onLinkedController(player, null, null, stack -> {
            ItemStackHandler frequencyItems = LinkedControllerItem.getFrequencyItems(stack);
            ServerLinkBehaviour linkBehaviour = BlockEntityBehaviour.get((BlockGetter)player.level(), packet.linkLocation(), ServerLinkBehaviour.TYPE);
            if (linkBehaviour == null) {
                return;
            }
            int button = packet.button();
            linkBehaviour.getNetworkKey().forEachWithContext((f, first) -> frequencyItems.setItem(button * 2 + (first != false ? 0 : 1), f.getStack().copy()));
            stack.set(AllDataComponents.LINKED_CONTROLLER_ITEMS, (Object)ItemHelper.containerContentsFromHandler(frequencyItems));
        });
    }

    public static void onLinkedControllerStopLectern(ServerGamePacketListenerImpl listener, LinkedControllerStopLecternPacket packet) {
        ServerPlayer player = listener.player;
        AllHandle.onLinkedController(player, packet.lecternPos(), blockEntity -> {
            if (blockEntity instanceof LecternControllerBlockEntity) {
                LecternControllerBlockEntity lectern = (LecternControllerBlockEntity)blockEntity;
                lectern.tryStopUsing((Player)player);
            }
        }, null);
    }

    public static void onGhostItemSubmit(ServerGamePacketListenerImpl listener, GhostItemSubmitPacket packet) {
        AbstractContainerMenu containerMenu = listener.player.containerMenu;
        int slot = packet.slot();
        ItemStack item = packet.item();
        if (containerMenu instanceof GhostItemMenu) {
            GhostItemMenu menu = (GhostItemMenu)containerMenu;
            menu.ghostInventory.setItem(slot, item);
            menu.getSlot(36 + slot).setChanged();
        } else if (containerMenu instanceof StockKeeperCategoryMenu) {
            StockKeeperCategoryMenu menu = (StockKeeperCategoryMenu)containerMenu;
            if (item.isEmpty() || item.getItem() instanceof FilterItem) {
                menu.proxyInventory.setItem(slot, item);
                menu.getSlot(36 + slot).setChanged();
            }
        }
    }

    public static void onBlueprintAssignCompleteRecipe(ServerGamePacketListenerImpl listener, BlueprintAssignCompleteRecipePacket packet) {
        ServerPlayer player = listener.player;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BlueprintMenu) {
            BlueprintMenu c = (BlueprintMenu)abstractContainerMenu;
            RecipeManager.ServerDisplayInfo serverRecipe = listener.server.getRecipeManager().getRecipeFromDisplay(packet.recipeId());
            if (serverRecipe != null) {
                // empty if block
            }
        }
    }

    public static void onConfigureSymmetryWand(ServerGamePacketListenerImpl listener, ConfigureSymmetryWandPacket packet) {
        ItemStack stack = listener.player.getItemInHand(packet.hand());
        if (stack.getItem() instanceof SymmetryWandItem) {
            SymmetryWandItem.configureSettings(stack, packet.mirror());
        }
    }

    public static void onConfigureWorldshaper(ServerGamePacketListenerImpl listener, ConfigureWorldshaperPacket packet) {
        ItemStack stack = listener.player.getItemInHand(packet.hand());
        if (stack.getItem() instanceof ZapperItem) {
            packet.configureZapper(stack);
        }
    }

    public static void onToolboxEquip(ServerGamePacketListenerImpl listener, ToolboxEquipPacket packet) {
        ServerPlayer player = listener.player;
        BlockPos toolboxPos = packet.toolboxPos();
        int slot = packet.slot();
        int hotbarSlot = packet.hotbarSlot();
        if (toolboxPos == null) {
            ToolboxHandler.unequip((Player)player, hotbarSlot, false);
            ToolboxHandler.syncData((Player)player, AllSynchedDatas.TOOLBOX.get((Entity)player));
            return;
        }
        ServerLevel world = player.level();
        BlockEntity blockEntity = world.getBlockEntity(toolboxPos);
        double maxRange = ToolboxHandler.getMaxRange((Player)player);
        if (player.distanceToSqr((double)toolboxPos.getX() + 0.5, (double)toolboxPos.getY(), (double)toolboxPos.getZ() + 0.5) > maxRange * maxRange) {
            return;
        }
        if (!(blockEntity instanceof ToolboxBlockEntity)) {
            return;
        }
        ToolboxBlockEntity toolboxBlockEntity = (ToolboxBlockEntity)blockEntity;
        ToolboxHandler.unequip((Player)player, hotbarSlot, false);
        if (slot < 0 || slot >= 8) {
            ToolboxHandler.syncData((Player)player, AllSynchedDatas.TOOLBOX.get((Entity)player));
            return;
        }
        Inventory playerInventory = player.getInventory();
        ItemStack playerStack = playerInventory.getItem(hotbarSlot);
        if (!playerStack.isEmpty() && !ToolboxInventory.canItemsShareCompartment(playerStack, (ItemStack)toolboxBlockEntity.inventory.filters.get(slot))) {
            toolboxBlockEntity.inventory.inLimitedMode(inventory -> {
                int count = playerStack.getCount();
                int insert = inventory.insertExist(playerStack);
                if (insert != count) {
                    count -= insert;
                    insert = playerInventory.insert(playerStack, count, Inventory.getSelectionSize(), 36);
                }
                if (insert == count) {
                    playerInventory.setItem(hotbarSlot, ItemStack.EMPTY);
                } else {
                    playerStack.setCount(count - insert);
                }
            });
        }
        CompoundTag compound = AllSynchedDatas.TOOLBOX.get((Entity)player);
        String key = String.valueOf(hotbarSlot);
        CompoundTag data = new CompoundTag();
        data.putInt("Slot", slot);
        data.store("Pos", BlockPos.CODEC, (Object)toolboxPos);
        compound.put(key, (Tag)data);
        toolboxBlockEntity.connectPlayer(slot, (Player)player, hotbarSlot);
        ToolboxHandler.syncData((Player)player, compound);
    }

    public static void onToolboxDisposeAll(ServerGamePacketListenerImpl listener, ToolboxDisposeAllPacket packet) {
        ServerPlayer player = listener.player;
        ServerLevel world = player.level();
        BlockPos toolboxPos = packet.toolboxPos();
        BlockEntity blockEntity = world.getBlockEntity(toolboxPos);
        double maxRange = ToolboxHandler.getMaxRange((Player)player);
        if (player.distanceToSqr((double)toolboxPos.getX() + 0.5, (double)toolboxPos.getY(), (double)toolboxPos.getZ() + 0.5) > maxRange * maxRange) {
            return;
        }
        if (!(blockEntity instanceof ToolboxBlockEntity)) {
            return;
        }
        ToolboxBlockEntity toolbox = (ToolboxBlockEntity)blockEntity;
        CompoundTag compound = AllSynchedDatas.TOOLBOX.get((Entity)player);
        MutableBoolean sendData = new MutableBoolean(false);
        Inventory playerInventory = player.getInventory();
        toolbox.inventory.inLimitedMode(inventory -> {
            for (int i = 0; i < 36; ++i) {
                ItemStack itemStack;
                int count;
                if (compound.getCompound(String.valueOf(i)).flatMap(nbt -> nbt.read("Pos", BlockPos.CODEC)).map(pos -> pos.equals((Object)toolboxPos)).orElse(false).booleanValue()) {
                    ToolboxHandler.unequip((Player)player, i, true);
                    sendData.setTrue();
                }
                if ((count = (itemStack = playerInventory.getItem(i)).getCount()) == 0) continue;
                int insert = toolbox.inventory.insertExist(itemStack, count);
                if (insert == count) {
                    playerInventory.setItem(i, ItemStack.EMPTY);
                    continue;
                }
                itemStack.setCount(count - insert);
            }
        });
        if (sendData.booleanValue()) {
            ToolboxHandler.syncData((Player)player, compound);
        }
    }

    public static void onScheduleEdit(ServerGamePacketListenerImpl listener, ScheduleEditPacket packet) {
        ServerPlayer sender = listener.player;
        ItemStack mainHandItem = sender.getMainHandItem();
        if (!mainHandItem.is((Item)AllItems.SCHEDULE)) {
            return;
        }
        if (packet.schedule().entries.isEmpty()) {
            mainHandItem.remove(AllDataComponents.TRAIN_SCHEDULE);
        } else {
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleEdit", Create.LOGGER);){
                TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)sender.registryAccess());
                packet.schedule().write((ValueOutput)view);
                mainHandItem.set(AllDataComponents.TRAIN_SCHEDULE, (Object)view.buildResult());
            }
        }
        sender.getCooldowns().addCooldown(mainHandItem, 5);
    }

    public static void onTrainEdit(ServerGamePacketListenerImpl listener, TrainEditPacket packet) {
        ServerPlayer sender = listener.player;
        ServerLevel world = sender.level();
        Train train = Create.RAILWAYS.sided((LevelAccessor)world).trains.get(packet.id());
        if (train == null) {
            return;
        }
        if (!packet.name().isBlank()) {
            train.name = Component.literal((String)packet.name());
        }
        train.icon = TrainIconType.byId(packet.iconType());
        train.mapColorIndex = packet.mapColor();
        listener.server.getPlayerList().broadcastAll((Packet)new TrainEditReturnPacket(packet.id(), packet.name(), packet.iconType(), packet.mapColor()));
    }

    public static void onTrainRelocation(ServerGamePacketListenerImpl listener, TrainRelocationPacket packet) {
        ServerPlayer sender = listener.player;
        Train train = Create.RAILWAYS.trains.get(packet.trainId());
        Entity entity = sender.level().getEntity(packet.entityId());
        String messagePrefix = sender.getName().getString() + " could not relocate Train ";
        if (train == null || !(entity instanceof CarriageContraptionEntity)) {
            Create.LOGGER.warn(messagePrefix + train.id.toString().substring(0, 5) + ": not present on server");
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
        if (!train.id.equals(cce.trainId)) {
            return;
        }
        int verifyDistance = (Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() * 2;
        if (!sender.position().closerThan((Position)Vec3.atCenterOf((Vec3i)packet.pos()), (double)verifyDistance)) {
            Create.LOGGER.warn(messagePrefix + train.name.getString() + ": player too far from clicked pos");
            return;
        }
        if (!sender.position().closerThan((Position)cce.position(), (double)verifyDistance + cce.getBoundingBox().getXsize() / 2.0)) {
            Create.LOGGER.warn(messagePrefix + train.name.getString() + ": player too far from carriage entity");
            return;
        }
        if (TrainRelocator.relocate(train, (Level)sender.level(), packet.pos(), packet.hoveredBezier(), packet.direction(), packet.lookAngle(), null)) {
            sender.displayClientMessage((Component)Component.translatable((String)"create.train.relocate.success").withStyle(ChatFormatting.GREEN), true);
            train.carriages.forEach(c -> c.forEachPresentEntity(e -> {
                e.nonDamageTicks = 10;
                listener.player.level().getChunkSource().sendToTrackingPlayers((Entity)e, (Packet)new ContraptionRelocationPacket(e.getId()));
            }));
            return;
        }
        Create.LOGGER.warn(messagePrefix + train.name.getString() + ": relocation failed server-side");
    }

    public static void onControlsInput(ServerGamePacketListenerImpl listener, ControlsInputPacket packet) {
        ServerPlayer player = listener.player;
        ServerLevel world = player.level();
        UUID uniqueID = player.getUUID();
        if (player.isSpectator() && packet.press()) {
            return;
        }
        Entity entity = world.getEntity(packet.contraptionEntityId());
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ace = (AbstractContraptionEntity)entity;
        if (packet.stopControlling()) {
            ace.stopControlling(packet.controlsPos());
            return;
        }
        if (ace.toGlobalVector(Vec3.atCenterOf((Vec3i)packet.controlsPos()), 0.0f).closerThan((Position)player.position(), 16.0)) {
            ControlsServerHandler.receivePressed((LevelAccessor)world, ace, packet.controlsPos(), uniqueID, packet.activatedButtons(), packet.press());
        }
    }

    public static void onPlaceExtendedCurve(ServerGamePacketListenerImpl listener, PlaceExtendedCurvePacket packet) {
        ItemStack stack = listener.player.getItemInHand(packet.mainHand() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        if (!stack.is(AllItemTags.TRACKS)) {
            return;
        }
        stack.set(AllDataComponents.TRACK_EXTENDED_CURVE, (Object)true);
    }

    public static void onSuperGlueSelection(ServerGamePacketListenerImpl listener, SuperGlueSelectionPacket packet) {
        ServerPlayer player = listener.player;
        ServerLevel world = player.level();
        double range = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 2.0;
        BlockPos to = packet.to();
        if (player.distanceToSqr(Vec3.atCenterOf((Vec3i)to)) > range * range) {
            return;
        }
        BlockPos from = packet.from();
        if (!to.closerThan((Vec3i)from, 25.0)) {
            return;
        }
        Set<BlockPos> group = SuperGlueSelectionHelper.searchGlueGroup((Level)world, from, to, false);
        if (group == null) {
            return;
        }
        if (!group.contains(to)) {
            return;
        }
        if (!SuperGlueSelectionHelper.collectGlueFromInventory((Player)player, 1, true)) {
            return;
        }
        AABB bb = SuperGlueEntity.span(from, to);
        SuperGlueSelectionHelper.collectGlueFromInventory((Player)player, 1, false);
        SuperGlueEntity entity = new SuperGlueEntity((Level)world, bb);
        world.addFreshEntity((Entity)entity);
        entity.spawnParticles();
        AllAdvancements.SUPER_GLUE.trigger(player);
    }

    public static void onSuperGlueRemoval(ServerGamePacketListenerImpl listener, SuperGlueRemovalPacket packet) {
        ServerPlayer player = listener.player;
        ServerLevel world = player.level();
        Entity entity = world.getEntity(packet.entityId());
        if (!(entity instanceof SuperGlueEntity)) {
            return;
        }
        SuperGlueEntity superGlue = (SuperGlueEntity)entity;
        double range = 32.0;
        if (player.distanceToSqr(superGlue.position()) > range * range) {
            return;
        }
        AllSoundEvents.SLIME_ADDED.play((Level)world, null, (Vec3i)packet.soundSource(), 0.5f, 0.5f);
        superGlue.spawnParticles();
        entity.discard();
    }

    public static void onTrainCollision(ServerGamePacketListenerImpl listener, TrainCollisionPacket packet) {
        ServerPlayer player = listener.player;
        ServerLevel world = player.level();
        Entity entity = world.getEntity(packet.contraptionEntityId());
        if (!(entity instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
        player.hurtServer(world, AllDamageSources.get((Level)world).runOver(cce), (float)packet.damage());
        world.playSound((Entity)player, entity.blockPosition(), SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.NEUTRAL, 1.0f, 0.75f);
    }

    public static void onTrainHUDUpdate(ServerGamePacketListenerImpl listener, TrainHUDUpdatePacket packet) {
        ServerPlayer player = listener.player;
        Train train = Create.RAILWAYS.sided((LevelAccessor)player.level()).trains.get(packet.trainId());
        if (train == null) {
            return;
        }
        if (packet.throttle() != null) {
            train.throttle = packet.throttle();
        }
    }

    public static void onTrainHonk(ServerGamePacketListenerImpl listener, HonkPacket packet) {
        ServerPlayer player = listener.player;
        Train train = Create.RAILWAYS.sided((LevelAccessor)player.level()).trains.get(packet.trainId());
        if (train == null) {
            return;
        }
        AllAdvancements.TRAIN_WHISTLE.trigger(player);
        listener.server.getPlayerList().broadcastAll((Packet)new HonkReturnPacket(train, packet.isHonk()));
    }

    public static void onTrackGraphRequest(ServerGamePacketListenerImpl listener, TrackGraphRequestPacket packet) {
        ServerPlayer player = listener.player;
        int netId = packet.netId();
        for (TrackGraph trackGraph : Create.RAILWAYS.trackNetworks.values()) {
            if (trackGraph.netId != netId) continue;
            Create.RAILWAYS.sync.sendFullGraphTo(trackGraph, player);
            break;
        }
    }

    public static void onElevatorRequestFloorList(ServerGamePacketListenerImpl listener, RequestFloorListPacket packet) {
        Entity entityByID = listener.player.level().getEntity(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ace = (AbstractContraptionEntity)entityByID;
        Contraption contraption = ace.getContraption();
        if (!(contraption instanceof ElevatorContraption)) {
            return;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        listener.send((Packet)new ElevatorFloorListPacket(ace, ec.namesList));
    }

    public static void onElevatorTargetFloor(ServerGamePacketListenerImpl listener, ElevatorTargetFloorPacket packet) {
        ServerPlayer sender = listener.player;
        ServerLevel world = sender.level();
        Entity entityByID = world.getEntity(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ace = (AbstractContraptionEntity)entityByID;
        Contraption contraption = ace.getContraption();
        if (!(contraption instanceof ElevatorContraption)) {
            return;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        if (ace.distanceToSqr((Entity)sender) > 2500.0) {
            return;
        }
        ElevatorColumn elevatorColumn = ElevatorColumn.get((LevelAccessor)world, ec.getGlobalColumn());
        if (elevatorColumn == null) {
            return;
        }
        int targetY = packet.targetY();
        if (!elevatorColumn.contacts.contains(targetY)) {
            return;
        }
        if (ec.isTargetUnreachable(targetY)) {
            return;
        }
        BlockPos pos = elevatorColumn.contactAt(targetY);
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!(block instanceof ElevatorContactBlock)) {
            return;
        }
        ElevatorContactBlock ecb = (ElevatorContactBlock)block;
        ecb.callToContactAndUpdate(elevatorColumn, blockState, (Level)world, pos, false);
    }

    public static void onClipboardEdit(ServerGamePacketListenerImpl listener, ClipboardEditPacket packet) {
        ServerPlayer sender = listener.player;
        ClipboardContent processedContent = AllHandle.clipboardProcessor(packet.clipboardContent());
        BlockPos targetedBlock = packet.targetedBlock();
        if (targetedBlock != null) {
            ServerLevel world = sender.level();
            if (!world.isLoaded(targetedBlock)) {
                return;
            }
            if (!targetedBlock.closerThan((Vec3i)sender.blockPosition(), 20.0)) {
                return;
            }
            BlockEntity blockEntity = world.getBlockEntity(targetedBlock);
            if (blockEntity instanceof ClipboardBlockEntity) {
                ClipboardBlockEntity cbe = (ClipboardBlockEntity)blockEntity;
                PatchedDataComponentMap map = new PatchedDataComponentMap(cbe.components());
                if (processedContent == null) {
                    map.remove(AllDataComponents.CLIPBOARD_CONTENT);
                } else {
                    map.set(AllDataComponents.CLIPBOARD_CONTENT, (Object)processedContent);
                }
                cbe.setComponents((DataComponentMap)map);
                cbe.onEditedBy((Player)sender);
            }
            return;
        }
        ItemStack itemStack = sender.getInventory().getItem(packet.hotbarSlot());
        if (!itemStack.is((Item)AllItems.CLIPBOARD)) {
            return;
        }
        if (processedContent == null) {
            itemStack.remove(AllDataComponents.CLIPBOARD_CONTENT);
        } else {
            itemStack.set(AllDataComponents.CLIPBOARD_CONTENT, (Object)processedContent);
        }
    }

    private static ClipboardContent clipboardProcessor(@Nullable ClipboardContent content) {
        if (content == null) {
            return null;
        }
        for (List<ClipboardEntry> page : content.pages()) {
            for (ClipboardEntry entry : page) {
                if (!NBTProcessors.textComponentHasClickEvent((Component)entry.text)) continue;
                return null;
            }
        }
        return content;
    }

    public static void onContraptionColliderLockRequest(ServerGamePacketListenerImpl listener, ContraptionColliderLockPacketRequest packet) {
        ServerPlayer player = listener.player;
        player.level().getChunkSource().sendToTrackingPlayers((Entity)player, (Packet)new ContraptionColliderLockPacket(packet.contraption(), packet.offset(), player.getId()));
    }

    public static void onRadialWrenchMenuSubmit(ServerGamePacketListenerImpl listener, RadialWrenchMenuSubmitPacket packet) {
        ServerLevel world = listener.player.level();
        BlockPos blockPos = packet.blockPos();
        BlockState newState = packet.newState();
        if (!world.getBlockState(blockPos).is(newState.getBlock())) {
            return;
        }
        BlockState updatedState = Block.updateFromNeighbourShapes((BlockState)newState, (LevelAccessor)world, (BlockPos)blockPos);
        KineticBlockEntity.switchToBlockState((Level)world, blockPos, updatedState);
        IWrenchable.playRotateSound((Level)world, blockPos);
    }

    public static void onTrainMapSyncRequest(ServerGamePacketListenerImpl listener) {
    }

    public static void onLinkSettings(ServerGamePacketListenerImpl listener, LinkSettingsPacket packet) {
        AllHandle.onBlockEntityConfiguration(listener, packet.pos(), 20, blockEntity -> {
            SmartBlockEntity be;
            ServerLinkBehaviour behaviour;
            if (blockEntity instanceof SmartBlockEntity && (behaviour = (be = (SmartBlockEntity)blockEntity).getBehaviour(ServerLinkBehaviour.TYPE)) != null) {
                behaviour.setFrequency(packet.first(), listener.player.getItemInHand(packet.hand()));
                return true;
            }
            return false;
        });
    }

    public static void onBlueprintPreviewRequest(ServerGamePacketListenerImpl listener, BlueprintPreviewRequestPacket packet) {
        Entity entity = listener.player.level().getEntity(packet.entityId());
        if (!(entity instanceof BlueprintEntity)) {
            listener.send((Packet)BlueprintPreviewPacket.EMPTY);
            return;
        }
        BlueprintEntity blueprint = (BlueprintEntity)entity;
        listener.send((Packet)BlueprintEntity.getPreview(blueprint, packet.index(), listener.player, packet.sneaking()));
    }
}

