/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AllSoundEvents {
    public static final SoundEntry SCHEMATICANNON_LAUNCH_BLOCK = AllSoundEvents.register("schematicannon_launch_block", SoundSource.BLOCKS, 0.1f, 1.1f);
    public static final SoundEntry SCHEMATICANNON_FINISH = AllSoundEvents.register("schematicannon_finish", SoundSource.BLOCKS, 1.0f, 0.7f);
    public static final SoundEntry DEPOT_SLIDE = AllSoundEvents.register("depot_slide", SoundSource.BLOCKS, 0.125f, 1.5f);
    public static final SoundEntry DEPOT_PLOP = AllSoundEvents.register("depot_plop", SoundSource.BLOCKS, 0.25f, 1.25f);
    public static final SoundEntry FUNNEL_FLAP = AllSoundEvents.register("funnel_flap", SoundSource.BLOCKS, 0.125f, 1.5f, 0.0425f, 0.75f);
    public static final SoundEntry PACKAGER = AllSoundEvents.register("packager", SoundSource.BLOCKS, 0.5f, 0.75f);
    public static final SoundEntry SLIME_ADDED = AllSoundEvents.register("slime_added", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION = AllSoundEvents.register("mechanical_press_activation", SoundSource.BLOCKS, 0.125f, 1.0f, 0.5f, 1.0f);
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION_ON_BELT = AllSoundEvents.register("mechanical_press_activation_belt", SoundSource.BLOCKS, 0.75f, 1.0f, 0.15f, 0.75f);
    public static final SoundEntry MIXING = AllSoundEvents.register("mixing", SoundSource.BLOCKS, 0.125f, 0.5f, 0.125f, 0.5f);
    public static final SoundEntry SPOUTING = AllSoundEvents.register("spout", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry CRANKING = AllSoundEvents.register("cranking", SoundSource.BLOCKS, 0.075f, 0.5f, 0.025f, 0.5f);
    public static final SoundEntry WORLDSHAPER_PLACE = AllSoundEvents.register("worldshaper_place", SoundSource.PLAYERS, new float[0]);
    public static final SoundEntry SCROLL_VALUE = AllSoundEvents.register("scroll_value", SoundSource.PLAYERS, 0.124f, 1.0f);
    public static final SoundEntry CONFIRM = AllSoundEvents.register("confirm", SoundSource.PLAYERS, 0.5f, 0.8f);
    public static final SoundEntry CONFIRM_2 = AllSoundEvents.register("confirm_2", SoundSource.PLAYERS, new float[0]);
    public static final SoundEntry DENY = AllSoundEvents.register("deny", SoundSource.PLAYERS, 1.0f, 0.5f);
    public static final SoundEntry COGS = AllSoundEvents.register("cogs", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry FWOOMP = AllSoundEvents.register("fwoomp", SoundSource.PLAYERS, new float[0]);
    public static final SoundEntry CARDBOARD_SWORD = AllSoundEvents.register("cardboard_bonk", SoundSource.PLAYERS, new float[0]);
    public static final SoundEntry FROGPORT_OPEN = AllSoundEvents.register("frogport_open", SoundSource.BLOCKS, 1.0f, 2.0f);
    public static final SoundEntry FROGPORT_CLOSE = AllSoundEvents.register("frogport_close", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry FROGPORT_CATCH = AllSoundEvents.register("frogport_catch", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry STOCK_LINK = AllSoundEvents.register("stock_link", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry FROGPORT_DEPOSIT = AllSoundEvents.register("frogport_deposit", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry POTATO_HIT = AllSoundEvents.register("potato_hit", SoundSource.PLAYERS, 0.75f, 0.75f, 0.75f, 1.25f);
    public static final SoundEntry CONTRAPTION_ASSEMBLE = AllSoundEvents.register("contraption_assemble", SoundSource.BLOCKS, 0.5f, 0.5f, 0.045f, 0.74f);
    public static final SoundEntry CONTRAPTION_DISASSEMBLE = AllSoundEvents.register("contraption_disassemble", SoundSource.BLOCKS, 0.35f, 0.75f);
    public static final SoundEntry WRENCH_ROTATE = AllSoundEvents.register("wrench_rotate", SoundSource.BLOCKS, 0.25f, 1.25f);
    public static final SoundEntry WRENCH_REMOVE = AllSoundEvents.register("wrench_remove", SoundSource.BLOCKS, 0.25f, 0.75f, 0.25f, 0.75f);
    public static final SoundEntry PACKAGE_POP = AllSoundEvents.register("package_pop", SoundSource.BLOCKS, 0.75f, 1.0f, 0.25f, 1.15f);
    public static final SoundEntry CRAFTER_CLICK = AllSoundEvents.register("crafter_click", SoundSource.BLOCKS, 0.25f, 1.0f, 0.125f, 1.0f);
    public static final SoundEntry CRAFTER_CRAFT = AllSoundEvents.register("crafter_craft", SoundSource.BLOCKS, 0.125f, 0.75f);
    public static final SoundEntry SANDING_SHORT = AllSoundEvents.register("sanding_short", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry SANDING_LONG = AllSoundEvents.register("sanding_long", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry CONTROLLER_CLICK = AllSoundEvents.register("controller_click", SoundSource.BLOCKS, 0.35f, 1.0f);
    public static final SoundEntry CONTROLLER_PUT = AllSoundEvents.register("controller_put", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry CONTROLLER_TAKE = AllSoundEvents.register("controller_take", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry SAW_ACTIVATE_WOOD = AllSoundEvents.register("saw_activate_wood", SoundSource.BLOCKS, 0.75f, 1.5f);
    public static final SoundEntry SAW_ACTIVATE_STONE = AllSoundEvents.register("saw_activate_stone", SoundSource.BLOCKS, 0.125f, 1.25f);
    public static final SoundEntry BLAZE_MUNCH = AllSoundEvents.register("blaze_munch", SoundSource.BLOCKS, 0.5f, 1.0f);
    public static final SoundEntry ITEM_HATCH = AllSoundEvents.register("item_hatch", SoundSource.BLOCKS, 0.25f, 1.4f, 0.75f, 1.15f);
    public static final SoundEntry CRUSHING_1 = AllSoundEvents.register("crushing_1", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry CRUSHING_2 = AllSoundEvents.register("crushing_2", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry CRUSHING_3 = AllSoundEvents.register("crushing_3", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry PECULIAR_BELL_USE = AllSoundEvents.register("peculiar_bell_use", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry DESK_BELL_USE = AllSoundEvents.register("desk_bell", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry WHISTLE_HIGH = AllSoundEvents.register("whistle_high", SoundSource.RECORDS, new float[0]);
    public static final SoundEntry WHISTLE_MEDIUM = AllSoundEvents.register("whistle", SoundSource.RECORDS, new float[0]);
    public static final SoundEntry WHISTLE_LOW = AllSoundEvents.register("whistle_low", SoundSource.RECORDS, new float[0]);
    public static final SoundEntry STEAM = AllSoundEvents.register("steam", SoundSource.NEUTRAL, new float[0]);
    public static final SoundEntry TRAIN = AllSoundEvents.register("train", SoundSource.NEUTRAL, new float[0]);
    public static final SoundEntry TRAIN2 = AllSoundEvents.register("train2", SoundSource.NEUTRAL, new float[0]);
    public static final SoundEntry TRAIN3 = AllSoundEvents.register("train3", SoundSource.NEUTRAL, new float[0]);
    public static final SoundEntry WHISTLE_TRAIN = AllSoundEvents.register("whistle_train", SoundSource.RECORDS, new float[0]);
    public static final SoundEntry WHISTLE_TRAIN_LOW = AllSoundEvents.register("whistle_train_low", SoundSource.RECORDS, new float[0]);
    public static final SoundEntry WHISTLE_TRAIN_MANUAL = AllSoundEvents.register("whistle_train_manual", SoundSource.NEUTRAL, new float[0]);
    public static final SoundEntry WHISTLE_TRAIN_MANUAL_LOW = AllSoundEvents.register("whistle_train_manual_low", SoundSource.NEUTRAL, new float[0]);
    public static final SoundEntry WHISTLE_TRAIN_MANUAL_END = AllSoundEvents.register("whistle_train_manual_end", SoundSource.NEUTRAL, new float[0]);
    public static final SoundEntry WHISTLE_TRAIN_MANUAL_LOW_END = AllSoundEvents.register("whistle_train_manual_low_end", SoundSource.NEUTRAL, new float[0]);
    public static final SoundEntry WHISTLE_CHIFF = AllSoundEvents.register("chiff", SoundSource.RECORDS, new float[0]);
    public static final SoundEntry HAUNTED_BELL_CONVERT = AllSoundEvents.register("haunted_bell_convert", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry HAUNTED_BELL_USE = AllSoundEvents.register("haunted_bell_use", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry STOCK_TICKER_REQUEST = AllSoundEvents.register("stock_ticker_request", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry STOCK_TICKER_TRADE = AllSoundEvents.register("stock_ticker_trade", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry CLIPBOARD_CHECKMARK = AllSoundEvents.register("clipboard_check", SoundSource.BLOCKS, new float[0]);
    public static final SoundEntry CLIPBOARD_ERASE = AllSoundEvents.register("clipboard_erase", SoundSource.BLOCKS, new float[0]);

    private static SoundEntry register(String name, SoundSource category, float ... data) {
        if (data.length == 0) {
            data = new float[]{1.0f, 1.0f};
        }
        Identifier id = Identifier.fromNamespaceAndPath((String)"create", (String)name);
        int count = data.length / 2;
        CompiledSoundEvent[] compiledEvents = new CompiledSoundEvent[count];
        SoundEvent event = (SoundEvent)Registry.register((Registry)BuiltInRegistries.SOUND_EVENT, (Identifier)id, (Object)SoundEvent.createVariableRangeEvent((Identifier)id));
        compiledEvents[0] = new CompiledSoundEvent(event, data[0], data[1]);
        int i = 2;
        for (int j = 1; j < count; ++j) {
            event = (SoundEvent)Registry.register((Registry)BuiltInRegistries.SOUND_EVENT, (Identifier)id.withSuffix("_compounded_" + j), (Object)SoundEvent.createVariableRangeEvent((Identifier)id));
            compiledEvents[j] = new CompiledSoundEvent(event, data[i], data[i + 1]);
            i += 2;
        }
        return new SoundEntry(category, compiledEvents);
    }

    public static void register() {
    }

    private record CompiledSoundEvent(SoundEvent event, float volume, float pitch) {
        public void play(Level world, Player entity, double x, double y, double z, SoundSource category, float volume, float pitch) {
            world.playSound((Entity)entity, x, y, z, this.event(), category, this.volume() * volume, this.pitch() * pitch);
        }

        public void playAt(Level world, double x, double y, double z, SoundSource category, float volume, float pitch, boolean fade) {
            world.playLocalSound(x, y, z, this.event(), category, this.volume() * volume, this.pitch() * pitch, fade);
        }
    }

    public record SoundEntry(SoundSource category, CompiledSoundEvent[] sounds) {
        public SoundEvent getMainEvent() {
            return this.sounds[0].event();
        }

        public void play(Level world, Player entity, double x, double y, double z, float volume, float pitch) {
            for (CompiledSoundEvent sound : this.sounds) {
                sound.play(world, entity, x, y, z, this.category, volume, pitch);
            }
        }

        public void playAt(Level world, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (CompiledSoundEvent sound : this.sounds) {
                sound.playAt(world, x, y, z, this.category, volume, pitch, fade);
            }
        }

        public void playOnServer(Level world, Vec3i pos) {
            this.playOnServer(world, pos, 1.0f, 1.0f);
        }

        public void playOnServer(Level world, Vec3i pos, float volume, float pitch) {
            this.play(world, null, pos, volume, pitch);
        }

        public void play(Level world, Player entity, Vec3i pos) {
            this.play(world, entity, pos, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity) {
            this.playFrom(entity, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity, float volume, float pitch) {
            if (!entity.isSilent()) {
                this.play(entity.level(), null, (Vec3i)entity.blockPosition(), volume, pitch);
            }
        }

        public void play(Level world, Player entity, Vec3i pos, float volume, float pitch) {
            this.play(world, entity, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, volume, pitch);
        }

        public void play(Level world, Player entity, Vec3 pos, float volume, float pitch) {
            this.play(world, entity, pos.x(), pos.y(), pos.z(), volume, pitch);
        }

        public void playAt(Level world, Vec3i pos, float volume, float pitch, boolean fade) {
            this.playAt(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, volume, pitch, fade);
        }

        public void playAt(Level world, Vec3 pos, float volume, float pitch, boolean fade) {
            this.playAt(world, pos.x(), pos.y(), pos.z(), volume, pitch, fade);
        }
    }
}

