/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.content.trains.entity.CarriageSyncData;
import com.zurrtum.create.content.trains.entity.CarriageSyncDataSerializer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ClassTreeIdRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;

public class AllSynchedDatas {
    private static final Map<Class<?>, SynchedData> ALL = new IdentityHashMap();
    private static final Map<Class<?>, Optional<SynchedData>> ON_DATA = new IdentityHashMap();
    public static final List<EntityDataSerializer<?>> HANDLERS = new ArrayList();
    public static final EntityDataSerializer<Optional<MinecartController>> MINECART_CONTROLLER_HANDLER = AllSynchedDatas.register(MinecartController.PACKET_CODEC.apply(ByteBufCodecs::optional));
    public static final EntityDataSerializer<Optional<UUID>> OPTIONAL_UUID_HANDLER = AllSynchedDatas.register(UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional));
    public static final EntityDataSerializer<Optional<List<ItemStack>>> CAPTURE_DROPS_HANDLER = AllSynchedDatas.register(ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).apply(ByteBufCodecs::optional));
    public static final EntityDataSerializer<CarriageSyncData> CARRIAGE_DATA_HANDLER = AllSynchedDatas.register(CarriageSyncDataSerializer::new);
    public static final EntityDataSerializer<Optional<Vec3>> OPTIONAL_VEC3D_HANDLER = AllSynchedDatas.register(Vec3.STREAM_CODEC.apply(ByteBufCodecs::optional));
    public static final EntityDataSerializer<CompoundTag> NBT_COMPOUND_HANDLER = AllSynchedDatas.register(ByteBufCodecs.TRUSTED_COMPOUND_TAG);
    public static final Entry<Integer> HAUNTING = AllSynchedDatas.register(Horse.class, EntityDataSerializers.INT, 0);
    public static final Entry<String> ITEM_TYPE = AllSynchedDatas.register(ItemEntity.class, EntityDataSerializers.STRING, "");
    public static final Entry<Integer> ITEM_TIME = AllSynchedDatas.register(ItemEntity.class, EntityDataSerializers.INT, 0);
    public static final Entry<Optional<BlockPos>> BYPASS_CRUSHING_WHEEL = AllSynchedDatas.register(ItemEntity.class, EntityDataSerializers.OPTIONAL_BLOCK_POS, Optional.empty());
    public static final Entry<Optional<MinecartController>> MINECART_CONTROLLER = AllSynchedDatas.register(AbstractMinecart.class, MINECART_CONTROLLER_HANDLER, Optional.empty(), (entity, value) -> value.ifPresent(controller -> controller.setCart((AbstractMinecart)entity)));
    public static final Entry<Integer> VISUAL_BACKTANK_AIR = AllSynchedDatas.register(Player.class, EntityDataSerializers.INT, 0);
    public static final Entry<Boolean> FIRE_IMMUNE = AllSynchedDatas.register(Player.class, EntityDataSerializers.BOOLEAN, false);
    public static final Entry<Boolean> HEAVY_BOOTS = AllSynchedDatas.register(Player.class, EntityDataSerializers.BOOLEAN, false);
    public static final Entry<Boolean> CRUSH_DROP = AllSynchedDatas.register(Entity.class, EntityDataSerializers.BOOLEAN, false);
    public static final Entry<Optional<List<ItemStack>>> CAPTURE_DROPS = AllSynchedDatas.register(Entity.class, CAPTURE_DROPS_HANDLER, Optional.empty());
    public static final Entry<Boolean> CONTRAPTION_GROUNDED = AllSynchedDatas.register(Entity.class, EntityDataSerializers.BOOLEAN, false);
    public static final Entry<Optional<Vec3>> CONTRAPTION_DISMOUNT_LOCATION = AllSynchedDatas.register(LivingEntity.class, OPTIONAL_VEC3D_HANDLER, Optional.empty());
    public static final Entry<Optional<Vec3>> CONTRAPTION_MOUNT_LOCATION = AllSynchedDatas.register(Player.class, OPTIONAL_VEC3D_HANDLER, Optional.empty());
    public static final Entry<Boolean> IS_USING_LECTERN_CONTROLLER = AllSynchedDatas.register(Player.class, EntityDataSerializers.BOOLEAN, false);
    public static final Entry<CompoundTag> TOOLBOX = AllSynchedDatas.register(Player.class, NBT_COMPOUND_HANDLER, new CompoundTag());
    public static final Entry<Integer> LAST_OVERRIDE_LIMB_SWING_UPDATE = AllSynchedDatas.register(Player.class, EntityDataSerializers.INT, -1);
    public static final Entry<Float> OVERRIDE_LIMB_SWING = AllSynchedDatas.register(Player.class, EntityDataSerializers.FLOAT, Float.valueOf(0.0f));
    public static final Entry<Boolean> PARROT_TRAIN_HAT = AllSynchedDatas.register(Parrot.class, EntityDataSerializers.BOOLEAN, false);

    private static <T> Entry<T> register(Class<? extends SyncedDataHolder> type, EntityDataSerializer<T> handler, T def) {
        return AllSynchedDatas.register(type, handler, def, null);
    }

    private static <E extends SyncedDataHolder, T> Entry<T> register(Class<E> type, EntityDataSerializer<T> handler, T def, BiConsumer<E, T> onData) {
        return ALL.computeIfAbsent(type, SynchedData::new).add(handler, def, onData);
    }

    private static <T> EntityDataSerializer<T> register(StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        EntityDataSerializer handler = EntityDataSerializer.forValueType(codec);
        HANDLERS.add(handler);
        return handler;
    }

    private static <T> EntityDataSerializer<T> register(Supplier<EntityDataSerializer<T>> factory) {
        EntityDataSerializer<T> handler = factory.get();
        HANDLERS.add(handler);
        return handler;
    }

    public static SynchedData get(Class<?> type) {
        return ALL.computeIfAbsent(type, SynchedData::new);
    }

    public static void onData(SyncedDataHolder entity, SynchedEntityData.DataValue<?> entry) {
        ON_DATA.computeIfAbsent(entity.getClass(), AllSynchedDatas::getParentOrEmpty).ifPresent(data -> data.onData(entity, entry));
    }

    private static Optional<SynchedData> getParentOrEmpty(Class<?> type) {
        while (type != Entity.class) {
            Optional<SynchedData> value = ON_DATA.get(type = type.getSuperclass());
            if (value == null) continue;
            return value;
        }
        return Optional.empty();
    }

    public static void register() {
    }

    public static class Entry<T> {
        private final EntityDataSerializer<T> handler;
        private final Supplier<T> def;
        private final BiConsumer<? extends SyncedDataHolder, T> listener;
        private BiFunction<Class<?>, Integer, Consumer<SynchedEntityData.DataItem<?>[]>> add = this::firstAdd;
        private Function<Entity, T> get;
        private TriConsumer<Entity, T, Boolean> set;

        private Entry(EntityDataSerializer<T> handler, T def, BiConsumer<? extends SyncedDataHolder, T> listener) {
            this.handler = handler;
            if (def instanceof CompoundTag) {
                CompoundTag nbt = (CompoundTag)def;
                this.def = () -> nbt.copy();
            } else {
                this.def = () -> def;
            }
            this.listener = listener;
        }

        private Consumer<SynchedEntityData.DataItem<?>[]> firstAdd(Class<?> type, int id) {
            EntityDataAccessor data = this.handler.createAccessor(id);
            this.get = target -> target.getEntityData().get(data);
            this.set = (target, value, force) -> target.getEntityData().set(data, value, force.booleanValue());
            this.add = (otherType, otherId) -> {
                IdentityHashMap<Class, EntityDataAccessor> map = new IdentityHashMap<Class, EntityDataAccessor>();
                map.put(type, data);
                this.get = target -> target.getEntityData().get((EntityDataAccessor)map.get(target.getClass()));
                this.set = (target, value, force) -> target.getEntityData().set((EntityDataAccessor)map.get(target.getClass()), value, force.booleanValue());
                this.add = (addType, addId) -> {
                    EntityDataAccessor addData = this.handler.createAccessor(addId.intValue());
                    map.put((Class)addType, addData);
                    return entries -> {
                        entries[addId.intValue()] = new SynchedEntityData.DataItem(addData, this.def.get());
                    };
                };
                return this.add.apply((Class<?>)otherType, (Integer)otherId);
            };
            return entries -> {
                entries[id] = new SynchedEntityData.DataItem(data, this.def.get());
            };
        }

        public Consumer<SynchedEntityData.DataItem<?>[]> add(Class<?> type, int id) {
            return this.add.apply(type, id);
        }

        public T get(Entity target) {
            return this.get.apply(target);
        }

        public void set(Entity target, T value) {
            this.set.accept((Object)target, value, (Object)false);
        }

        public void set(Entity target, T value, boolean force) {
            this.set.accept((Object)target, value, (Object)force);
        }
    }

    public static class SynchedData {
        private final Class<?> type;
        private final Deque<Entry<?>> datas = new ArrayDeque();
        private List<Consumer<SynchedEntityData.DataItem<?>[]>> actions;
        private Int2ObjectMap<BiConsumer<? extends SyncedDataHolder, ?>> listeners;
        private int size;

        public SynchedData(Class<?> type) {
            this.type = type;
        }

        public <E extends SyncedDataHolder, T> Entry<T> add(EntityDataSerializer<T> handler, T def, BiConsumer<E, T> onData) {
            Entry<T> entry = new Entry<T>(handler, def, onData);
            this.datas.add(entry);
            return entry;
        }

        private void preparse(int index, SynchedData parent) {
            if (parent != null) {
                if (this.datas.isEmpty()) {
                    this.datas.addAll(parent.datas);
                } else {
                    Iterator<Entry<?>> iterator = parent.datas.descendingIterator();
                    while (iterator.hasNext()) {
                        this.datas.addFirst(iterator.next());
                    }
                }
            }
            this.actions = new ArrayList<Consumer<SynchedEntityData.DataItem<?>[]>>(this.datas.size());
            for (Entry<?> task : this.datas) {
                if (task.listener != null) {
                    if (this.listeners == null) {
                        this.listeners = new Int2ObjectOpenHashMap();
                        ON_DATA.put(this.type, Optional.of(this));
                    }
                    this.listeners.put(index, task.listener);
                }
                this.actions.add(task.add(this.type, index++));
            }
            this.size = index;
        }

        public int preparse(ClassTreeIdRegistry map, BiFunction<ClassTreeIdRegistry, Class<?>, Integer> factory) {
            SynchedData data;
            if (this.size != 0) {
                return this.size;
            }
            ArrayDeque<SynchedData> parents = new ArrayDeque<SynchedData>();
            SynchedData parent = null;
            Class<?> key = this.type;
            while (key != Entity.class) {
                data = ALL.get(key = key.getSuperclass());
                if (data == null) continue;
                if (data.size != 0) {
                    parent = data;
                    break;
                }
                parents.addFirst(data);
            }
            while (!parents.isEmpty()) {
                data = (SynchedData)parents.pollFirst();
                data.preparse(factory.apply(map, data.type), parent);
                parent = data;
            }
            this.preparse(factory.apply(map, this.type), parent);
            return this.size;
        }

        public void register(SynchedEntityData.DataItem<?>[] entries) {
            this.actions.forEach(action -> action.accept(entries));
        }

        protected <E extends SyncedDataHolder, T> void onData(E entity, SynchedEntityData.DataValue<T> serializedEntry) {
            if (this.listeners == null) {
                return;
            }
            BiConsumer callback = (BiConsumer)this.listeners.get(serializedEntry.id());
            if (callback != null) {
                callback.accept(entity, serializedEntry.value());
            }
        }
    }
}

