/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.behaviour.display;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public interface DisplayHolder {
    public CompoundTag getDisplayLinkData();

    public void setDisplayLinkData(CompoundTag var1);

    default public void updateLine(int line, BlockPos pos) {
        CompoundTag data = this.getDisplayLinkData();
        if (data == null) {
            data = new CompoundTag();
            this.setDisplayLinkData(data);
        }
        data.store("Line" + line, BlockPos.CODEC, (Object)pos);
    }

    @Nullable
    default public BlockPos getLine(int line) {
        CompoundTag data = this.getDisplayLinkData();
        if (data == null) {
            return null;
        }
        return data.read("Line" + line, BlockPos.CODEC).orElse(null);
    }

    default public void removeLine(int line) {
        CompoundTag data = this.getDisplayLinkData();
        if (data == null) {
            return;
        }
        data.remove("Line" + line);
        if (data.isEmpty()) {
            this.setDisplayLinkData(null);
        }
    }

    default public void writeDisplayLink(ValueOutput view) {
        CompoundTag data = this.getDisplayLinkData();
        if (data == null) {
            return;
        }
        view.store("DisplayLink", CompoundTag.CODEC, (Object)data);
    }

    default public void readDisplayLink(ValueInput view) {
        CompoundTag data = view.read("DisplayLink", CompoundTag.CODEC).orElse(null);
        this.setDisplayLinkData(data);
    }
}

