/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.contraption.dispenser;

import com.zurrtum.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.impl.contraption.dispenser.DispenserBehaviorConverter;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Util;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

@FunctionalInterface
public interface MountedDispenseBehavior {
    public static final SimpleRegistry<Item, MountedDispenseBehavior> REGISTRY = (SimpleRegistry)Util.make(() -> {
        SimpleRegistry<Item, MountedDispenseBehavior> registry = SimpleRegistry.create();
        registry.registerProvider(DispenserBehaviorConverter.INSTANCE);
        return registry;
    });

    public ItemStack dispense(ItemStack var1, MovementContext var2, BlockPos var3);

    public static Vec3 getDispenserNormal(MovementContext ctx) {
        Direction facing = (Direction)ctx.state.getValue((Property)DispenserBlock.FACING);
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i());
        return ((Vec3)ctx.rotation.apply(normal)).normalize();
    }

    public static Direction getClosestFacingDirection(Vec3 facing) {
        return Direction.getApproximateNearest((double)facing.x, (double)facing.y, (double)facing.z);
    }

    public static void placeItemInInventory(ItemStack stack, MovementContext context, BlockPos pos) {
        CombinedInvWrapper contraption;
        int insert;
        int count = stack.getCount();
        if (count == 0) {
            return;
        }
        ItemStack toInsert = stack.copy();
        MountedItemStorage storage = context.getItemStorage();
        if (storage != null) {
            insert = storage.insert(toInsert);
            if (insert == count) {
                return;
            }
            if (insert > 0) {
                toInsert.setCount(count -= insert);
            }
        }
        if ((insert = (contraption = context.contraption.getStorage().getAllItems()).insert(toInsert)) == count) {
            return;
        }
        if (insert > 0) {
            toInsert.setCount(count - insert);
        }
        DefaultMountedDispenseBehavior.INSTANCE.dispense(toInsert, context, pos);
    }
}

