/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.contraption.storage.item.menu;

import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class StorageInteractionWrapper
implements ItemInventory {
    private final Container inv;
    private final Predicate<Player> stillValid;
    private final Consumer<ContainerUser> onClose;

    public StorageInteractionWrapper(Container inv, Predicate<Player> stillValid, Consumer<ContainerUser> onClose) {
        this.inv = inv;
        this.stillValid = stillValid;
        this.onClose = onClose;
    }

    public int getContainerSize() {
        return this.inv.getContainerSize();
    }

    public ItemStack getItem(int slot) {
        return this.inv.getItem(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inv.setItem(slot, stack);
    }

    public int getMaxStackSize() {
        return this.inv.getMaxStackSize();
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.inv.getMaxStackSize(stack);
    }

    public int insert(ItemStack stack) {
        return this.inv.insert(stack);
    }

    public int extract(ItemStack stack) {
        return this.inv.extract(stack);
    }

    @Override
    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }

    public void stopOpen(ContainerUser player) {
        this.onClose.accept(player);
    }
}

