/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.data;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class Iterate {
    public static final boolean[] trueAndFalse = new boolean[]{true, false};
    public static final boolean[] falseAndTrue = new boolean[]{false, true};
    public static final int[] zeroAndOne = new int[]{0, 1};
    public static final int[] positiveAndNegative = new int[]{1, -1};
    public static final Direction[] directions = Direction.values();
    public static final Direction[] horizontalDirections = Iterate.getHorizontals();
    public static final Direction.Axis[] axes = Direction.Axis.values();
    public static final EnumSet<Direction.Axis> axisSet = EnumSet.allOf(Direction.Axis.class);

    private static Direction[] getHorizontals() {
        Direction[] directions = new Direction[4];
        for (int i = 0; i < 4; ++i) {
            directions[i] = Direction.from2DDataValue((int)i);
        }
        return directions;
    }

    public static Direction[] directionsInAxis(Direction.Axis axis) {
        Direction[] directionArray;
        switch (axis) {
            case X: {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.EAST;
                directionArray = directionArray2;
                directionArray2[1] = Direction.WEST;
                break;
            }
            case Y: {
                Direction[] directionArray3 = new Direction[2];
                directionArray3[0] = Direction.UP;
                directionArray = directionArray3;
                directionArray3[1] = Direction.DOWN;
                break;
            }
            default: {
                Direction[] directionArray4 = new Direction[2];
                directionArray4[0] = Direction.SOUTH;
                directionArray = directionArray4;
                directionArray4[1] = Direction.NORTH;
            }
        }
        return directionArray;
    }

    public static List<BlockPos> hereAndBelow(BlockPos pos) {
        return Arrays.asList(pos, pos.below());
    }

    public static List<BlockPos> hereBelowAndAbove(BlockPos pos) {
        return Arrays.asList(pos, pos.below(), pos.above());
    }

    public static <T> T cycleValue(List<T> list, T current) {
        int currentIndex = list.indexOf(current);
        if (currentIndex == -1) {
            throw new IllegalArgumentException("Current value not found in list");
        }
        int nextIndex = (currentIndex + 1) % list.size();
        return list.get(nextIndex);
    }
}

