/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.math;

import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class AngleHelper {
    public static float horizontalAngle(Direction facing) {
        if (facing.getAxis().isVertical()) {
            return 0.0f;
        }
        float angle = facing.toYRot();
        if (facing.getAxis() == Direction.Axis.X) {
            angle = -angle;
        }
        return angle;
    }

    public static float verticalAngle(Direction facing) {
        return facing == Direction.UP ? -90.0f : (facing == Direction.DOWN ? 90.0f : 0.0f);
    }

    public static float rad(double angle) {
        if (angle == 0.0) {
            return 0.0f;
        }
        return (float)(angle / 180.0 * Math.PI);
    }

    public static float deg(double angle) {
        if (angle == 0.0) {
            return 0.0f;
        }
        return (float)(angle * 180.0 / Math.PI);
    }

    public static float angleLerp(double pct, double current, double target) {
        return (float)(current + (double)AngleHelper.getShortestAngleDiff(current, target) * pct);
    }

    public static float getShortestAngleDiff(double current, double target) {
        return (float)((((target %= 360.0) - (current %= 360.0)) % 360.0 + 540.0) % 360.0 - 180.0);
    }

    public static float getShortestAngleDiff(double current, double target, float hint) {
        float diff = AngleHelper.getShortestAngleDiff(current, target);
        if (Mth.equal((float)Math.abs(diff), (float)180.0f) && Math.signum(diff) != Math.signum(hint)) {
            return diff + 360.0f * Math.signum(hint);
        }
        return diff;
    }

    public static float wrapAngle180(float angle) {
        return (angle + 180.0f) % 360.0f - 180.0f;
    }
}

