/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.registry;

import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class RegisteredObjectsHelper {
    public static <V> Identifier getKeyOrThrow(Registry<V> registry, V value) {
        Identifier key = registry.getKey(value);
        if (key == null) {
            throw new IllegalArgumentException("Could not get key for value " + String.valueOf(value) + "!");
        }
        return key;
    }

    public static Identifier getKeyOrThrow(Block value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.BLOCK, value);
    }

    public static Identifier getKeyOrThrow(Item value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.ITEM, value);
    }

    public static Identifier getKeyOrThrow(Fluid value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.FLUID, value);
    }

    public static Identifier getKeyOrThrow(EntityType<?> value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.ENTITY_TYPE, value);
    }

    public static Identifier getKeyOrThrow(BlockEntityType<?> value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.BLOCK_ENTITY_TYPE, value);
    }

    public static Identifier getKeyOrThrow(Potion value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.POTION, value);
    }

    public static Identifier getKeyOrThrow(ParticleType<?> value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.PARTICLE_TYPE, value);
    }

    public static Identifier getKeyOrThrow(RecipeSerializer<?> value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.RECIPE_SERIALIZER, value);
    }

    public static Item getItem(Identifier location) {
        return (Item)BuiltInRegistries.ITEM.getValue(location);
    }

    public static Block getBlock(Identifier location) {
        return (Block)BuiltInRegistries.BLOCK.getValue(location);
    }

    @Nullable
    public static ItemLike getItemOrBlock(Identifier location) {
        Item item = RegisteredObjectsHelper.getItem(location);
        if (item != Items.AIR) {
            return item;
        }
        Block block = RegisteredObjectsHelper.getBlock(location);
        if (block != Blocks.AIR) {
            return block;
        }
        return null;
    }

    public static Identifier getKeyOrThrow(ItemLike itemLike) {
        if (itemLike instanceof Item) {
            Item item = (Item)itemLike;
            return RegisteredObjectsHelper.getKeyOrThrow(item);
        }
        if (itemLike instanceof Block) {
            Block block = (Block)itemLike;
            return RegisteredObjectsHelper.getKeyOrThrow(block);
        }
        throw new IllegalArgumentException("Could not get key for itemLike " + String.valueOf(itemLike) + "!");
    }
}

