/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.TranslatingContraption;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.collision.ContinuousOBBCollider;
import com.zurrtum.create.foundation.collision.Matrix3d;
import com.zurrtum.create.foundation.collision.OrientedBB;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class ContraptionCollider {
    static void collideEntities(AbstractContraptionEntity contraptionEntity) {
        Level world = contraptionEntity.level();
        Contraption contraption = contraptionEntity.getContraption();
        AABB bounds = contraptionEntity.getBoundingBox();
        if (contraption == null) {
            return;
        }
        if (bounds == null) {
            return;
        }
        Vec3 contraptionPosition = contraptionEntity.position();
        Vec3 contraptionMotion = contraptionPosition.subtract(contraptionEntity.getPrevPositionVec());
        Vec3 anchorVec = contraptionEntity.getAnchorVec();
        AbstractContraptionEntity.ContraptionRotationState rotation = null;
        List entitiesWithinAABB = world.getEntitiesOfClass(Entity.class, bounds.inflate(2.0).expandTowards(0.0, 32.0, 0.0), contraptionEntity::canCollideWith);
        for (Entity entity : entitiesWithinAABB) {
            double idealVerticalMotion;
            boolean anyCollision;
            Vec3 entityMotion;
            if (!entity.isAlive()) continue;
            PlayerType playerType = ContraptionCollider.getPlayerType(entity);
            entity.getSelfAndPassengers().forEach(e -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer playerEntity = (ServerPlayer)e;
                    playerEntity.connection.aboveGroundTickCount = 0;
                }
            });
            if (playerType == PlayerType.SERVER) continue;
            if (rotation == null) {
                rotation = contraptionEntity.getRotationState();
            }
            Matrix3d rotationMatrix = rotation.asMatrix();
            Vec3 entityPosition = entity.position();
            AABB entityBounds = entity.getBoundingBox();
            Vec3 motion = entity.getDeltaMovement();
            float yawOffset = rotation.getYawOffset();
            Vec3 position = ContraptionCollider.getWorldToLocalTranslation(entity, anchorVec, rotationMatrix, yawOffset);
            motion = motion.subtract(contraptionMotion);
            motion = rotationMatrix.transform(motion);
            AABB localBB = entityBounds.move(position).inflate(1.0E-7);
            OrientedBB obb = new OrientedBB(localBB);
            obb.setRotation(rotationMatrix);
            Vec3 motionCopy = motion;
            List collidableBBs = contraption.getSimplifiedEntityColliders().orElseGet(() -> {
                ArrayList bbs = new ArrayList();
                List<VoxelShape> potentialHits = ContraptionCollider.getPotentiallyCollidedShapes(world, contraption, localBB.expandTowards(motionCopy));
                potentialHits.forEach(shape -> bbs.addAll(shape.toAabbs()));
                return bbs;
            });
            MutableObject collisionResponse = new MutableObject((Object)Vec3.ZERO);
            MutableObject normal = new MutableObject((Object)Vec3.ZERO);
            MutableObject location = new MutableObject((Object)Vec3.ZERO);
            MutableBoolean surfaceCollision = new MutableBoolean(false);
            MutableFloat temporalResponse = new MutableFloat(1.0f);
            Vec3 obbCenter = obb.getCenter();
            boolean doHorizontalPass = !rotation.hasVerticalRotation();
            for (boolean horizontalPass : Iterate.trueAndFalse) {
                boolean noVerticalCollision;
                boolean verticalPass = !horizontalPass || !doHorizontalPass;
                for (AABB bb : collidableBBs) {
                    boolean nearest;
                    Vec3 separation;
                    double timeOfImpact;
                    Vec3 currentResponse = (Vec3)collisionResponse.getValue();
                    Vec3 currentCenter = obbCenter.add(currentResponse);
                    if (Math.abs(currentCenter.x - bb.getCenter().x) - entityBounds.getXsize() - 1.0 > bb.getXsize() / 2.0 || Math.abs(currentCenter.y + motion.y - bb.getCenter().y) - entityBounds.getYsize() - 1.0 > bb.getYsize() / 2.0 || Math.abs(currentCenter.z - bb.getCenter().z) - entityBounds.getZsize() - 1.0 > bb.getZsize() / 2.0) continue;
                    obb.setCenter(currentCenter);
                    ContinuousOBBCollider.ContinuousSeparationManifold intersect = obb.intersect(bb, motion);
                    if (intersect == null) continue;
                    if (verticalPass && surfaceCollision.isFalse()) {
                        surfaceCollision.setValue(intersect.isSurfaceCollision());
                    }
                    boolean isTemporal = (timeOfImpact = intersect.getTimeOfImpact()) > 0.0 && timeOfImpact < 1.0;
                    Vec3 collidingNormal = intersect.getCollisionNormal();
                    Vec3 collisionPosition = intersect.getCollisionPosition();
                    if (!isTemporal && (separation = intersect.asSeparationVec(entity.maxUpStep())) != null && !separation.equals((Object)Vec3.ZERO)) {
                        collisionResponse.setValue((Object)currentResponse.add(separation));
                        timeOfImpact = 0.0;
                    }
                    boolean bl = nearest = timeOfImpact >= 0.0 && (double)temporalResponse.getValue().floatValue() > timeOfImpact;
                    if (collidingNormal != null && nearest) {
                        normal.setValue((Object)collidingNormal);
                    }
                    if (collisionPosition != null && nearest) {
                        location.setValue((Object)collisionPosition);
                    }
                    if (!isTemporal || !((double)temporalResponse.getValue().floatValue() > timeOfImpact)) continue;
                    temporalResponse.setValue((Number)timeOfImpact);
                }
                if (verticalPass) break;
                boolean noVerticalMotionResponse = temporalResponse.getValue().floatValue() == 1.0f;
                boolean bl = noVerticalCollision = ((Vec3)collisionResponse.getValue()).y == 0.0;
                if (noVerticalCollision && noVerticalMotionResponse) break;
                collisionResponse.setValue((Object)((Vec3)collisionResponse.getValue()).multiply(1.0078125, 0.0, 1.0078125));
            }
            Vec3 entityMotionNoTemporal = entityMotion = entity.getDeltaMovement();
            Vec3 collisionNormal = (Vec3)normal.getValue();
            Vec3 collisionLocation = (Vec3)location.getValue();
            Vec3 totalResponse = (Vec3)collisionResponse.getValue();
            boolean hardCollision = !totalResponse.equals((Object)Vec3.ZERO);
            boolean temporalCollision = temporalResponse.getValue().floatValue() != 1.0f;
            Vec3 motionResponse = !temporalCollision ? motion : motion.normalize().scale(motion.length() * (double)temporalResponse.getValue().floatValue());
            rotationMatrix.transpose();
            motionResponse = rotationMatrix.transform(motionResponse).add(contraptionMotion);
            totalResponse = rotationMatrix.transform(totalResponse);
            totalResponse = VecHelper.rotate(totalResponse, yawOffset, Direction.Axis.Y);
            collisionNormal = rotationMatrix.transform(collisionNormal);
            collisionNormal = VecHelper.rotate(collisionNormal, yawOffset, Direction.Axis.Y);
            collisionNormal = collisionNormal.normalize();
            collisionLocation = rotationMatrix.transform(collisionLocation);
            collisionLocation = VecHelper.rotate(collisionLocation, yawOffset, Direction.Axis.Y);
            rotationMatrix.transpose();
            double bounce = 0.0;
            double slide = 0.0;
            if (!collisionLocation.equals((Object)Vec3.ZERO)) {
                BlockState blockState;
                collisionLocation = collisionLocation.add(entity.position().add(entity.getBoundingBox().getCenter()).scale(0.5));
                if (temporalCollision) {
                    collisionLocation = collisionLocation.add(0.0, motionResponse.y, 0.0);
                }
                BlockPos pos = BlockPos.containing((Position)contraptionEntity.toLocalVector(entity.position(), 0.0f));
                if (contraption.getBlocks().containsKey(pos) && (blockState = contraption.getBlocks().get(pos).state()).is(BlockTags.CLIMBABLE)) {
                    surfaceCollision.setTrue();
                    totalResponse = totalResponse.add(0.0, (double)0.1f, 0.0);
                }
                pos = BlockPos.containing((Position)contraptionEntity.toLocalVector(collisionLocation, 0.0f));
                if (contraption.getBlocks().containsKey(pos)) {
                    blockState = contraption.getBlocks().get(pos).state();
                    MovingInteractionBehaviour movingInteractionBehaviour = contraption.interactors.get(pos);
                    if (movingInteractionBehaviour != null) {
                        movingInteractionBehaviour.handleEntityCollision(entity, pos, contraptionEntity);
                    }
                    bounce = BlockHelper.getBounceMultiplier(blockState.getBlock());
                    slide = Math.max(0.0f, blockState.getBlock().getFriction() - 0.6f);
                }
            }
            boolean hasNormal = !collisionNormal.equals((Object)Vec3.ZERO);
            boolean bl = anyCollision = hardCollision || temporalCollision;
            if (bounce > 0.0 && hasNormal && anyCollision && ContraptionCollider.bounceEntity(entity, collisionNormal, contraptionEntity, bounce)) {
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.SLIME_BLOCK_FALL, SoundSource.BLOCKS, 0.5f, 1.0f);
                continue;
            }
            if (temporalCollision && (idealVerticalMotion = motionResponse.y) != entityMotion.y) {
                entity.setDeltaMovement(entityMotion.multiply(1.0, 0.0, 1.0).add(0.0, idealVerticalMotion, 0.0));
                entityMotion = entity.getDeltaMovement();
            }
            if (hardCollision) {
                double motionX = entityMotion.x();
                double motionY = entityMotion.y();
                double motionZ = entityMotion.z();
                double intersectX = totalResponse.x();
                double intersectY = totalResponse.y();
                double intersectZ = totalResponse.z();
                double horizonalEpsilon = 0.0078125;
                if (motionX != 0.0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0.0 == intersectX < 0.0) {
                    entityMotion = entityMotion.multiply(0.0, 1.0, 1.0);
                }
                if (motionY != 0.0 && intersectY != 0.0 && motionY > 0.0 == intersectY < 0.0) {
                    entityMotion = entityMotion.multiply(1.0, 0.0, 1.0).add(0.0, contraptionMotion.y, 0.0);
                }
                if (motionZ != 0.0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0.0 == intersectZ < 0.0) {
                    entityMotion = entityMotion.multiply(1.0, 1.0, 0.0);
                }
            }
            if (bounce == 0.0 && slide > 0.0 && hasNormal && anyCollision && rotation.hasVerticalRotation()) {
                double slideFactor = collisionNormal.multiply(1.0, 0.0, 1.0).length() * 1.25;
                Vec3 motionIn = entityMotionNoTemporal.multiply(0.0, 0.9, 0.0).add(0.0, (double)-0.01f, 0.0);
                Vec3 slideNormal = collisionNormal.cross(motionIn.cross(collisionNormal)).normalize();
                Vec3 newMotion = entityMotion.multiply(0.85, 0.0, 0.85).add(slideNormal.scale(((double)0.2f + slide) * motionIn.length() * slideFactor).add(0.0, (double)-0.1f - collisionNormal.y * 0.125, 0.0));
                entity.setDeltaMovement(newMotion);
                entityMotion = entity.getDeltaMovement();
            }
            if (!hardCollision && surfaceCollision.isFalse()) continue;
            Vec3 allowedMovement = ContraptionCollider.collide(totalResponse, entity);
            entity.setPos(entityPosition.x + allowedMovement.x, entityPosition.y + allowedMovement.y, entityPosition.z + allowedMovement.z);
            entityPosition = entity.position();
            entityMotion = ContraptionCollider.handleDamageFromTrain(world, contraptionEntity, contraptionMotion, entity, entityMotion, playerType);
            entity.hurtMarked = true;
            if (surfaceCollision.isTrue()) {
                boolean canWalk;
                contraptionEntity.registerColliding(entity);
                entity.fallDistance = 0.0;
                boolean bl2 = canWalk = bounce != 0.0 || slide == 0.0;
                if (canWalk || !rotation.hasVerticalRotation()) {
                    if (canWalk) {
                        entity.setOnGround(true);
                    }
                    if (entity instanceof ItemEntity) {
                        entityMotion = entityMotion.multiply(0.5, 1.0, 0.5);
                    }
                }
                Vec3 contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
                allowedMovement = ContraptionCollider.collide(contactPointMotion, entity);
                entity.setPos(entityPosition.x + allowedMovement.x, entityPosition.y, entityPosition.z + allowedMovement.z);
            }
            entity.setDeltaMovement(entityMotion);
        }
    }

    private static Vec3 handleDamageFromTrain(Level world, AbstractContraptionEntity contraptionEntity, Vec3 contraptionMotion, Entity entity, Vec3 entityMotion, PlayerType playerType) {
        Player p;
        if (!(contraptionEntity instanceof CarriageContraptionEntity)) {
            return entityMotion;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)contraptionEntity;
        if (!entity.onGround()) {
            return entityMotion;
        }
        if (AllSynchedDatas.CONTRAPTION_GROUNDED.get(entity).booleanValue()) {
            AllSynchedDatas.CONTRAPTION_GROUNDED.set(entity, false);
            return entityMotion;
        }
        if (cce.collidingEntities.containsKey(entity)) {
            return entityMotion;
        }
        if (entity instanceof ItemEntity) {
            return entityMotion;
        }
        if (cce.nonDamageTicks != 0) {
            return entityMotion;
        }
        if (!((Boolean)AllConfigs.server().trains.trainsCauseDamage.get()).booleanValue()) {
            return entityMotion;
        }
        Vec3 diffMotion = contraptionMotion.subtract(entity.getDeltaMovement());
        if (diffMotion.length() <= (double)0.35f || contraptionMotion.length() <= (double)0.35f) {
            return entityMotion;
        }
        DamageSource source = AllDamageSources.get(world).runOver(contraptionEntity);
        double damage = diffMotion.length();
        if (entity.getType().getCategory() == MobCategory.MONSTER) {
            damage *= 2.0;
        }
        if (entity instanceof Player && ((p = (Player)entity).isCreative() || p.isSpectator())) {
            return entityMotion;
        }
        if (playerType != PlayerType.CLIENT) {
            ServerLevel serverWorld = (ServerLevel)world;
            entity.hurtServer(serverWorld, source, (float)((int)(damage * 16.0)));
            serverWorld.playSound(null, entity.blockPosition(), SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.NEUTRAL, 1.0f, 0.75f);
            if (!entity.isAlive()) {
                contraptionEntity.getControllingPlayer().ifPresent(uuid -> AllAdvancements.TRAIN_ROADKILL.trigger((ServerPlayer)serverWorld.getPlayerByUUID(uuid)));
            }
        }
        Vec3 added = entityMotion.add(contraptionMotion.multiply(1.0, 0.0, 1.0).normalize().add(0.0, 0.25, 0.0).scale(damage * 4.0)).add(diffMotion);
        return VecHelper.clamp(added, 3.0f);
    }

    public static boolean bounceEntity(Entity entity, Vec3 normal, AbstractContraptionEntity contraption, double factor) {
        if (factor == 0.0) {
            return false;
        }
        if (entity.isSuppressingBounce()) {
            return false;
        }
        Vec3 contactPointMotion = contraption.getContactPointMotion(entity.position());
        Vec3 motion = entity.getDeltaMovement().subtract(contactPointMotion);
        Vec3 deltav = normal.scale(factor * 2.0 * motion.dot(normal));
        if (deltav.dot(deltav) < (double)0.1f) {
            return false;
        }
        entity.setDeltaMovement(entity.getDeltaMovement().subtract(deltav));
        return true;
    }

    public static Vec3 getWorldToLocalTranslation(Entity entity, Vec3 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        Vec3 entityPosition = entity.position();
        Vec3 centerY = new Vec3(0.0, entity.getBoundingBox().getYsize() / 2.0, 0.0);
        Vec3 position = entityPosition;
        position = position.add(centerY);
        position = ContraptionCollider.worldToLocalPos(position, anchorVec, rotationMatrix, yawOffset);
        position = position.subtract(centerY);
        position = position.subtract(entityPosition);
        return position;
    }

    public static Vec3 worldToLocalPos(Vec3 worldPos, AbstractContraptionEntity contraptionEntity) {
        return ContraptionCollider.worldToLocalPos(worldPos, contraptionEntity.getAnchorVec(), contraptionEntity.getRotationState());
    }

    public static Vec3 worldToLocalPos(Vec3 worldPos, Vec3 anchorVec, AbstractContraptionEntity.ContraptionRotationState rotation) {
        return ContraptionCollider.worldToLocalPos(worldPos, anchorVec, rotation.asMatrix(), rotation.getYawOffset());
    }

    public static Vec3 worldToLocalPos(Vec3 worldPos, Vec3 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        Vec3 localPos = worldPos;
        localPos = localPos.subtract(anchorVec);
        localPos = localPos.subtract(VecHelper.CENTER_OF_ORIGIN);
        localPos = VecHelper.rotate(localPos, -yawOffset, Direction.Axis.Y);
        localPos = rotationMatrix.transform(localPos);
        localPos = localPos.add(VecHelper.CENTER_OF_ORIGIN);
        return localPos;
    }

    public static Vec3 collide(Vec3 p_20273_, Entity e) {
        boolean flag3;
        AABB aabb = e.getBoundingBox();
        Level world = e.level();
        List list = world.getEntityCollisions(e, aabb.expandTowards(p_20273_));
        Vec3 vec3 = p_20273_.lengthSqr() == 0.0 ? p_20273_ : Entity.collideBoundingBox((Entity)e, (Vec3)p_20273_, (AABB)aabb, (Level)world, (List)list);
        boolean flag = p_20273_.x != vec3.x;
        boolean flag1 = p_20273_.y != vec3.y;
        boolean flag2 = p_20273_.z != vec3.z;
        boolean bl = flag3 = flag1 && p_20273_.y < 0.0;
        if (e.maxUpStep() > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = Entity.collideBoundingBox((Entity)e, (Vec3)new Vec3(p_20273_.x, (double)e.maxUpStep(), p_20273_.z), (AABB)aabb, (Level)world, (List)list);
            Vec3 vec32 = Entity.collideBoundingBox((Entity)e, (Vec3)new Vec3(0.0, (double)e.maxUpStep(), 0.0), (AABB)aabb.expandTowards(p_20273_.x, 0.0, p_20273_.z), (Level)world, (List)list);
            if (vec32.y < (double)e.maxUpStep() && (vec33 = Entity.collideBoundingBox((Entity)e, (Vec3)new Vec3(p_20273_.x, 0.0, p_20273_.z), (AABB)aabb.move(vec32), (Level)world, (List)list).add(vec32)).horizontalDistanceSqr() > vec31.horizontalDistanceSqr()) {
                vec31 = vec33;
            }
            if (vec31.horizontalDistanceSqr() > vec3.horizontalDistanceSqr()) {
                return vec31.add(Entity.collideBoundingBox((Entity)e, (Vec3)new Vec3(0.0, -vec31.y + p_20273_.y, 0.0), (AABB)aabb.move(vec31), (Level)world, (List)list));
            }
        }
        return vec3;
    }

    private static PlayerType getPlayerType(Entity entity) {
        return entity instanceof Player ? PlayerType.SERVER : PlayerType.NONE;
    }

    public static List<VoxelShape> getPotentiallyCollidedShapes(Level world, Contraption contraption, AABB localBB) {
        double width;
        double height = localBB.getYsize();
        double horizontalFactor = height > (width = localBB.getXsize()) && width != 0.0 ? height / width : 1.0;
        double verticalFactor = width > height && height != 0.0 ? width / height : 1.0;
        AABB blockScanBB = localBB.inflate(0.5);
        blockScanBB = blockScanBB.inflate(horizontalFactor, verticalFactor, horizontalFactor);
        BlockPos min = BlockPos.containing((double)blockScanBB.minX, (double)blockScanBB.minY, (double)blockScanBB.minZ);
        BlockPos max = BlockPos.containing((double)blockScanBB.maxX, (double)blockScanBB.maxY, (double)blockScanBB.maxZ);
        ArrayList<VoxelShape> potentialHits = new ArrayList<VoxelShape>();
        for (BlockPos p : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            if (!contraption.blocks.containsKey(p) || contraption.isHiddenInPortal(p)) continue;
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(p);
            BlockState blockState = info.state();
            BlockPos pos = info.pos();
            VoxelShape collisionShape = blockState.getCollisionShape((BlockGetter)world, p).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            if (collisionShape.isEmpty()) continue;
            potentialHits.add(collisionShape);
        }
        return potentialHits;
    }

    public static boolean collideBlocks(AbstractContraptionEntity contraptionEntity) {
        if (!contraptionEntity.supportsTerrainCollision()) {
            return false;
        }
        Level world = contraptionEntity.level();
        Vec3 motion = contraptionEntity.getDeltaMovement();
        TranslatingContraption contraption = (TranslatingContraption)contraptionEntity.getContraption();
        AABB bounds = contraptionEntity.getBoundingBox();
        Vec3 position = contraptionEntity.position();
        BlockPos gridPos = BlockPos.containing((Position)position);
        if (contraption == null) {
            return false;
        }
        if (bounds == null) {
            return false;
        }
        if (motion.equals((Object)Vec3.ZERO)) {
            return false;
        }
        Direction movementDirection = Direction.getApproximateNearest((double)motion.x, (double)motion.y, (double)motion.z);
        if (movementDirection.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            gridPos = gridPos.relative(movementDirection);
        }
        if (ContraptionCollider.isCollidingWithWorld(world, contraption, gridPos, movementDirection)) {
            return true;
        }
        for (ControlledContraptionEntity otherContraptionEntity : world.getEntitiesOfClass(ControlledContraptionEntity.class, bounds.inflate(1.0), e -> !e.equals((Object)contraptionEntity))) {
            if (!otherContraptionEntity.supportsTerrainCollision()) continue;
            Vec3 otherMotion = otherContraptionEntity.getDeltaMovement();
            TranslatingContraption otherContraption = (TranslatingContraption)otherContraptionEntity.getContraption();
            AABB otherBounds = otherContraptionEntity.getBoundingBox();
            Vec3 otherPosition = otherContraptionEntity.position();
            if (otherContraption == null) {
                return false;
            }
            if (otherBounds == null) {
                return false;
            }
            if (!bounds.move(motion).intersects(otherBounds.move(otherMotion))) continue;
            for (BlockPos colliderPos : contraption.getOrCreateColliders(world, movementDirection)) {
                colliderPos = colliderPos.offset((Vec3i)gridPos).subtract((Vec3i)BlockPos.containing((Position)otherPosition));
                if (!otherContraption.getBlocks().containsKey(colliderPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCollidingWithWorld(Level world, TranslatingContraption contraption, BlockPos anchor, Direction movementDirection) {
        for (BlockPos pos : contraption.getOrCreateColliders(world, movementDirection)) {
            BlockPos colliderPos = pos.offset((Vec3i)anchor);
            if (!world.isLoaded(colliderPos)) {
                return true;
            }
            BlockState collidedState = world.getBlockState(colliderPos);
            StructureTemplate.StructureBlockInfo blockInfo = contraption.getBlocks().get(pos);
            boolean emptyCollider = collidedState.getCollisionShape((BlockGetter)world, pos).isEmpty();
            if (collidedState.getBlock() instanceof CocoaBlock) continue;
            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)blockInfo.state());
            if (movementBehaviour != null) {
                if (movementBehaviour instanceof BlockBreakingMovementBehaviour) {
                    BlockBreakingMovementBehaviour behaviour = (BlockBreakingMovementBehaviour)movementBehaviour;
                    if (behaviour.canBreak(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
                if (movementBehaviour instanceof HarvesterMovementBehaviour) {
                    HarvesterMovementBehaviour harvesterMovementBehaviour = (HarvesterMovementBehaviour)movementBehaviour;
                    if (harvesterMovementBehaviour.isValidCrop(world, colliderPos, collidedState) || harvesterMovementBehaviour.isValidOther(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
            }
            if (collidedState.is((Block)AllBlocks.PULLEY_MAGNET) && pos.equals((Object)BlockPos.ZERO) && movementDirection == Direction.UP || collidedState.canBeReplaced() || emptyCollider) continue;
            return true;
        }
        return false;
    }

    public static enum PlayerType {
        NONE,
        CLIENT,
        REMOTE,
        SERVER;

    }
}

