/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.entity.EntityAccess;

public class ContraptionHandler {
    public static WorldAttached<Map<Integer, WeakReference<AbstractContraptionEntity>>> loadedContraptions = new WorldAttached<Map>($ -> new HashMap());
    static WorldAttached<List<AbstractContraptionEntity>> queuedAdditions = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));

    public static void tick(Level world) {
        Map<Integer, WeakReference<AbstractContraptionEntity>> map = loadedContraptions.get((LevelAccessor)world);
        List<AbstractContraptionEntity> queued = queuedAdditions.get((LevelAccessor)world);
        for (AbstractContraptionEntity contraptionEntity : queued) {
            map.put(contraptionEntity.getId(), new WeakReference<AbstractContraptionEntity>(contraptionEntity));
        }
        queued.clear();
        Collection<WeakReference<AbstractContraptionEntity>> values = map.values();
        Iterator<WeakReference<AbstractContraptionEntity>> iterator = values.iterator();
        while (iterator.hasNext()) {
            WeakReference<AbstractContraptionEntity> weakReference = iterator.next();
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)weakReference.get());
            if (contraptionEntity == null || !contraptionEntity.isAliveOrStale()) {
                iterator.remove();
                continue;
            }
            if (!contraptionEntity.isAlive()) {
                --contraptionEntity.staleTicks;
                continue;
            }
            ContraptionCollider.collideEntities(contraptionEntity);
        }
    }

    public static void addSpawnedContraptionsToCollisionList(EntityAccess entity) {
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)entity;
            queuedAdditions.get((LevelAccessor)abstractContraptionEntity.level()).add(abstractContraptionEntity);
        }
    }
}

