/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.harvester;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class HarvesterMovementBehaviour
extends MovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.getValue((Property)HarvesterBlock.FACING)).getOpposite());
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)HarvesterBlock.FACING)).getUnitVec3i()).scale(0.45);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level world = context.world;
        if (world.isClientSide()) {
            return;
        }
        BlockState stateVisited = world.getBlockState(pos);
        if (stateVisited.isAir() || stateVisited.is(AllBlockTags.NON_HARVESTABLE)) {
            return;
        }
        boolean notCropButCuttable = false;
        if (!this.isValidCrop(world, pos, stateVisited)) {
            if (this.isValidOther(world, pos, stateVisited)) {
                notCropButCuttable = true;
            } else {
                return;
            }
        }
        ItemStack item = ItemStack.EMPTY;
        float effectChance = 1.0f;
        if (stateVisited.is(BlockTags.LEAVES)) {
            item = new ItemStack((ItemLike)Items.SHEARS);
            effectChance = 0.45f;
        }
        MutableBoolean seedSubtracted = new MutableBoolean(notCropButCuttable);
        BlockState state = stateVisited;
        BlockHelper.destroyBlockAs(world, pos, null, item, effectChance, stack -> {
            if (((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue() && !seedSubtracted.getValue().booleanValue() && ItemHelper.sameItem(stack, new ItemStack((ItemLike)state.getBlock()))) {
                stack.shrink(1);
                seedSubtracted.setTrue();
            }
            this.dropItem(context, (ItemStack)stack);
        });
        BlockState cutCrop = this.cutCrop(world, pos, stateVisited);
        world.setBlockAndUpdate(pos, cutCrop.canSurvive((LevelReader)world, pos) ? cutCrop : Blocks.AIR.defaultBlockState());
    }

    public boolean isValidCrop(Level world, BlockPos pos, BlockState state) {
        boolean harvestPartial = (Boolean)AllConfigs.server().kinetics.harvestPartiallyGrown.get();
        boolean replant = (Boolean)AllConfigs.server().kinetics.harvesterReplants.get();
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            if (harvestPartial) {
                return state != crop.getStateForAge(0) || !replant;
            }
            return crop.isMaxAge(state);
        }
        if (state.getCollisionShape((BlockGetter)world, pos).isEmpty() || state.getBlock() instanceof CocoaBlock) {
            for (Property property : state.getProperties()) {
                if (!(property instanceof IntegerProperty)) continue;
                IntegerProperty ageProperty = (IntegerProperty)property;
                if (!property.getName().equals(BlockStateProperties.AGE_1.getName())) continue;
                int age = (Integer)state.getValue((Property)ageProperty);
                if (state.getBlock() instanceof SweetBerryBushBlock && age <= 1 && replant || age == 0 && replant || !harvestPartial && ageProperty.getPossibleValues().size() - 1 != age) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidOther(Level world, BlockPos pos, BlockState state) {
        if (state.getBlock() instanceof CropBlock) {
            return false;
        }
        if (state.getBlock() instanceof SugarCaneBlock) {
            return true;
        }
        if (state.is(BlockTags.LEAVES)) {
            return true;
        }
        if (state.getBlock() instanceof CocoaBlock) {
            return (Integer)state.getValue((Property)CocoaBlock.AGE) == 2;
        }
        if (state.getCollisionShape((BlockGetter)world, pos).isEmpty()) {
            if (state.getBlock() instanceof GrowingPlantHeadBlock) {
                return true;
            }
            for (Property property : state.getProperties()) {
                if (!(property instanceof IntegerProperty) || !property.getName().equals(BlockStateProperties.AGE_1.getName())) continue;
                return false;
            }
            if (state.getBlock() instanceof VegetationBlock) {
                return true;
            }
        }
        return false;
    }

    private BlockState cutCrop(Level world, BlockPos pos, BlockState state) {
        if (!((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue()) {
            if (state.getFluidState().isEmpty()) {
                return Blocks.AIR.defaultBlockState();
            }
            return state.getFluidState().createLegacyBlock();
        }
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            BlockState newState = crop.getStateForAge(0);
            if (!newState.is(block)) {
                return newState;
            }
            IntegerProperty ageProperty = crop.getAgeProperty();
            return (BlockState)state.setValue((Property)ageProperty, (Comparable)Integer.valueOf(0));
        }
        if (block == Blocks.SWEET_BERRY_BUSH) {
            return (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1));
        }
        if (state.is(AllBlockTags.SUGAR_CANE_VARIANTS) || block instanceof GrowingPlantHeadBlock) {
            if (state.getFluidState().isEmpty()) {
                return Blocks.AIR.defaultBlockState();
            }
            return state.getFluidState().createLegacyBlock();
        }
        if (state.getCollisionShape((BlockGetter)world, pos).isEmpty() || block instanceof CocoaBlock) {
            for (Property property : state.getProperties()) {
                if (!(property instanceof IntegerProperty) || !property.getName().equals(BlockStateProperties.AGE_1.getName())) continue;
                return (BlockState)state.setValue((Property)((IntegerProperty)property), (Comparable)Integer.valueOf(0));
            }
        }
        if (state.getFluidState().isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        return state.getFluidState().createLegacyBlock();
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }
}

