/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.plough;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.actors.plough.PloughBlock;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class PloughMovementBehaviour
extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.getValue((Property)PloughBlock.FACING)).getOpposite());
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        Level world = context.world;
        if (world.isClientSide()) {
            return;
        }
        BlockPos below = pos.below();
        if (!world.isLoaded(below)) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)pos);
        BlockHitResult ray = world.clip(new ClipContext(vec, vec.add(0.0, -1.0, 0.0), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty()));
        if (ray.getType() != HitResult.Type.BLOCK) {
            return;
        }
        UseOnContext ctx = new UseOnContext(world, null, InteractionHand.MAIN_HAND, Items.DIAMOND_HOE.getDefaultInstance(), ray);
        Items.DIAMOND_HOE.useOn(ctx);
    }

    @Override
    protected void throwEntity(MovementContext context, Entity entity) {
        super.throwEntity(context, entity);
        if (!(entity instanceof FallingBlockEntity)) {
            return;
        }
        FallingBlockEntity fbe = (FallingBlockEntity)entity;
        if (!(fbe.getBlockState().getBlock() instanceof AnvilBlock)) {
            return;
        }
        if (entity.getDeltaMovement().length() < 0.25) {
            return;
        }
        entity.level().getEntitiesOfClass(Player.class, new AABB(entity.blockPosition()).inflate(32.0)).stream().map(player -> {
            ServerPlayer serverPlayer;
            return player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null;
        }).filter(Objects::nonNull).forEach(AllAdvancements.ANVIL_PLOUGH::trigger);
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)PloughBlock.FACING)).getUnitVec3i()).scale(0.45);
    }

    @Override
    protected boolean throwsEntities(Level level) {
        return true;
    }

    @Override
    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        if (state.isAir()) {
            return false;
        }
        if (world.getBlockState(breakingPos.below()).getBlock() instanceof FarmBlock) {
            return false;
        }
        if (state.getBlock() instanceof LiquidBlock) {
            return false;
        }
        if (state.getBlock() instanceof BubbleColumnBlock) {
            return false;
        }
        if (state.getBlock() instanceof NetherPortalBlock) {
            return false;
        }
        return state.getCollisionShape((BlockGetter)world, breakingPos).isEmpty();
    }

    @Override
    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        Level level;
        super.onBlockBroken(context, pos, brokenState);
        if (brokenState.getBlock() == Blocks.SNOW && (level = context.world) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            brokenState.getDrops(new LootParams.Builder(world).withParameter(LootContextParams.BLOCK_STATE, (Object)brokenState).withParameter(LootContextParams.THIS_ENTITY, (Object)context.contraption.entity).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)Items.IRON_SHOVEL))).forEach(s -> this.dropItem(context, (ItemStack)s));
        }
    }
}

