/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.psi;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.contraptions.actors.psi.PortableFluidInterfaceBlockEntity;
import com.zurrtum.create.content.contraptions.actors.psi.PortableItemInterfaceBlockEntity;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PortableStorageInterfaceBlock
extends WrenchableDirectionalBlock
implements IBE<PortableStorageInterfaceBlockEntity>,
ItemInventoryProvider<PortableStorageInterfaceBlockEntity>,
FluidInventoryProvider<PortableStorageInterfaceBlockEntity> {
    boolean fluids;

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, PortableStorageInterfaceBlockEntity blockEntity, Direction context) {
        return this.getInventory(blockEntity);
    }

    @Override
    public Container getInventory(@Nullable BlockState state, LevelAccessor world, BlockPos pos, @Nullable BlockEntity blockEntity, Direction context) {
        if (blockEntity == null) {
            blockEntity = world.getBlockEntity(pos);
        }
        return this.getInventory(blockEntity);
    }

    private Container getInventory(BlockEntity blockEntity) {
        if (blockEntity instanceof PortableItemInterfaceBlockEntity) {
            PortableItemInterfaceBlockEntity be = (PortableItemInterfaceBlockEntity)blockEntity;
            return be.capability;
        }
        return null;
    }

    @Override
    public FluidInventory getFluidInventory(LevelAccessor world, BlockPos pos, BlockState state, PortableStorageInterfaceBlockEntity blockEntity, Direction context) {
        return this.getFluidInventory(blockEntity);
    }

    @Override
    public FluidInventory getFluidInventory(@Nullable BlockState state, LevelAccessor world, BlockPos pos, @Nullable BlockEntity blockEntity, Direction context) {
        if (blockEntity == null) {
            blockEntity = world.getBlockEntity(pos);
        }
        return this.getFluidInventory(blockEntity);
    }

    private FluidInventory getFluidInventory(BlockEntity blockEntity) {
        if (blockEntity instanceof PortableFluidInterfaceBlockEntity) {
            PortableFluidInterfaceBlockEntity be = (PortableFluidInterfaceBlockEntity)blockEntity;
            return be.capability;
        }
        return null;
    }

    public static PortableStorageInterfaceBlock forItems(BlockBehaviour.Properties p_i48415_1_) {
        return new PortableStorageInterfaceBlock(p_i48415_1_, false);
    }

    public static PortableStorageInterfaceBlock forFluids(BlockBehaviour.Properties p_i48415_1_) {
        return new PortableStorageInterfaceBlock(p_i48415_1_, true);
    }

    private PortableStorageInterfaceBlock(BlockBehaviour.Properties p_i48415_1_, boolean fluids) {
        super(p_i48415_1_);
        this.fluids = fluids;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block p_220069_4_, @Nullable Orientation WireOrientation, boolean p_220069_6_) {
        this.withBlockEntityDo((BlockGetter)world, pos, PortableStorageInterfaceBlockEntity::neighbourChanged);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getNearestLookingDirection();
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            direction = direction.getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.PORTABLE_STORAGE_INTERFACE.get((Direction)state.getValue((Property)FACING));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos, Direction direction) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(be -> be.isConnected() ? 15 : 0).orElse(0);
    }

    @Override
    public Class<PortableStorageInterfaceBlockEntity> getBlockEntityClass() {
        return PortableStorageInterfaceBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends PortableStorageInterfaceBlockEntity> getBlockEntityType() {
        return this.fluids ? AllBlockEntityTypes.PORTABLE_FLUID_INTERFACE : AllBlockEntityTypes.PORTABLE_STORAGE_INTERFACE;
    }
}

