/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.psi;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PortableStorageInterfaceMovement
extends MovementBehaviour {
    public static final String _workingPos_ = "WorkingPos";
    static final String _clientPrevPos_ = "ClientPrevPos";

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)PortableStorageInterfaceBlock.FACING)).getUnitVec3i()).scale((double)1.85f);
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        boolean onCarriage = context.contraption instanceof CarriageContraption;
        if (onCarriage && context.motion.length() > 0.25) {
            return;
        }
        if (!this.findInterface(context, pos)) {
            context.data.remove(_workingPos_);
        }
    }

    @Override
    public void tick(MovementContext context) {
        Optional<Direction> currentFacingIfValid;
        boolean onCarriage;
        if (context.world.isClientSide()) {
            PortableStorageInterfaceMovement.getAnimation(context).tickChaser();
        }
        if ((onCarriage = context.contraption instanceof CarriageContraption) && context.motion.length() > 0.25) {
            return;
        }
        if (context.world.isClientSide()) {
            BlockPos pos = BlockPos.containing((Position)context.position);
            if (!this.findInterface(context, pos)) {
                this.reset(context);
            }
            return;
        }
        if (!context.data.contains(_workingPos_)) {
            if (context.stall) {
                this.cancelStall(context);
            }
            return;
        }
        BlockPos pos = (BlockPos)context.data.read(_workingPos_, BlockPos.CODEC).orElseThrow();
        Vec3 target = VecHelper.getCenterOf((Vec3i)pos);
        if (!context.stall && !onCarriage && context.position.closerThan((Position)target, target.distanceTo(context.position.add(context.motion)))) {
            context.stall = true;
        }
        if ((currentFacingIfValid = this.getCurrentFacingIfValid(context)).isEmpty()) {
            this.reset(context);
            return;
        }
        PortableStorageInterfaceBlockEntity stationaryInterface = this.getStationaryInterfaceAt(context.world, pos, context.state, currentFacingIfValid.get());
        if (stationaryInterface == null) {
            this.reset(context);
            return;
        }
        if (stationaryInterface.connectedEntity == null) {
            stationaryInterface.startTransferringTo(context.contraption, stationaryInterface.distance);
        }
        boolean timerBelow = stationaryInterface.transferTimer <= 4;
        stationaryInterface.keepAlive = 2;
        if (context.stall && timerBelow) {
            context.stall = false;
        }
    }

    protected boolean findInterface(MovementContext context, BlockPos pos) {
        CarriageContraption cc;
        Contraption contraption = context.contraption;
        if (contraption instanceof CarriageContraption && !(cc = (CarriageContraption)contraption).notInPortal()) {
            return false;
        }
        Optional<Direction> currentFacingIfValid = this.getCurrentFacingIfValid(context);
        if (!currentFacingIfValid.isPresent()) {
            return false;
        }
        Direction currentFacing = currentFacingIfValid.get();
        PortableStorageInterfaceBlockEntity psi = this.findStationaryInterface(context.world, pos, context.state, currentFacing);
        if (psi == null) {
            return false;
        }
        if (psi.isPowered()) {
            return false;
        }
        context.data.store(_workingPos_, BlockPos.CODEC, (Object)psi.getBlockPos());
        if (!context.world.isClientSide()) {
            Vec3 diff = VecHelper.getCenterOf((Vec3i)psi.getBlockPos()).subtract(context.position);
            diff = VecHelper.project(diff, Vec3.atLowerCornerOf((Vec3i)currentFacing.getUnitVec3i()));
            float distance = (float)(diff.length() + (double)1.85f - 1.0);
            psi.startTransferringTo(context.contraption, distance);
        } else {
            context.data.store(_clientPrevPos_, BlockPos.CODEC, (Object)pos);
            if (context.contraption instanceof CarriageContraption || context.contraption.entity.isStalled() || context.motion.lengthSqr() == 0.0) {
                PortableStorageInterfaceMovement.getAnimation(context).chase(psi.getConnectionDistance() / 2.0f, 0.25, LerpedFloat.Chaser.LINEAR);
            }
        }
        return true;
    }

    @Override
    public void stopMoving(MovementContext context) {
    }

    @Override
    public void cancelStall(MovementContext context) {
        this.reset(context);
    }

    public void reset(MovementContext context) {
        context.data.remove(_clientPrevPos_);
        context.data.remove(_workingPos_);
        context.stall = false;
        PortableStorageInterfaceMovement.getAnimation(context).chase(0.0, 0.25, LerpedFloat.Chaser.LINEAR);
    }

    private PortableStorageInterfaceBlockEntity findStationaryInterface(Level world, BlockPos pos, BlockState state, Direction facing) {
        for (int i = 0; i < 2; ++i) {
            PortableStorageInterfaceBlockEntity interfaceAt = this.getStationaryInterfaceAt(world, pos.relative(facing, i), state, facing);
            if (interfaceAt == null) continue;
            return interfaceAt;
        }
        return null;
    }

    private PortableStorageInterfaceBlockEntity getStationaryInterfaceAt(Level world, BlockPos pos, BlockState state, Direction facing) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof PortableStorageInterfaceBlockEntity)) {
            return null;
        }
        PortableStorageInterfaceBlockEntity psi = (PortableStorageInterfaceBlockEntity)blockEntity;
        BlockState blockState = world.getBlockState(pos);
        if (blockState.getBlock() != state.getBlock()) {
            return null;
        }
        if (blockState.getValue((Property)PortableStorageInterfaceBlock.FACING) != facing.getOpposite()) {
            return null;
        }
        if (psi.isPowered()) {
            return null;
        }
        return psi;
    }

    private Optional<Direction> getCurrentFacingIfValid(MovementContext context) {
        Direction facingFromVector;
        Vec3 directionVec = Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)PortableStorageInterfaceBlock.FACING)).getUnitVec3i());
        if ((directionVec = (Vec3)context.rotation.apply(directionVec)).distanceTo(Vec3.atLowerCornerOf((Vec3i)(facingFromVector = Direction.getApproximateNearest((double)directionVec.x, (double)directionVec.y, (double)directionVec.z)).getUnitVec3i())) > 0.5) {
            return Optional.empty();
        }
        return Optional.of(facingFromVector);
    }

    public static LerpedFloat getAnimation(MovementContext context) {
        Object object = context.temporaryData;
        if (!(object instanceof LerpedFloat)) {
            LerpedFloat nlf = LerpedFloat.linear();
            context.temporaryData = nlf;
            return nlf;
        }
        LerpedFloat lf = (LerpedFloat)object;
        return lf;
    }
}

