/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.seat;

import com.google.common.base.Optional;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllEntityTags;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeatBlock
extends Block
implements ProperWaterloggedBlock {
    protected final DyeColor color;

    public SeatBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static Function<BlockBehaviour.Properties, SeatBlock> dyed(DyeColor color) {
        return properties -> new SeatBlock((BlockBehaviour.Properties)properties, color);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{WATERLOGGED}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.withWater(super.getStateForPlacement(pContext), pContext);
    }

    public BlockState updateShape(BlockState pState, LevelReader pLevel, ScheduledTickAccess tickView, BlockPos pCurrentPos, Direction pDirection, BlockPos pNeighborPos, BlockState pNeighborState, RandomSource random) {
        this.updateWater(pLevel, tickView, pState, pCurrentPos);
        return pState;
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public void fallOn(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, double p_152430_) {
        super.fallOn(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_ * 0.5);
    }

    public void updateEntityMovementAfterFallOn(BlockGetter reader, Entity entity) {
        Leashable leashable;
        BlockPos pos = entity.blockPosition();
        if (entity instanceof Player || !(entity instanceof LivingEntity) || !SeatBlock.canBePickedUp(entity) || SeatBlock.isSeatOccupied(entity.level(), pos)) {
            if (entity.isSuppressingBounce()) {
                super.updateEntityMovementAfterFallOn(reader, entity);
                return;
            }
            Vec3 vec3 = entity.getDeltaMovement();
            if (vec3.y < 0.0) {
                double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.setDeltaMovement(vec3.x, -vec3.y * (double)0.66f * d0, vec3.z);
            }
            return;
        }
        if (reader.getBlockState(pos).getBlock() != this) {
            return;
        }
        if (entity instanceof Leashable && (leashable = (Leashable)entity).isLeashed()) {
            return;
        }
        SeatBlock.sitDown(entity.level(), pos, entity);
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.SEAT;
    }

    public VoxelShape getCollisionShape(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext ctx) {
        EntityCollisionContext ecc;
        if (ctx instanceof EntityCollisionContext && (ecc = (EntityCollisionContext)ctx).getEntity() instanceof Player) {
            return AllShapes.SEAT_COLLISION_PLAYERS;
        }
        return AllShapes.SEAT_COLLISION;
    }

    public static SeatBlock getColorBlock(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> AllBlocks.WHITE_SEAT;
            case DyeColor.ORANGE -> AllBlocks.ORANGE_SEAT;
            case DyeColor.MAGENTA -> AllBlocks.MAGENTA_SEAT;
            case DyeColor.LIGHT_BLUE -> AllBlocks.LIGHT_BLUE_SEAT;
            case DyeColor.YELLOW -> AllBlocks.YELLOW_SEAT;
            case DyeColor.LIME -> AllBlocks.LIME_SEAT;
            case DyeColor.PINK -> AllBlocks.PINK_SEAT;
            case DyeColor.GRAY -> AllBlocks.GRAY_SEAT;
            case DyeColor.LIGHT_GRAY -> AllBlocks.LIGHT_GRAY_SEAT;
            case DyeColor.CYAN -> AllBlocks.CYAN_SEAT;
            case DyeColor.PURPLE -> AllBlocks.PURPLE_SEAT;
            case DyeColor.BLUE -> AllBlocks.BLUE_SEAT;
            case DyeColor.BROWN -> AllBlocks.BROWN_SEAT;
            case DyeColor.GREEN -> AllBlocks.GREEN_SEAT;
            case DyeColor.RED -> AllBlocks.RED_SEAT;
            case DyeColor.BLACK -> AllBlocks.BLACK_SEAT;
        };
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || FakePlayerHandler.has((Entity)player)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        DyeColor color = AllItemTags.getDyeColor(stack);
        if (color != null && color != this.color) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            BlockState newState = BlockHelper.copyProperties(state, SeatBlock.getColorBlock(color).defaultBlockState());
            level.setBlockAndUpdate(pos, newState);
            return InteractionResult.SUCCESS;
        }
        List seats = level.getEntitiesOfClass(SeatEntity.class, new AABB(pos));
        if (!seats.isEmpty()) {
            SeatEntity seatEntity = (SeatEntity)((Object)seats.getFirst());
            List passengers = seatEntity.getPassengers();
            if (!passengers.isEmpty() && passengers.getFirst() instanceof Player) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            if (!level.isClientSide()) {
                seatEntity.ejectPassengers();
                player.startRiding((Entity)seatEntity);
            }
            return InteractionResult.SUCCESS;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        Optional<Entity> leashed = SeatBlock.getLeashed(level, player);
        if (leashed.isPresent()) {
            ((Leashable)leashed.get()).removeLeash();
            Inventory playerInventory = player.getInventory();
            if (!player.isCreative() || playerInventory.findSlotMatchingItem(stack) == -1) {
                playerInventory.placeItemBackInInventory(new ItemStack((ItemLike)Items.LEAD));
            }
        }
        SeatBlock.sitDown(level, pos, (Entity)leashed.or((Object)player));
        return InteractionResult.SUCCESS;
    }

    public static boolean isSeatOccupied(Level world, BlockPos pos) {
        return !world.getEntitiesOfClass(SeatEntity.class, new AABB(pos)).isEmpty();
    }

    public static Optional<Entity> getLeashed(Level level, Player player) {
        List entities = player.level().getEntities((Entity)null, player.getBoundingBox().inflate(10.0), e -> true);
        for (Entity e2 : entities) {
            Mob mob;
            if (!(e2 instanceof Mob) || (mob = (Mob)e2).getLeashHolder() != player || !SeatBlock.canBePickedUp(e2)) continue;
            return Optional.of((Object)mob);
        }
        return Optional.absent();
    }

    public static boolean canBePickedUp(Entity passenger) {
        if (passenger instanceof Shulker) {
            return false;
        }
        if (passenger instanceof Player) {
            return false;
        }
        if (passenger.getType().is(AllEntityTags.IGNORE_SEAT)) {
            return false;
        }
        if (!((Boolean)AllConfigs.server().logistics.seatHostileMobs.get()).booleanValue() && !passenger.getType().getCategory().isFriendly()) {
            return false;
        }
        return passenger instanceof LivingEntity;
    }

    public static void sitDown(Level world, BlockPos pos, Entity entity) {
        if (world.isClientSide()) {
            return;
        }
        SeatEntity seat = new SeatEntity(world, pos);
        seat.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        world.addFreshEntity((Entity)seat);
        entity.startRiding((Entity)seat, true, true);
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.setInSittingPose(true);
        }
    }

    public DyeColor getColor() {
        return this.color;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

