/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.seat;

import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.contraptions.actors.seat.SeatBlock;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SeatEntity
extends Entity {
    public SeatEntity(EntityType<? extends SeatEntity> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public SeatEntity(Level world, BlockPos pos) {
        this(AllEntityTypes.SEAT, world);
        this.noPhysics = true;
    }

    public void setPos(double x, double y, double z) {
        super.setPos(x, y, z);
        AABB bb = this.getBoundingBox();
        Vec3 diff = new Vec3(x, y, z).subtract(bb.getCenter());
        this.setBoundingBox(bb.move(diff));
    }

    protected void positionRider(Entity pEntity, Entity.MoveFunction pCallback) {
        Player player;
        float diff;
        if (!this.hasPassenger(pEntity)) {
            return;
        }
        double heightOffset = this.getPassengerRidingPosition((Entity)pEntity).y - pEntity.getVehicleAttachmentPoint((Entity)this).y;
        pCallback.accept(pEntity, this.getX(), 0.0625 + heightOffset + SeatEntity.getCustomEntitySeatOffset(pEntity), this.getZ());
        if (pEntity instanceof Player && (diff = (player = (Player)pEntity).getDimensions(player.getPose()).height() - player.getDimensions(Pose.CROUCHING).height()) != 0.0f) {
            AABB boundingBox = pEntity.getBoundingBox();
            pEntity.setBoundingBox(boundingBox.setMinY(boundingBox.minY + (double)diff));
        }
    }

    public static double getCustomEntitySeatOffset(Entity entity) {
        if (entity instanceof Slime) {
            return 0.0;
        }
        if (entity instanceof Parrot) {
            return 0.0833333358168602;
        }
        if (entity instanceof Skeleton) {
            return 0.125;
        }
        if (entity instanceof Cat) {
            return 0.0833333358168602;
        }
        if (entity instanceof Wolf) {
            return 0.0625;
        }
        if (entity instanceof Frog) {
            return 0.09375;
        }
        if (entity instanceof Spider) {
            return 0.125;
        }
        if (entity instanceof PackageEntity) {
            return 0.09375;
        }
        return 0.0;
    }

    public void setDeltaMovement(Vec3 p_213317_1_) {
    }

    public void tick() {
        if (this.level().isClientSide()) {
            return;
        }
        boolean blockPresent = this.level().getBlockState(this.blockPosition()).getBlock() instanceof SeatBlock;
        if (this.isVehicle() && blockPresent) {
            return;
        }
        this.discard();
    }

    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        return false;
    }

    protected boolean canRide(Entity entity) {
        return !FakePlayerHandler.has(entity);
    }

    protected void removePassenger(Entity entity) {
        super.removePassenger(entity);
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.setInSittingPose(false);
        }
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity pLivingEntity) {
        return super.getDismountLocationForPassenger(pLivingEntity).add(0.0, 0.5, 0.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(ValueInput view) {
    }

    protected void addAdditionalSaveData(ValueOutput view) {
    }
}

