/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.bearing;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.decoration.copycat.CopycatBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Pair;

public class BearingContraption
extends Contraption {
    protected int sailBlocks;
    protected Direction facing;
    private boolean isWindmill;

    public BearingContraption() {
    }

    public BearingContraption(boolean isWindmill, Direction facing) {
        this.isWindmill = isWindmill;
        this.facing = facing;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        BlockPos offset = pos.relative(this.facing);
        if (!this.searchMovedStructure(world, offset, null)) {
            return false;
        }
        this.startMoving(world);
        this.expandBoundsAroundAxis(this.facing.getAxis());
        if (this.isWindmill && this.sailBlocks < (Integer)AllConfigs.server().kinetics.minimumWindmillSails.get()) {
            throw AssemblyException.notEnoughSails(this.sailBlocks);
        }
        return !this.blocks.isEmpty();
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.BEARING;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor.relative(this.facing.getOpposite()));
    }

    @Override
    public void addBlock(Level level, BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture) {
        BlockPos localPos = pos.subtract((Vec3i)this.anchor);
        if (!this.getBlocks().containsKey(localPos) && this.getSailBlock(capture).is(AllBlockTags.WINDMILL_SAILS)) {
            ++this.sailBlocks;
        }
        super.addBlock(level, pos, capture);
    }

    private BlockState getSailBlock(Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture) {
        Object object;
        BlockState state = ((StructureTemplate.StructureBlockInfo)capture.getKey()).state();
        if (state.is((Block)AllBlocks.COPYCAT_PANEL) && (object = capture.getRight()) instanceof CopycatBlockEntity) {
            CopycatBlockEntity cbe = (CopycatBlockEntity)object;
            return cbe.getMaterial();
        }
        return state;
    }

    @Override
    public void write(ValueOutput view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.putInt("Sails", this.sailBlocks);
        view.putInt("Facing", this.facing.get3DDataValue());
    }

    @Override
    public void read(Level world, ValueInput view, boolean spawnData) {
        this.sailBlocks = view.getIntOr("Sails", 0);
        this.facing = Direction.from3DDataValue((int)view.getIntOr("Facing", 0));
        super.read(world, view, spawnData);
    }

    public int getSailBlocks() {
        return this.sailBlocks;
    }

    public Direction getFacing() {
        return this.facing;
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        if (facing.getOpposite() == this.facing && BlockPos.ZERO.equals((Object)localPos)) {
            return false;
        }
        return facing.getAxis() == this.facing.getAxis();
    }
}

