/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.behaviour;

import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DoorMovingInteraction
extends SimpleBlockMovingInteraction {
    @Override
    protected BlockState handle(Player player, Contraption contraption, BlockPos pos, BlockState currentState) {
        if (!(currentState.getBlock() instanceof DoorBlock)) {
            return currentState;
        }
        boolean trainDoor = currentState.getBlock() instanceof SlidingDoorBlock;
        SoundEvent sound = ((Boolean)currentState.getValue((Property)DoorBlock.OPEN)).booleanValue() ? (trainDoor ? null : SoundEvents.WOODEN_DOOR_CLOSE) : (trainDoor ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.WOODEN_DOOR_OPEN);
        BlockPos otherPos = currentState.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(otherPos);
        if (info != null && info.state().hasProperty((Property)DoorBlock.OPEN)) {
            BlockState newState = (BlockState)info.state().cycle((Property)DoorBlock.OPEN);
            this.setContraptionBlockData(contraption.entity, otherPos, new StructureTemplate.StructureBlockInfo(info.pos(), newState, info.nbt()));
        }
        currentState = (BlockState)currentState.cycle((Property)DoorBlock.OPEN);
        if (player != null) {
            if (trainDoor) {
                DoorHingeSide hinge = (DoorHingeSide)currentState.getValue((Property)SlidingDoorBlock.HINGE);
                Direction facing = (Direction)currentState.getValue((Property)SlidingDoorBlock.FACING);
                BlockPos doublePos = pos.relative(hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise());
                StructureTemplate.StructureBlockInfo doubleInfo = contraption.getBlocks().get(doublePos);
                if (doubleInfo != null && SlidingDoorBlock.isDoubleDoor(currentState, hinge, facing, doubleInfo.state())) {
                    this.handlePlayerInteraction(null, InteractionHand.MAIN_HAND, doublePos, contraption.entity);
                }
            }
            float pitch = player.level().random.nextFloat() * 0.1f + 0.9f;
            if (sound != null) {
                this.playSound(player, sound, pitch);
            }
        }
        return currentState;
    }

    @Override
    protected boolean updateColliders() {
        return true;
    }
}

