/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.behaviour;

import com.google.common.base.Suppliers;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MovementContext {
    public Vec3 position;
    public Vec3 motion;
    public Vec3 relativeMotion;
    public UnaryOperator<Vec3> rotation;
    public Level world;
    public BlockState state;
    public BlockPos localPos;
    public CompoundTag blockEntityData;
    public boolean stall;
    public boolean disabled;
    public boolean firstMovement;
    public CompoundTag data;
    public Contraption contraption;
    public Object temporaryData;
    private FilterItemStack filter;
    private final Supplier<MountedItemStorage> itemStorage;
    private final Supplier<MountedFluidStorage> fluidStorage;

    public MovementContext(Level world, StructureTemplate.StructureBlockInfo info, Contraption contraption) {
        this.world = world;
        this.state = info.state();
        this.blockEntityData = info.nbt();
        this.contraption = contraption;
        this.localPos = info.pos();
        this.disabled = false;
        this.firstMovement = true;
        this.motion = Vec3.ZERO;
        this.relativeMotion = Vec3.ZERO;
        this.rotation = v -> v;
        this.position = null;
        this.data = new CompoundTag();
        this.stall = false;
        this.filter = null;
        this.itemStorage = Suppliers.memoize(() -> (MountedItemStorage)contraption.getStorage().getAllItemStorages().get((Object)this.localPos));
        this.fluidStorage = Suppliers.memoize(() -> (MountedFluidStorage)contraption.getStorage().getFluids().storages.get((Object)this.localPos));
    }

    public float getAnimationSpeed() {
        int modifier = 1000;
        double length = -this.motion.length();
        if (this.disabled) {
            return 0.0f;
        }
        if (this.world.isClientSide() && this.contraption.stalled) {
            return 700.0f;
        }
        if (Math.abs(length) < 0.001953125) {
            return 0.0f;
        }
        return (int)(length * (double)modifier + 100.0 * Math.signum(length)) / 100 * 100;
    }

    public static MovementContext read(Level world, StructureTemplate.StructureBlockInfo info, ValueInput view, Contraption contraption) {
        MovementContext context = new MovementContext(world, info, contraption);
        context.motion = (Vec3)view.read("Motion", Vec3.CODEC).orElseThrow();
        context.relativeMotion = (Vec3)view.read("RelativeMotion", Vec3.CODEC).orElseThrow();
        view.read("Position", Vec3.CODEC).ifPresent(position -> {
            context.position = position;
        });
        context.stall = view.getBooleanOr("Stall", false);
        context.firstMovement = view.getBooleanOr("FirstMovement", false);
        context.data = (CompoundTag)view.read("Data", CompoundTag.CODEC).orElseThrow();
        return context;
    }

    public void write(ValueOutput view) {
        view.store("Motion", Vec3.CODEC, (Object)this.motion);
        view.store("RelativeMotion", Vec3.CODEC, (Object)this.relativeMotion);
        if (this.position != null) {
            view.store("Position", Vec3.CODEC, (Object)this.position);
        }
        view.putBoolean("Stall", this.stall);
        view.putBoolean("FirstMovement", this.firstMovement);
        view.store("Data", CompoundTag.CODEC, (Object)this.data);
    }

    public FilterItemStack getFilterFromBE() {
        if (this.filter != null) {
            return this.filter;
        }
        RegistryOps ops = this.world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.filter = this.blockEntityData.read("Filter", FilterItemStack.CODEC, (DynamicOps)ops).orElseGet(FilterItemStack::empty);
        return this.filter;
    }

    @Nullable
    public MountedItemStorage getItemStorage() {
        return this.itemStorage.get();
    }

    @Nullable
    public MountedFluidStorage getFluidStorage() {
        return this.fluidStorage.get();
    }
}

