/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.chassis;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.contraptions.chassis.StickerBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.LandingEffectControlBlock;
import com.zurrtum.create.foundation.block.RunningEffectControlBlock;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StickerBlock
extends WrenchableDirectionalBlock
implements IBE<StickerBlockEntity>,
WeakPowerControlBlock,
LandingEffectControlBlock,
RunningEffectControlBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;

    public StickerBlock(BlockBehaviour.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction nearestLookingDirection = context.getNearestLookingDirection();
        boolean shouldPower = context.getLevel().hasNeighborSignal(context.getClickedPos());
        Direction facing = context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? nearestLookingDirection : nearestLookingDirection.getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(shouldPower));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{POWERED, EXTENDED}));
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, @Nullable Orientation wireOrientation, boolean isMoving) {
        if (worldIn.isClientSide()) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.getValue((Property)POWERED);
        if (previouslyPowered != worldIn.hasNeighborSignal(pos)) {
            if (((Boolean)(state = (BlockState)state.cycle((Property)POWERED)).getValue((Property)POWERED)).booleanValue()) {
                state = (BlockState)state.cycle((Property)EXTENDED);
            }
            worldIn.setBlock(pos, state, 2);
        }
    }

    @Override
    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    public Class<StickerBlockEntity> getBlockEntityClass() {
        return StickerBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends StickerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.STICKER;
    }

    private boolean isUprightSticker(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.is((Block)AllBlocks.STICKER) && blockState.getValue((Property)FACING) == Direction.UP;
    }

    public void fallOn(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, double p_152430_) {
        if (!this.isUprightSticker((BlockGetter)p_152426_, p_152428_) || p_152429_.isSuppressingBounce()) {
            super.fallOn(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_);
        }
        p_152429_.causeFallDamage(p_152430_, 1.0f, p_152426_.damageSources().fall());
    }

    public void updateEntityMovementAfterFallOn(BlockGetter p_176216_1_, Entity p_176216_2_) {
        if (!this.isUprightSticker(p_176216_1_, p_176216_2_.blockPosition().below()) || p_176216_2_.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(p_176216_1_, p_176216_2_);
        } else {
            this.bounceUp(p_176216_2_);
        }
    }

    private void bounceUp(Entity p_226946_1_) {
        Vec3 Vector3d = p_226946_1_.getDeltaMovement();
        if (Vector3d.y < 0.0) {
            double d0 = p_226946_1_ instanceof LivingEntity ? 1.0 : 0.8;
            p_226946_1_.setDeltaMovement(Vector3d.x, -Vector3d.y * d0, Vector3d.z);
        }
    }

    public void stepOn(Level p_152431_, BlockPos p_152432_, BlockState p_152433_, Entity p_152434_) {
        double d0 = Math.abs(p_152434_.getDeltaMovement().y);
        if (d0 < 0.1 && !p_152434_.isSteppingCarefully() && this.isUprightSticker((BlockGetter)p_152431_, p_152432_)) {
            double d1 = 0.4 + d0 * 0.2;
            p_152434_.setDeltaMovement(p_152434_.getDeltaMovement().multiply(d1, 1.0, d1));
        }
        super.stepOn(p_152431_, p_152432_, p_152433_, p_152434_);
    }

    @Override
    public boolean addLandingEffects(BlockState state, ServerLevel world, BlockPos pos, LivingEntity entity, double distance) {
        if (state.getValue((Property)FACING) == Direction.UP) {
            double h;
            double e = entity.getX();
            double f = entity.getY();
            double g = entity.getZ();
            BlockPos blockPos = entity.blockPosition();
            if (pos.getX() != blockPos.getX() || pos.getZ() != blockPos.getZ()) {
                h = e - (double)pos.getX() - 0.5;
                double i = g - (double)pos.getZ() - 0.5;
                double j = Math.max(Math.abs(h), Math.abs(i));
                e = (double)pos.getX() + 0.5 + h / j * 0.5;
                g = (double)pos.getZ() + 0.5 + i / j * 0.5;
            }
            h = Math.min((double)0.2f + distance / 15.0, 2.5);
            int k = (int)(150.0 * h);
            world.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SLIME_BLOCK.defaultBlockState()), e, f, g, k, 0.0, 0.0, 0.0, (double)0.15f);
        }
        return false;
    }

    @Override
    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (state.getValue((Property)FACING) == Direction.UP) {
            Vec3 vec3d = entity.getDeltaMovement();
            BlockPos blockPos = entity.blockPosition();
            double d = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth();
            double e = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth();
            int x = pos.getX();
            if (blockPos.getX() != x) {
                d = Mth.clamp((double)d, (double)x, (double)((double)x + 1.0));
            }
            int z = pos.getZ();
            if (blockPos.getZ() != z) {
                e = Mth.clamp((double)e, (double)z, (double)((double)z + 1.0));
            }
            world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SLIME_BLOCK.defaultBlockState()), d, entity.getY() + 0.1, e, vec3d.x * -4.0, 1.5, vec3d.z * -4.0);
            return true;
        }
        return false;
    }
}

