/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.chassis;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;

public class StickerBlockEntity
extends SmartBlockEntity {
    public LerpedFloat piston = LerpedFloat.linear();
    public boolean update = false;

    public StickerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.STICKER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.level.isClientSide()) {
            return;
        }
        this.piston.startWithValue(this.isBlockStateExtended() ? 1.0 : 0.0);
    }

    public boolean isBlockStateExtended() {
        BlockState blockState = this.getBlockState();
        return blockState.is((Block)AllBlocks.STICKER) && (Boolean)blockState.getValue((Property)StickerBlock.EXTENDED) != false;
    }

    @Override
    public void tick() {
        boolean target;
        super.tick();
        if (!this.level.isClientSide()) {
            return;
        }
        this.piston.tickChaser();
        if (this.isAttachedToBlock() && this.piston.getValue(0.0f) != this.piston.getValue() && this.piston.getValue() == 1.0f) {
            AllClientHandle.INSTANCE.spawnSuperGlueParticles(this.level, this.worldPosition, (Direction)this.getBlockState().getValue((Property)StickerBlock.FACING), true);
            this.playSound(true);
        }
        if (!this.update) {
            return;
        }
        this.update = false;
        boolean bl = target = this.isBlockStateExtended();
        if (this.isAttachedToBlock() && !target && this.piston.getChaseTarget() == 1.0f) {
            this.playSound(false);
        }
        this.piston.chase((double)target, 0.4f, LerpedFloat.Chaser.LINEAR);
        AllClientHandle.INSTANCE.queueUpdate(this);
    }

    public boolean isAttachedToBlock() {
        BlockState blockState = this.getBlockState();
        if (!blockState.is((Block)AllBlocks.STICKER)) {
            return false;
        }
        Direction direction = (Direction)blockState.getValue((Property)StickerBlock.FACING);
        return SuperGlueEntity.isValidFace(this.level, this.worldPosition.relative(direction), direction.getOpposite());
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            this.update = true;
        }
    }

    public void playSound(boolean attach) {
        AllSoundEvents.SLIME_ADDED.play(this.level, AllClientHandle.INSTANCE.getPlayer(), (Vec3i)this.worldPosition, 0.35f, attach ? 0.75f : 0.2f);
    }
}

