/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.gantry;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryContraption;
import com.zurrtum.create.content.contraptions.gantry.GantryContraptionEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class GantryCarriageBlockEntity
extends KineticBlockEntity {
    boolean assembleNextTick;
    protected AssemblyException lastException;

    public GantryCarriageBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.GANTRY_PINION, pos, state);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
    }

    public void checkValidGantryShaft() {
        if (this.shouldAssemble()) {
            this.queueAssembly();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.getBlockState().canSurvive((LevelReader)this.level, this.worldPosition)) {
            this.level.destroyBlock(this.worldPosition, true);
        }
    }

    public void queueAssembly() {
        this.assembleNextTick = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.assembleNextTick) {
            this.tryAssemble();
            this.assembleNextTick = false;
        }
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    private void tryAssemble() {
        Direction shaftOrientation;
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof GantryCarriageBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.getValue((Property)GantryCarriageBlock.FACING);
        GantryContraption contraption = new GantryContraption(direction);
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(direction.getOpposite()));
        if (!(blockEntity instanceof GantryShaftBlockEntity)) {
            return;
        }
        GantryShaftBlockEntity shaftBE = (GantryShaftBlockEntity)blockEntity;
        BlockState shaftState = shaftBE.getBlockState();
        if (shaftState.getBlock() != AllBlocks.GANTRY_SHAFT) {
            return;
        }
        float pinionMovementSpeed = shaftBE.getPinionMovementSpeed();
        Direction movementDirection = shaftOrientation = (Direction)shaftState.getValue((Property)GantryShaftBlock.FACING);
        if (pinionMovementSpeed < 0.0f) {
            movementDirection = movementDirection.getOpposite();
        }
        try {
            this.lastException = null;
            if (!contraption.assemble(this.level, this.worldPosition)) {
                return;
            }
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (ContraptionCollider.isCollidingWithWorld(this.level, contraption, this.worldPosition.relative(movementDirection), movementDirection)) {
            return;
        }
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        contraption.removeBlocksFromWorld(this.level, BlockPos.ZERO);
        GantryContraptionEntity movedContraption = GantryContraptionEntity.create(this.level, contraption, shaftOrientation);
        BlockPos anchor = this.worldPosition;
        movedContraption.setPosRaw(anchor.getX(), anchor.getY(), anchor.getZ());
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.level, (Vec3i)this.worldPosition);
        this.level.addFreshEntity((Entity)movedContraption);
        if (shaftBE.sequenceContext != null && shaftBE.sequenceContext.instruction() == SequencerInstructions.TURN_DISTANCE) {
            movedContraption.limitMovement(shaftBE.sequenceContext.getEffectiveValue(shaftBE.getTheoreticalSpeed()));
        }
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        if (this.lastException != null) {
            view.store("LastException", AssemblyException.CODEC, (Object)this.lastException);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.lastException = view.read("LastException", AssemblyException.CODEC).orElse(null);
        super.read(view, clientPacket);
    }

    @Override
    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
        if (connectedViaAxes) {
            return defaultModifier;
        }
        if (!stateTo.is((Block)AllBlocks.GANTRY_SHAFT)) {
            return defaultModifier;
        }
        if (!((Boolean)stateTo.getValue((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return defaultModifier;
        }
        Direction direction = Direction.getApproximateNearest((float)diff.getX(), (float)diff.getY(), (float)diff.getZ());
        if (stateFrom.getValue((Property)GantryCarriageBlock.FACING) != direction.getOpposite()) {
            return defaultModifier;
        }
        return GantryCarriageBlockEntity.getGantryPinionModifier((Direction)stateTo.getValue((Property)GantryShaftBlock.FACING), (Direction)stateFrom.getValue((Property)GantryCarriageBlock.FACING));
    }

    public static float getGantryPinionModifier(Direction shaft, Direction pinionDirection) {
        Direction.Axis shaftAxis = shaft.getAxis();
        float directionModifier = shaft.getAxisDirection().getStep();
        if (shaftAxis == Direction.Axis.Y && (pinionDirection == Direction.NORTH || pinionDirection == Direction.EAST)) {
            return -directionModifier;
        }
        if (shaftAxis == Direction.Axis.X && (pinionDirection == Direction.DOWN || pinionDirection == Direction.SOUTH)) {
            return -directionModifier;
        }
        if (shaftAxis == Direction.Axis.Z && (pinionDirection == Direction.UP || pinionDirection == Direction.WEST)) {
            return -directionModifier;
        }
        return directionModifier;
    }

    private boolean shouldAssemble() {
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof GantryCarriageBlock)) {
            return false;
        }
        Direction facing = ((Direction)blockState.getValue((Property)GantryCarriageBlock.FACING)).getOpposite();
        BlockState shaftState = this.level.getBlockState(this.worldPosition.relative(facing));
        if (!(shaftState.getBlock() instanceof GantryShaftBlock)) {
            return false;
        }
        if (((Boolean)shaftState.getValue((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return false;
        }
        BlockEntity be = this.level.getBlockEntity(this.worldPosition.relative(facing));
        return be instanceof GantryShaftBlockEntity && ((GantryShaftBlockEntity)be).canAssembleOn();
    }
}

