/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.gantry;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.contraptions.gantry.GantryContraption;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlockEntity;
import com.zurrtum.create.infrastructure.packet.s2c.GantryContraptionUpdatePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class GantryContraptionEntity
extends AbstractContraptionEntity {
    Direction movementAxis;
    public double clientOffsetDiff;
    public double axisMotion;
    public double sequencedOffsetLimit = -1.0;

    public GantryContraptionEntity(EntityType<? extends GantryContraptionEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static GantryContraptionEntity create(Level world, Contraption contraption, Direction movementAxis) {
        GantryContraptionEntity entity = new GantryContraptionEntity((EntityType<? extends GantryContraptionEntity>)AllEntityTypes.GANTRY_CONTRAPTION, world);
        entity.setContraption(contraption);
        entity.movementAxis = movementAxis;
        return entity;
    }

    public void limitMovement(double maxOffset) {
        this.sequencedOffsetLimit = maxOffset;
    }

    @Override
    protected void tickContraption() {
        if (!(this.contraption instanceof GantryContraption)) {
            return;
        }
        double prevAxisMotion = this.axisMotion;
        Level world = this.level();
        if (world.isClientSide()) {
            this.clientOffsetDiff *= 0.75;
            this.updateClientMotion();
        }
        this.checkPinionShaft();
        this.tickActors();
        Vec3 movementVec = this.getDeltaMovement();
        if (ContraptionCollider.collideBlocks(this)) {
            if (!world.isClientSide()) {
                this.disassemble();
            }
            return;
        }
        if (!this.isStalled() && this.tickCount > 2) {
            if (this.sequencedOffsetLimit >= 0.0) {
                movementVec = VecHelper.clampComponentWise(movementVec, (float)this.sequencedOffsetLimit);
            }
            this.move(movementVec.x, movementVec.y, movementVec.z);
            if (this.sequencedOffsetLimit > 0.0) {
                this.sequencedOffsetLimit = Math.max(0.0, this.sequencedOffsetLimit - movementVec.length());
            }
        }
        if (Math.signum(prevAxisMotion) != Math.signum(this.axisMotion) && prevAxisMotion != 0.0) {
            this.contraption.stop(world);
        }
        if (!(world.isClientSide() || prevAxisMotion == this.axisMotion && this.tickCount % 3 != 0)) {
            this.sendPacket();
        }
    }

    @Override
    public void disassemble() {
        this.sequencedOffsetLimit = -1.0;
        super.disassemble();
    }

    protected void checkPinionShaft() {
        GantryShaftBlockEntity gantryShaftBlockEntity;
        BlockEntity be;
        Level world;
        Vec3 currentPosition;
        block11: {
            block10: {
                Direction facing = ((GantryContraption)this.contraption).getFacing();
                currentPosition = this.getAnchorVec().add(0.5, 0.5, 0.5);
                BlockPos gantryShaftPos = BlockPos.containing((Position)currentPosition).relative(facing.getOpposite());
                world = this.level();
                be = world.getBlockEntity(gantryShaftPos);
                if (!(be instanceof GantryShaftBlockEntity)) break block10;
                gantryShaftBlockEntity = (GantryShaftBlockEntity)be;
                if (be.getBlockState().is((Block)AllBlocks.GANTRY_SHAFT)) break block11;
            }
            if (!world.isClientSide()) {
                this.setContraptionMotion(Vec3.ZERO);
                this.disassemble();
            }
            return;
        }
        BlockState blockState = be.getBlockState();
        Direction direction = (Direction)blockState.getValue((Property)GantryShaftBlock.FACING);
        float pinionMovementSpeed = gantryShaftBlockEntity.getPinionMovementSpeed();
        if (((Boolean)blockState.getValue((Property)GantryShaftBlock.POWERED)).booleanValue() || pinionMovementSpeed == 0.0f) {
            this.setContraptionMotion(Vec3.ZERO);
            if (!world.isClientSide()) {
                this.disassemble();
            }
            return;
        }
        if (this.sequencedOffsetLimit >= 0.0) {
            pinionMovementSpeed = (float)Mth.clamp((double)pinionMovementSpeed, (double)(-this.sequencedOffsetLimit), (double)this.sequencedOffsetLimit);
        }
        Vec3 movementVec = Vec3.atLowerCornerOf((Vec3i)direction.getUnitVec3i()).scale((double)pinionMovementSpeed);
        Vec3 nextPosition = currentPosition.add(movementVec);
        double currentCoord = direction.getAxis().choose(currentPosition.x, currentPosition.y, currentPosition.z);
        double nextCoord = direction.getAxis().choose(nextPosition.x, nextPosition.y, nextPosition.z);
        if ((double)Mth.floor((double)currentCoord) + 0.5 < nextCoord != pinionMovementSpeed * (float)direction.getAxisDirection().getStep() < 0.0f && !gantryShaftBlockEntity.canAssembleOn()) {
            this.setContraptionMotion(Vec3.ZERO);
            if (!world.isClientSide()) {
                this.disassemble();
            }
            return;
        }
        if (world.isClientSide()) {
            return;
        }
        this.axisMotion = pinionMovementSpeed;
        this.setContraptionMotion(movementVec);
    }

    @Override
    protected void writeAdditional(ValueOutput view, boolean spawnPacket) {
        view.store("GantryAxis", (Codec)Direction.CODEC, (Object)this.movementAxis);
        if (this.sequencedOffsetLimit >= 0.0) {
            view.putDouble("SequencedOffsetLimit", this.sequencedOffsetLimit);
        }
        super.writeAdditional(view, spawnPacket);
    }

    @Override
    protected void readAdditional(ValueInput view, boolean spawnPacket) {
        this.movementAxis = view.read("GantryAxis", (Codec)Direction.CODEC).orElse(Direction.DOWN);
        this.sequencedOffsetLimit = view.getDoubleOr("SequencedOffsetLimit", -1.0);
        super.readAdditional(view, spawnPacket);
    }

    @Override
    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        return new StructureTransform(BlockPos.containing((Position)this.getAnchorVec().add(0.5, 0.5, 0.5)), 0.0f, 0.0f, 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return 0.0f;
    }

    public void teleportTo(double destX, double destY, double destZ) {
    }

    public void moveOrInterpolateTo(Vec3 pos, float yaw, float pitch) {
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
        this.setPosRaw(x, y, z);
        this.clientOffsetDiff = 0.0;
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return AbstractContraptionEntity.ContraptionRotationState.NONE;
    }

    public void updateClientMotion() {
        float modifier = this.movementAxis.getAxisDirection().getStep();
        Vec3 motion = Vec3.atLowerCornerOf((Vec3i)this.movementAxis.getUnitVec3i()).scale((this.axisMotion + this.clientOffsetDiff * (double)modifier / 2.0) * (double)AllClientHandle.INSTANCE.getServerSpeed());
        if (this.sequencedOffsetLimit >= 0.0) {
            motion = VecHelper.clampComponentWise(motion, (float)this.sequencedOffsetLimit);
        }
        this.setContraptionMotion(motion);
    }

    public double getAxisCoord() {
        Vec3 anchorVec = this.getAnchorVec();
        return this.movementAxis.getAxis().choose(anchorVec.x, anchorVec.y, anchorVec.z);
    }

    public void sendPacket() {
        ServerChunkCache chunkManager = ((ServerLevel)this.level()).getChunkSource();
        chunkManager.sendToTrackingPlayers((Entity)this, (Packet)new GantryContraptionUpdatePacket(this.getId(), this.getAxisCoord(), this.axisMotion, this.sequencedOffsetLimit));
    }
}

