/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.glue;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.api.schematic.requirement.SpecialEntityItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.bearing.BearingBlock;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.packet.s2c.SuperGlueSpawnPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SuperGlueEntity
extends Entity
implements SpecialEntityItemRequirement {
    public static AABB span(BlockPos startPos, BlockPos endPos) {
        return new AABB(Vec3.atLowerCornerOf((Vec3i)startPos), Vec3.atLowerCornerOf((Vec3i)endPos)).expandTowards(1.0, 1.0, 1.0);
    }

    public static boolean isGlued(LevelAccessor level, BlockPos blockPos, Direction direction, Set<SuperGlueEntity> cached) {
        BlockPos targetPos = blockPos.relative(direction);
        if (cached != null) {
            for (SuperGlueEntity glueEntity : cached) {
                if (!glueEntity.contains(blockPos) || !glueEntity.contains(targetPos)) continue;
                return true;
            }
        }
        for (SuperGlueEntity glueEntity : level.getEntitiesOfClass(SuperGlueEntity.class, SuperGlueEntity.span(blockPos, targetPos).inflate(16.0))) {
            if (!glueEntity.contains(blockPos) || !glueEntity.contains(targetPos)) continue;
            if (cached != null) {
                cached.add(glueEntity);
            }
            return true;
        }
        return false;
    }

    public static List<SuperGlueEntity> collectCropped(Level level, AABB bb) {
        ArrayList<SuperGlueEntity> glue = new ArrayList<SuperGlueEntity>();
        for (SuperGlueEntity glueEntity : level.getEntitiesOfClass(SuperGlueEntity.class, bb)) {
            AABB glueBox = glueEntity.getBoundingBox();
            AABB intersect = bb.intersect(glueBox);
            if (intersect.getXsize() * intersect.getYsize() * intersect.getZsize() == 0.0 || Mth.equal((double)intersect.getSize(), (double)1.0)) continue;
            glue.add(new SuperGlueEntity(level, intersect));
        }
        return glue;
    }

    public SuperGlueEntity(EntityType<? extends SuperGlueEntity> type, Level world) {
        super(type, world);
    }

    public SuperGlueEntity(Level world, AABB boundingBox) {
        this(AllEntityTypes.SUPER_GLUE, world);
        this.setBoundingBox(boundingBox);
        this.resetPositionToBB();
    }

    public void resetPositionToBB() {
        AABB bb = this.getBoundingBox();
        this.setPosRaw(bb.getCenter().x, bb.minY, bb.getCenter().z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public static boolean isValidFace(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.getBlockState(pos);
        if (BlockMovementChecks.isBlockAttachedTowards(state, world, pos, direction)) {
            return true;
        }
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos)) {
            return false;
        }
        return !BlockMovementChecks.isNotSupportive(state, direction);
    }

    public static boolean isSideSticky(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.getBlockState(pos);
        if (state.is((Block)AllBlocks.STICKY_MECHANICAL_PISTON)) {
            return state.getValue(DirectionalKineticBlock.FACING) == direction;
        }
        if (state.is((Block)AllBlocks.STICKER)) {
            return state.getValue((Property)DirectionalBlock.FACING) == direction;
        }
        if (state.getBlock() == Blocks.SLIME_BLOCK) {
            return true;
        }
        if (state.getBlock() == Blocks.HONEY_BLOCK) {
            return true;
        }
        if (state.is((Block)AllBlocks.CART_ASSEMBLER)) {
            return Direction.UP == direction;
        }
        if (state.is((Block)AllBlocks.GANTRY_CARRIAGE)) {
            return state.getValue(DirectionalKineticBlock.FACING) == direction;
        }
        if (state.getBlock() instanceof BearingBlock) {
            return state.getValue(DirectionalKineticBlock.FACING) == direction;
        }
        if (state.getBlock() instanceof AbstractChassisBlock) {
            BooleanProperty glueableSide = ((AbstractChassisBlock)state.getBlock()).getGlueableSide(state, direction);
            if (glueableSide == null) {
                return false;
            }
            return (Boolean)state.getValue((Property)glueableSide);
        }
        return false;
    }

    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        return false;
    }

    public void tick() {
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.getBoundingBox().getXsize() == 0.0) {
            this.discard();
        }
    }

    public void setPos(double x, double y, double z) {
        AABB bb = this.getBoundingBox();
        this.setPosRaw(x, y, z);
        Vec3 center = bb.getCenter();
        this.setBoundingBox(bb.move(-center.x, -bb.minY, -center.z).move(x, y, z));
    }

    public void move(MoverType typeIn, Vec3 pos) {
        if (!this.level().isClientSide() && this.isAlive() && pos.lengthSqr() > 0.0) {
            this.discard();
        }
    }

    public void push(double x, double y, double z) {
        if (!this.level().isClientSide() && this.isAlive() && x * x + y * y + z * z > 0.0) {
            this.discard();
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        return super.getDimensions(pose).withEyeHeight(0.0f);
    }

    public void playPlaceSound() {
        AllSoundEvents.SLIME_ADDED.playFrom(this, 0.5f, 0.75f);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public void addAdditionalSaveData(ValueOutput view) {
        AABB box = this.getBoundingBox().move(this.position().scale(-1.0));
        view.store("Box", CreateCodecs.BOX_CODEC, (Object)box);
    }

    public void readAdditionalSaveData(ValueInput view) {
        AABB box = ((AABB)view.read("Box", CreateCodecs.BOX_CODEC).orElseThrow()).move(this.position());
        this.setBoundingBox(box);
    }

    public static void writeBoundingBox(CompoundTag compound, AABB bb) {
        compound.put("From", (Tag)VecHelper.writeNBT(new Vec3(bb.minX, bb.minY, bb.minZ)));
        compound.put("To", (Tag)VecHelper.writeNBT(new Vec3(bb.maxX, bb.maxY, bb.maxZ)));
    }

    public static AABB readBoundingBox(CompoundTag compound) {
        Vec3 from = VecHelper.readNBT(compound.getListOrEmpty("From"));
        Vec3 to = VecHelper.readNBT(compound.getListOrEmpty("To"));
        return new AABB(from, to);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        return new SuperGlueSpawnPacket(this, entityTrackerEntry);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.setBoundingBox(((SuperGlueSpawnPacket)packet).getBox());
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    public float rotate(Rotation transformRotation) {
        AABB bb = this.getBoundingBox().move(this.position().scale(-1.0));
        if (transformRotation == Rotation.CLOCKWISE_90 || transformRotation == Rotation.COUNTERCLOCKWISE_90) {
            this.setBoundingBox(new AABB(bb.minZ, bb.minY, bb.minX, bb.maxZ, bb.maxY, bb.maxX).move(this.position()));
        }
        return super.rotate(transformRotation);
    }

    public void thunderHit(ServerLevel world, LightningBolt lightningBolt) {
    }

    public void refreshDimensions() {
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.DAMAGE, AllItems.SUPER_GLUE);
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean contains(BlockPos pos) {
        return this.getBoundingBox().contains(Vec3.atCenterOf((Vec3i)pos));
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public void spawnParticles() {
        AABB bb = this.getBoundingBox();
        Vec3 origin = new Vec3(bb.minX, bb.minY, bb.minZ);
        Vec3 extents = new Vec3(bb.getXsize(), bb.getYsize(), bb.getZsize());
        Direction.Axis[] axisArray = this.level();
        if (!(axisArray instanceof ServerLevel)) {
            return;
        }
        ServerLevel slevel = (ServerLevel)axisArray;
        block0: for (Direction.Axis axis : Iterate.axes) {
            Direction.AxisDirection positive = Direction.AxisDirection.POSITIVE;
            double max = axis.choose(extents.x, extents.y, extents.z);
            Vec3 normal = Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)positive).getUnitVec3i());
            for (Direction.Axis axis2 : Iterate.axes) {
                if (axis2 == axis) continue;
                double max2 = axis2.choose(extents.x, extents.y, extents.z);
                Vec3 normal2 = Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)axis2, (Direction.AxisDirection)positive).getUnitVec3i());
                for (Direction.Axis axis3 : Iterate.axes) {
                    if (axis3 == axis2 || axis3 == axis) continue;
                    double max3 = axis3.choose(extents.x, extents.y, extents.z);
                    Vec3 normal3 = Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)axis3, (Direction.AxisDirection)positive).getUnitVec3i());
                    int i = 0;
                    while ((double)i <= max * 2.0) {
                        for (int o1 : Iterate.zeroAndOne) {
                            for (int o2 : Iterate.zeroAndOne) {
                                Vec3 v = origin.add(normal.scale((double)((float)i / 2.0f))).add(normal2.scale(max2 * (double)o1)).add(normal3.scale(max3 * (double)o2));
                                slevel.sendParticles((ParticleOptions)ParticleTypes.ITEM_SLIME, v.x, v.y, v.z, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                        ++i;
                    }
                    continue block0;
                }
                continue block0;
            }
        }
    }
}

