/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class MinecartController {
    public static final Codec<MinecartController> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Couple.optionalCodec(StallData.CODEC).fieldOf("stallData").forGetter(i -> i.stallData), (App)Couple.optionalCodec(CouplingData.CODEC).fieldOf("couplings").forGetter(i -> i.couplings)).apply((Applicative)instance, MinecartController::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MinecartController> PACKET_CODEC = StreamCodec.composite(Couple.streamCodec(StallData.PACKET_CODEC.apply(ByteBufCodecs::optional)), i -> i.stallData, Couple.streamCodec(CouplingData.PACKET_CODEC.apply(ByteBufCodecs::optional)), i -> i.couplings, MinecartController::new);
    private boolean needsEntryRefresh;
    private AbstractMinecart cart;
    private Couple<Optional<StallData>> stallData;
    private Couple<Optional<CouplingData>> couplings;

    public MinecartController(AbstractMinecart minecart) {
        this.cart = minecart;
        this.stallData = Couple.create(Optional::empty);
        this.couplings = Couple.create(Optional::empty);
        this.needsEntryRefresh = true;
    }

    private MinecartController(Couple<Optional<StallData>> stallData, Couple<Optional<CouplingData>> couplings) {
        this.stallData = stallData;
        this.couplings = couplings;
        this.needsEntryRefresh = true;
    }

    public AbstractMinecart cart() {
        return this.cart;
    }

    public void coupleWith(boolean isLeading, UUID coupled, float length, boolean contraption) {
        UUID mainID = isLeading ? this.cart().getUUID() : coupled;
        UUID connectedID = isLeading ? coupled : this.cart().getUUID();
        this.couplings.set(isLeading, Optional.of(new CouplingData(mainID, connectedID, length, contraption)));
        this.needsEntryRefresh |= isLeading;
        this.sendData();
    }

    public void decouple() {
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(this.cart.level(), idOfOther);
            if (otherCart == null) {
                return;
            }
            this.removeConnection((boolean)main);
            otherCart.removeConnection(main == false);
        }));
    }

    private void disassemble(AbstractMinecart cart) {
        BlockPos blockpos;
        BlockState blockstate;
        int k;
        int j;
        int i;
        if (cart instanceof Minecart) {
            return;
        }
        List passengers = cart.getPassengers();
        if (passengers.isEmpty() || !(passengers.getFirst() instanceof AbstractContraptionEntity)) {
            return;
        }
        Level world = cart.level();
        if (world.getBlockState(new BlockPos(i = Mth.floor((double)cart.getX()), (j = Mth.floor((double)cart.getY())) - 1, k = Mth.floor((double)cart.getZ()))).is(BlockTags.RAILS)) {
            --j;
        }
        if ((blockstate = world.getBlockState(blockpos = new BlockPos(i, j, k))).is(BlockTags.RAILS) && blockstate.getBlock() == Blocks.ACTIVATOR_RAIL) {
            if (cart.isVehicle()) {
                cart.ejectPassengers();
            }
            if (cart.getHurtTime() == 0) {
                cart.setHurtDir(-cart.getHurtDir());
                cart.setHurtTime(10);
                cart.setDamage(50.0f);
                cart.hurtMarked = true;
            }
        }
    }

    @Nullable
    public UUID getCoupledCart(boolean asMain) {
        Optional<CouplingData> optional = this.couplings.get(asMain);
        if (optional.isEmpty()) {
            return null;
        }
        CouplingData couplingData = optional.get();
        return asMain ? couplingData.connectedCartID : couplingData.mainCartID;
    }

    public float getCouplingLength(boolean leading) {
        Optional<CouplingData> optional = this.couplings.get(leading);
        return optional.map(couplingData -> Float.valueOf(couplingData.length)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public boolean hasContraptionCoupling(boolean current) {
        Optional<CouplingData> optional = this.couplings.get(current);
        return optional.isPresent() && optional.get().contraption;
    }

    public boolean isConnectedToCoupling() {
        return this.couplings.get(false).isPresent();
    }

    public boolean isCoupledThroughContraption() {
        return this.couplings.stream().anyMatch(i -> i.map(CouplingData::getContraption).orElse(false));
    }

    public boolean isFullyCoupled() {
        return this.isLeadingCoupling() && this.isConnectedToCoupling();
    }

    public boolean isLeadingCoupling() {
        return this.couplings.get(true).isPresent();
    }

    public boolean isPresent() {
        return this.cart.isAlive();
    }

    public boolean isStalled() {
        return this.isStalled(true) || this.isStalled(false);
    }

    private boolean isStalled(boolean internal) {
        return this.stallData.get(internal).isPresent();
    }

    public void prepareForCoupling(boolean isLeading) {
        if (isLeading && this.isLeadingCoupling() || !isLeading && this.isConnectedToCoupling()) {
            Optional<MinecartController> next;
            ArrayList<MinecartController> cartsToFlip = new ArrayList<MinecartController>();
            cartsToFlip.add(this);
            MinecartController current = this;
            boolean forward = current.isLeadingCoupling();
            int safetyCount = 1000;
            Level world = this.cart.level();
            while (safetyCount-- > 0 && !(next = CouplingHandler.getNextInCouplingChain(world, current, forward)).isEmpty()) {
                current = next.get();
                cartsToFlip.add(current);
            }
            if (safetyCount == 0) {
                Create.LOGGER.warn("Infinite loop in coupling iteration");
                return;
            }
            for (MinecartController minecartController : cartsToFlip) {
                minecartController.couplings.forEachWithContext((opt, leading) -> opt.ifPresent(cd -> {
                    cd.flip();
                    if (!cd.contraption) {
                        return;
                    }
                    List passengers = minecartController.cart().getPassengers();
                    if (passengers.isEmpty()) {
                        return;
                    }
                    Entity entity = (Entity)passengers.getFirst();
                    if (!(entity instanceof OrientedContraptionEntity)) {
                        return;
                    }
                    OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
                    UUID couplingId = contraption.getCouplingId();
                    if (couplingId == cd.mainCartID) {
                        contraption.setCouplingId(cd.connectedCartID);
                        return;
                    }
                    if (couplingId == cd.connectedCartID) {
                        contraption.setCouplingId(cd.mainCartID);
                    }
                }));
                minecartController.couplings = minecartController.couplings.swap();
                minecartController.needsEntryRefresh = true;
                if (minecartController == this) continue;
                minecartController.sendData();
            }
        }
    }

    public void removeConnection(boolean main) {
        Entity entity;
        List passengers;
        Level world;
        if (this.hasContraptionCoupling(main) && (world = this.cart.level()) != null && !world.isClientSide() && !(passengers = this.cart().getPassengers()).isEmpty() && (entity = (Entity)passengers.getFirst()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)entity;
            abstractContraptionEntity.disassemble();
        }
        this.couplings.set(main, Optional.empty());
        this.needsEntryRefresh |= main;
        this.sendData();
    }

    public void sendData() {
        this.sendData(null);
    }

    public void sendData(@Nullable AbstractMinecart cart) {
        if (cart != null) {
            this.cart = cart;
            this.needsEntryRefresh = true;
        }
        if (this.cart.level().isClientSide()) {
            return;
        }
        AllSynchedDatas.MINECART_CONTROLLER.set((Entity)this.cart, Optional.of(this), true);
    }

    public void setCart(AbstractMinecart cart) {
        this.cart = cart;
    }

    private void setStalled(boolean stall, boolean internal) {
        if (this.isStalled(internal) == stall || this.cart == null) {
            return;
        }
        if (stall) {
            this.stallData.set(internal, Optional.of(new StallData(this.cart)));
            this.sendData();
            return;
        }
        if (!this.isStalled(!internal)) {
            this.stallData.get(internal).ifPresent(data -> data.release(this.cart));
        }
        this.stallData.set(internal, Optional.empty());
        this.sendData();
    }

    public void setStalledExternally(boolean stall) {
        this.setStalled(stall, false);
    }

    public void tick() {
        if (this.cart == null) {
            return;
        }
        Level world = this.cart.level();
        if (world == null) {
            return;
        }
        if (this.needsEntryRefresh) {
            CapabilityMinecartController.queuedAdditions.get((LevelAccessor)world).add(this.cart);
            this.needsEntryRefresh = false;
        }
        this.stallData.forEach(opt -> opt.ifPresent(sd -> sd.tick(this.cart)));
        MutableBoolean internalStall = new MutableBoolean(false);
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(world, idOfOther);
            internalStall.setValue(internalStall.booleanValue() || otherCart == null || !otherCart.isPresent() || otherCart.isStalled(false));
        }));
        if (!world.isClientSide()) {
            this.setStalled(internalStall.booleanValue(), true);
            this.disassemble(this.cart);
        }
    }

    private static class CouplingData {
        public static final Codec<CouplingData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("mainCartID").forGetter(i -> i.mainCartID), (App)UUIDUtil.CODEC.fieldOf("connectedCartID").forGetter(i -> i.connectedCartID), (App)Codec.FLOAT.fieldOf("length").forGetter(i -> Float.valueOf(i.length)), (App)Codec.BOOL.fieldOf("contraption").forGetter(i -> i.contraption)).apply((Applicative)instance, CouplingData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CouplingData> PACKET_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, i -> i.mainCartID, (StreamCodec)UUIDUtil.STREAM_CODEC, i -> i.connectedCartID, (StreamCodec)ByteBufCodecs.FLOAT, i -> Float.valueOf(i.length), (StreamCodec)ByteBufCodecs.BOOL, i -> i.contraption, CouplingData::new);
        private final float length;
        private final boolean contraption;
        private UUID mainCartID;
        private UUID connectedCartID;

        public CouplingData(UUID mainCartID, UUID connectedCartID, float length, boolean contraption) {
            this.mainCartID = mainCartID;
            this.connectedCartID = connectedCartID;
            this.length = length;
            this.contraption = contraption;
        }

        public void flip() {
            UUID swap = this.mainCartID;
            this.mainCartID = this.connectedCartID;
            this.connectedCartID = swap;
        }

        public boolean getContraption() {
            return this.contraption;
        }

        public UUID idOfCart(boolean main) {
            return main ? this.mainCartID : this.connectedCartID;
        }
    }

    private record StallData(Vec3 position, Vec3 motion, float yaw, float pitch) {
        public static final Codec<StallData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.fieldOf("position").forGetter(StallData::position), (App)Vec3.CODEC.fieldOf("motion").forGetter(StallData::motion), (App)Codec.FLOAT.fieldOf("yaw").forGetter(StallData::yaw), (App)Codec.FLOAT.fieldOf("pitch").forGetter(StallData::pitch)).apply((Applicative)instance, StallData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, StallData> PACKET_CODEC = StreamCodec.composite((StreamCodec)Vec3.STREAM_CODEC, StallData::position, (StreamCodec)Vec3.STREAM_CODEC, StallData::motion, (StreamCodec)ByteBufCodecs.FLOAT, StallData::yaw, (StreamCodec)ByteBufCodecs.FLOAT, StallData::pitch, StallData::new);

        public StallData(AbstractMinecart entity) {
            this(entity.position(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot());
            this.tick(entity);
        }

        public void release(AbstractMinecart entity) {
            entity.setDeltaMovement(this.motion);
        }

        public void tick(AbstractMinecart entity) {
            entity.setDeltaMovement(Vec3.ZERO);
            entity.setYRot(this.yaw);
            entity.setXRot(this.pitch);
        }
    }
}

