/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.piston.LinearActuatorBlockEntity;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.piston.PistonContraption;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class MechanicalPistonBlockEntity
extends LinearActuatorBlockEntity {
    protected int extensionLength;

    public MechanicalPistonBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.MECHANICAL_PISTON, pos, state);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.extensionLength = view.getIntOr("ExtensionLength", 0);
        super.read(view, clientPacket);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        view.putInt("ExtensionLength", this.extensionLength);
        super.write(view, clientPacket);
    }

    @Override
    public void assemble() throws AssemblyException {
        if (!(this.level.getBlockState(this.worldPosition).getBlock() instanceof MechanicalPistonBlock)) {
            return;
        }
        Direction direction = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        PistonContraption contraption = new PistonContraption(direction, this.getMovementSpeed() < 0.0f);
        if (!contraption.assemble(this.level, this.worldPosition)) {
            return;
        }
        Direction positive = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)direction.getAxis());
        Direction movementDirection = this.getSpeed() > 0.0f ^ direction.getAxis() != Direction.Axis.Z ? positive : positive.getOpposite();
        BlockPos anchor = contraption.anchor.relative(direction, contraption.initialExtensionProgress);
        if (ContraptionCollider.isCollidingWithWorld(this.level, contraption, anchor.relative(movementDirection), movementDirection)) {
            return;
        }
        this.extensionLength = contraption.extensionLength;
        float resultingOffset = (float)contraption.initialExtensionProgress + Math.signum(this.getMovementSpeed()) * 0.5f;
        if (resultingOffset <= 0.0f || resultingOffset >= (float)this.extensionLength) {
            return;
        }
        this.running = true;
        this.offset = contraption.initialExtensionProgress;
        this.sendData();
        this.clientOffsetDiff = 0.0f;
        BlockPos startPos = BlockPos.ZERO.relative(direction, contraption.initialExtensionProgress);
        contraption.removeBlocksFromWorld(this.level, startPos);
        this.movedContraption = ControlledContraptionEntity.create(this.getLevel(), this, contraption);
        this.resetContraptionToOffset();
        this.forceMove = true;
        this.level.addFreshEntity((Entity)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.level, (Vec3i)this.worldPosition);
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (!this.remove) {
            this.getLevel().setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.EXTENDED)), 19);
        }
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.level, (Vec3i)this.worldPosition);
        }
        this.running = false;
        this.movedContraption = null;
        this.sendData();
        if (this.remove) {
            AllBlocks.MECHANICAL_PISTON.playerWillDestroy(this.level, this.worldPosition, this.getBlockState(), null);
        }
    }

    @Override
    protected void collided() {
        super.collided();
        if (!this.running && this.getMovementSpeed() > 0.0f) {
            this.assembleNextTick = true;
        }
    }

    @Override
    public float getMovementSpeed() {
        float movementSpeed = Mth.clamp((float)MechanicalPistonBlockEntity.convertToLinear(this.getSpeed()), (float)-0.49f, (float)0.49f);
        if (this.level.isClientSide()) {
            movementSpeed *= AllClientHandle.INSTANCE.getServerSpeed();
        }
        Direction pistonDirection = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        int movementModifier = pistonDirection.getAxisDirection().getStep() * (pistonDirection.getAxis() == Direction.Axis.Z ? -1 : 1);
        movementSpeed = movementSpeed * (float)(-movementModifier) + this.clientOffsetDiff / 2.0f;
        int extensionRange = this.getExtensionRange();
        movementSpeed = Mth.clamp((float)movementSpeed, (float)(0.0f - this.offset), (float)((float)extensionRange - this.offset));
        if (this.sequencedOffsetLimit >= 0.0) {
            movementSpeed = (float)Mth.clamp((double)movementSpeed, (double)(-this.sequencedOffsetLimit), (double)this.sequencedOffsetLimit);
        }
        return movementSpeed;
    }

    @Override
    protected int getExtensionRange() {
        return this.extensionLength;
    }

    @Override
    protected void visitNewPosition() {
    }

    @Override
    protected Vec3 toMotionVector(float speed) {
        Direction pistonDirection = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        return Vec3.atLowerCornerOf((Vec3i)pistonDirection.getUnitVec3i()).scale((double)speed);
    }

    @Override
    protected Vec3 toPosition(float offset) {
        Vec3 position = Vec3.atLowerCornerOf((Vec3i)((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getUnitVec3i()).scale((double)offset);
        return position.add(Vec3.atLowerCornerOf((Vec3i)this.movedContraption.getContraption().anchor));
    }

    @Override
    protected int getInitialOffset() {
        return this.movedContraption == null ? 0 : ((PistonContraption)this.movedContraption.getContraption()).initialExtensionProgress;
    }
}

