/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.copycat;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.decoration.copycat.CopycatBlockEntity;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.AppearanceControlBlock;
import com.zurrtum.create.foundation.block.EnchantingControlBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.LightControlBlock;
import com.zurrtum.create.foundation.block.ResistanceControlBlock;
import com.zurrtum.create.foundation.block.SlipperinessControlBlock;
import com.zurrtum.create.foundation.block.SoundControlBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class CopycatBlock
extends Block
implements IBE<CopycatBlockEntity>,
IWrenchable,
ResistanceControlBlock,
SlipperinessControlBlock,
EnchantingControlBlock,
AppearanceControlBlock,
SoundControlBlock,
LightControlBlock {
    public CopycatBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> getTicker(Level p_153212_, BlockState p_153213_, BlockEntityType<S> p_153214_) {
        return null;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        this.onWrenched(state, context);
        return IWrenchable.super.onSneakWrenched(state, context);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return this.onBlockEntityUse((BlockGetter)context.getLevel(), context.getClickedPos(), ufte -> {
            ItemStack consumedItem = ufte.getConsumedItem();
            if (!ufte.hasCustomMaterial()) {
                return InteractionResult.PASS;
            }
            Player player = context.getPlayer();
            if (!player.isCreative()) {
                player.getInventory().placeItemBackInInventory(consumedItem);
            }
            context.getLevel().levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)ufte.getBlockState()));
            ufte.setMaterial(AllBlocks.COPYCAT_BASE.defaultBlockState());
            ufte.setConsumedItem(ItemStack.EMPTY);
            return InteractionResult.SUCCESS;
        });
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        Direction face = hitResult.getDirection();
        BlockState materialIn = this.getAcceptedBlockState(level, pos, stack, face);
        if (materialIn != null) {
            materialIn = this.prepareMaterial(level, pos, state, player, hand, hitResult, materialIn);
        }
        if (materialIn == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockState material = materialIn;
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, ufte -> {
            if (ufte.getMaterial().is(material.getBlock())) {
                if (!ufte.cycleMaterial()) {
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                ufte.getLevel().playSound(null, ufte.getBlockPos(), SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.75f, 0.95f);
                return InteractionResult.SUCCESS;
            }
            if (ufte.hasCustomMaterial()) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            ufte.setMaterial(material);
            ufte.setConsumedItem(stack);
            ufte.getLevel().playSound(null, ufte.getBlockPos(), material.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.75f);
            if (player.isCreative()) {
                return InteractionResult.SUCCESS;
            }
            stack.shrink(1);
            if (stack.isEmpty()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            return InteractionResult.SUCCESS;
        });
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        if (pPlacer == null) {
            return;
        }
        ItemStack offhandItem = pPlacer.getItemInHand(InteractionHand.OFF_HAND);
        BlockState appliedState = this.getAcceptedBlockState(pLevel, pPos, offhandItem, Direction.orderedByNearest((Entity)pPlacer)[0]);
        if (appliedState == null) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, ufte -> {
            Player player;
            if (ufte.hasCustomMaterial()) {
                return;
            }
            ufte.setMaterial(appliedState);
            ufte.setConsumedItem(offhandItem);
            if (pPlacer instanceof Player && (player = (Player)pPlacer).isCreative()) {
                return;
            }
            offhandItem.shrink(1);
            if (offhandItem.isEmpty()) {
                pPlacer.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
            }
        });
    }

    @Nullable
    public BlockState getAcceptedBlockState(Level pLevel, BlockPos pPos, ItemStack item, Direction face) {
        Item item2 = item.getItem();
        if (!(item2 instanceof BlockItem)) {
            return null;
        }
        BlockItem bi = (BlockItem)item2;
        Block block = bi.getBlock();
        if (block instanceof CopycatBlock) {
            return null;
        }
        BlockState appliedState = block.defaultBlockState();
        boolean hardCodedAllow = this.isAcceptedRegardless(appliedState);
        if (!appliedState.is(AllBlockTags.COPYCAT_ALLOW) && !hardCodedAllow) {
            if (appliedState.is(AllBlockTags.COPYCAT_DENY)) {
                return null;
            }
            if (block instanceof EntityBlock) {
                return null;
            }
            if (block instanceof StairBlock) {
                return null;
            }
            if (pLevel != null) {
                VoxelShape shape = appliedState.getShape((BlockGetter)pLevel, pPos);
                if (shape.isEmpty() || !shape.bounds().equals((Object)Shapes.block().bounds())) {
                    return null;
                }
                VoxelShape collisionShape = appliedState.getCollisionShape((BlockGetter)pLevel, pPos);
                if (collisionShape.isEmpty()) {
                    return null;
                }
            }
        }
        if (face != null) {
            Direction.Axis axis = face.getAxis();
            if (appliedState.hasProperty((Property)BlockStateProperties.FACING)) {
                appliedState = (BlockState)appliedState.setValue((Property)BlockStateProperties.FACING, (Comparable)face);
            }
            if (appliedState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)face);
            }
            if (appliedState.hasProperty((Property)BlockStateProperties.AXIS)) {
                appliedState = (BlockState)appliedState.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis);
            }
            if (appliedState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)axis);
            }
        }
        return appliedState;
    }

    public boolean isAcceptedRegardless(BlockState material) {
        return false;
    }

    public BlockState prepareMaterial(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, BlockState material) {
        return material;
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
        if (pPlayer.isCreative()) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, ufte -> ufte.setConsumedItem(ItemStack.EMPTY));
        }
        return pState;
    }

    @Override
    public Class<CopycatBlockEntity> getBlockEntityClass() {
        return CopycatBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends CopycatBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.COPYCAT;
    }

    @Override
    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        if (this.isIgnoredConnectivitySide(level, state, side, pos, queryPos)) {
            return state;
        }
        BlockState material = CopycatBlock.getMaterial((BlockGetter)level, pos);
        return material != null ? material : AllBlocks.COPYCAT_BASE.defaultBlockState();
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, @Nullable BlockPos fromPos, @Nullable BlockPos toPos) {
        return false;
    }

    public abstract boolean canConnectTexturesToward(BlockAndTintGetter var1, BlockPos var2, BlockPos var3, BlockState var4);

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        BlockEntity blockEntity = reader.getBlockEntity(targetPos);
        if (blockEntity instanceof CopycatBlockEntity) {
            CopycatBlockEntity cbe = (CopycatBlockEntity)blockEntity;
            return cbe.getMaterial();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return false;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return false;
    }

    @Override
    public SoundType getSoundGroup(LevelReader level, BlockPos pos) {
        return CopycatBlock.getMaterial((BlockGetter)level, pos).getSoundType();
    }

    @Override
    public float getSlipperiness(LevelReader world, BlockPos pos) {
        BlockState state = CopycatBlock.getMaterial((BlockGetter)world, pos);
        Block material = state.getBlock();
        if (material instanceof SlipperinessControlBlock) {
            SlipperinessControlBlock block = (SlipperinessControlBlock)material;
            return block.getSlipperiness(world, pos);
        }
        return material.getFriction();
    }

    @Override
    public int getLuminance(BlockGetter world, BlockPos pos) {
        return CopycatBlock.getMaterial(world, pos).getLightEmission();
    }

    @Override
    public float getResistance(BlockGetter level, BlockPos pos) {
        return CopycatBlock.getMaterial(level, pos).getBlock().getExplosionResistance();
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        BlockState material = CopycatBlock.getMaterial((BlockGetter)level, pos);
        if (material.is(AllBlocks.COPYCAT_BASE)) {
            return new ItemStack((ItemLike)this);
        }
        return material.getCloneItemStack(level, pos, includeData);
    }

    @Override
    public BlockState getEnchantmentPowerProvider(Level world, BlockPos pos) {
        return CopycatBlock.getMaterial((BlockGetter)world, pos);
    }

    public void fallOn(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, double p_152430_) {
        BlockState material = CopycatBlock.getMaterial((BlockGetter)pLevel, pPos);
        material.getBlock().fallOn(pLevel, material, pPos, pEntity, p_152430_);
    }

    public float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        return CopycatBlock.getMaterial(pLevel, pPos).getDestroyProgress(pPlayer, pLevel, pPos);
    }
}

