/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.copycat;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.api.schematic.nbt.PartialSafeNBT;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.decoration.copycat.CopycatBlock;
import com.zurrtum.create.content.redstone.RoseQuartzLampBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class CopycatBlockEntity
extends SmartBlockEntity
implements SpecialBlockEntityItemRequirement,
TransformableBlockEntity,
PartialSafeNBT {
    private BlockState material = AllBlocks.COPYCAT_BASE.defaultBlockState();
    private ItemStack consumedItem = ItemStack.EMPTY;

    public CopycatBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.COPYCAT, pos, state);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        super.preRemoveSideEffects(pos, oldState);
        Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)this.consumedItem);
    }

    public BlockState getMaterial() {
        return this.material;
    }

    public boolean hasCustomMaterial() {
        return !this.getMaterial().is(AllBlocks.COPYCAT_BASE);
    }

    public void setMaterial(BlockState blockState) {
        BlockState wrapperState = this.getBlockState();
        if (!this.material.is(blockState.getBlock())) {
            for (Direction side : Iterate.directions) {
                CopycatBlockEntity cbe;
                BlockState otherMaterial;
                BlockEntity blockEntity;
                BlockPos neighbour = this.worldPosition.relative(side);
                BlockState neighbourState = this.level.getBlockState(neighbour);
                if (neighbourState != wrapperState || !((blockEntity = this.level.getBlockEntity(neighbour)) instanceof CopycatBlockEntity) || !(otherMaterial = (cbe = (CopycatBlockEntity)blockEntity).getMaterial()).is(blockState.getBlock())) continue;
                blockState = otherMaterial;
                break;
            }
        }
        this.material = blockState;
        if (!this.level.isClientSide()) {
            this.notifyUpdate();
            return;
        }
        this.redraw();
    }

    public boolean cycleMaterial() {
        if (this.material.hasProperty((Property)TrapDoorBlock.HALF) && ((Boolean)this.material.getValueOrElse((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            this.setMaterial((BlockState)this.material.cycle((Property)TrapDoorBlock.HALF));
        } else if (this.material.hasProperty((Property)BlockStateProperties.FACING)) {
            this.setMaterial((BlockState)this.material.cycle((Property)BlockStateProperties.FACING));
        } else if (this.material.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            this.setMaterial((BlockState)this.material.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)this.material.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise()));
        } else if (this.material.hasProperty((Property)BlockStateProperties.AXIS)) {
            this.setMaterial((BlockState)this.material.cycle((Property)BlockStateProperties.AXIS));
        } else if (this.material.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            this.setMaterial((BlockState)this.material.cycle((Property)BlockStateProperties.HORIZONTAL_AXIS));
        } else if (this.material.hasProperty((Property)BlockStateProperties.LIT)) {
            this.setMaterial((BlockState)this.material.cycle((Property)BlockStateProperties.LIT));
        } else if (this.material.hasProperty((Property)RoseQuartzLampBlock.POWERING)) {
            this.setMaterial((BlockState)this.material.cycle((Property)RoseQuartzLampBlock.POWERING));
        } else {
            return false;
        }
        return true;
    }

    public ItemStack getConsumedItem() {
        return this.consumedItem;
    }

    public void setConsumedItem(ItemStack stack) {
        this.consumedItem = stack.copyWithCount(1);
        this.setChanged();
    }

    private void redraw() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        if (this.consumedItem.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.consumedItem);
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        this.material = transform.apply(this.material);
        this.notifyUpdate();
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.consumedItem = view.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        Optional state = view.read("Material", BlockState.CODEC);
        if (state.isEmpty()) {
            this.consumedItem = ItemStack.EMPTY;
            return;
        }
        BlockState prevMaterial = this.material;
        this.material = (BlockState)state.get();
        if (!clientPacket) {
            BlockState blockState = this.getBlockState();
            if (blockState == null) {
                return;
            }
            Block block = blockState.getBlock();
            if (!(block instanceof CopycatBlock)) {
                return;
            }
            CopycatBlock cb = (CopycatBlock)block;
            BlockState acceptedBlockState = cb.getAcceptedBlockState(this.level, this.worldPosition, this.consumedItem, null);
            if (acceptedBlockState != null && this.material.is(acceptedBlockState.getBlock())) {
                return;
            }
            this.consumedItem = ItemStack.EMPTY;
            this.material = AllBlocks.COPYCAT_BASE.defaultBlockState();
        }
        if (clientPacket && prevMaterial != this.material) {
            this.redraw();
        }
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.writeSafe(view);
        ItemStack stackWithoutComponents = new ItemStack(this.consumedItem.getItemHolder(), this.consumedItem.getCount(), DataComponentPatch.EMPTY);
        this.write(view, stackWithoutComponents, this.material);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.write(view, this.consumedItem, this.material);
    }

    protected void write(ValueOutput view, ItemStack stack, BlockState material) {
        if (!stack.isEmpty()) {
            view.store("Item", ItemStack.CODEC, (Object)stack);
        }
        view.store("Material", BlockState.CODEC, (Object)material);
    }
}

