/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.copycat;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.decoration.copycat.CopycatSpecialCases;
import com.zurrtum.create.content.decoration.copycat.WaterloggedCopycatBlock;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CopycatPanelBlock
extends WaterloggedCopycatBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public CopycatPanelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.UP));
    }

    @Override
    public boolean isAcceptedRegardless(BlockState material) {
        return CopycatSpecialCases.isBarsMaterial(material) || CopycatSpecialCases.isTrapdoorMaterial(material);
    }

    @Override
    public BlockState prepareMaterial(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, BlockState material) {
        if (!CopycatSpecialCases.isTrapdoorMaterial(material)) {
            return super.prepareMaterial(pLevel, pPos, pState, pPlayer, pHand, pHit, material);
        }
        Direction panelFacing = (Direction)pState.getValue(FACING);
        if (panelFacing == Direction.DOWN) {
            material = (BlockState)material.setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.TOP);
        }
        if (panelFacing.getAxis() == Direction.Axis.Y) {
            return (BlockState)((BlockState)material.setValue((Property)TrapDoorBlock.FACING, (Comparable)pPlayer.getDirection())).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(false));
        }
        boolean clickedNearTop = pHit.getLocation().y - 0.5 > (double)pPos.getY();
        return (BlockState)((BlockState)((BlockState)material.setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)TrapDoorBlock.HALF, (Comparable)(clickedNearTop ? Half.TOP : Half.BOTTOM))).setValue((Property)TrapDoorBlock.FACING, (Comparable)panelFacing);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper placementHelper;
        if (!player.isShiftKeyDown() && player.mayBuild() && (placementHelper = PlacementHelpers.get(placementHelperId)).matchesItem(stack)) {
            placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand);
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, @Nullable BlockPos fromPos, @Nullable BlockPos toPos) {
        if (fromPos == null || toPos == null) {
            return true;
        }
        Direction facing = (Direction)state.getValue(FACING);
        BlockState toState = reader.getBlockState(toPos);
        if (!toState.is((Block)this)) {
            return facing != face.getOpposite();
        }
        BlockPos diff = fromPos.subtract((Vec3i)toPos);
        int coord = facing.getAxis().choose(diff.getX(), diff.getY(), diff.getZ());
        return facing == ((Direction)toState.getValue(FACING)).getOpposite() && (coord == 0 || coord != facing.getAxisDirection().getStep());
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        Direction facing = (Direction)state.getValue(FACING);
        BlockState toState = reader.getBlockState(toPos);
        if (toPos.equals((Object)fromPos.relative(facing))) {
            return false;
        }
        BlockPos diff = fromPos.subtract((Vec3i)toPos);
        int coord = facing.getAxis().choose(diff.getX(), diff.getY(), diff.getZ());
        if (!toState.is((Block)this)) {
            return coord != -facing.getAxisDirection().getStep();
        }
        if (CopycatPanelBlock.isOccluded(state, toState, facing)) {
            return true;
        }
        return toState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) == state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) && coord == 0;
    }

    @Override
    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return ((Direction)state.getValue(FACING)).getOpposite() == face;
    }

    @Override
    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return this.canFaceBeOccluded(state, face.getOpposite());
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.getStateForPlacement(pContext);
        return (BlockState)stateForPlacement.setValue(FACING, (Comparable)pContext.getNearestLookingDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.add(new Property[]{FACING}));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.CASING_3PX.get((Direction)pState.getValue(FACING));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public static boolean isOccluded(BlockState state, BlockState other, Direction pDirection) {
        state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        other = (BlockState)other.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        Direction facing = (Direction)state.getValue(FACING);
        if (facing.getOpposite() == other.getValue(FACING) && pDirection == facing) {
            return true;
        }
        if (other.getValue(FACING) != facing) {
            return false;
        }
        return pDirection.getAxis() != facing.getAxis();
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return stack -> stack.is((Item)AllItems.COPYCAT_PANEL);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return state -> state.is((Block)AllBlocks.COPYCAT_PANEL);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), ((Direction)state.getValue(FACING)).getAxis(), (Direction dir) -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.relative(directions.getFirst()), s -> (BlockState)s.setValue(FACING, (Comparable)((Direction)state.getValue(FACING))));
        }
    }
}

