/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.copycat;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.math.VoxelShaper;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.decoration.copycat.WaterloggedCopycatBlock;
import com.zurrtum.create.foundation.placement.PoleHelper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopycatStepBlock
extends WaterloggedCopycatBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public CopycatStepBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM)).setValue(FACING, (Comparable)Direction.SOUTH));
    }

    @Override
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper helper;
        if (!player.isShiftKeyDown() && player.mayBuild() && (helper = PlacementHelpers.get(placementHelperId)).matchesItem(stack)) {
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, @Nullable BlockPos fromPos, @Nullable BlockPos toPos) {
        if (fromPos == null || toPos == null) {
            return true;
        }
        BlockState toState = reader.getBlockState(toPos);
        if (!toState.is((Block)this)) {
            return true;
        }
        Direction facing = (Direction)state.getValue(FACING);
        BlockPos diff = fromPos.subtract((Vec3i)toPos);
        int coord = facing.getAxis().choose(diff.getX(), diff.getY(), diff.getZ());
        Half half = (Half)state.getValue(HALF);
        if (half != toState.getValue(HALF)) {
            return diff.getY() == 0;
        }
        return facing == ((Direction)toState.getValue(FACING)).getOpposite() && (coord == 0 || coord == facing.getAxisDirection().getStep());
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        Direction facing = (Direction)state.getValue(FACING);
        BlockState toState = reader.getBlockState(toPos);
        BlockPos diff = fromPos.subtract((Vec3i)toPos);
        if (fromPos.equals((Object)toPos.relative(facing))) {
            return false;
        }
        if (!toState.is((Block)this)) {
            return false;
        }
        if (diff.getY() != 0) {
            return CopycatStepBlock.isOccluded(toState, state, diff.getY() > 0 ? Direction.UP : Direction.DOWN);
        }
        if (CopycatStepBlock.isOccluded(state, toState, facing)) {
            return true;
        }
        int coord = facing.getAxis().choose(diff.getX(), diff.getY(), diff.getZ());
        return state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) == toState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) && coord == 0;
    }

    @Override
    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        if (face.getAxis() == Direction.Axis.Y) {
            return state.getValue(HALF) == Half.TOP == (face == Direction.UP);
        }
        return state.getValue(FACING) == face;
    }

    @Override
    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return this.canFaceBeOccluded(state, face.getOpposite());
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState stateForPlacement = (BlockState)super.getStateForPlacement(pContext).setValue(FACING, (Comparable)pContext.getHorizontalDirection());
        Direction direction = pContext.getClickedFace();
        if (direction == Direction.UP) {
            return stateForPlacement;
        }
        if (direction == Direction.DOWN || pContext.getClickLocation().y - (double)pContext.getClickedPos().getY() > 0.5) {
            return (BlockState)stateForPlacement.setValue(HALF, (Comparable)Half.TOP);
        }
        return stateForPlacement;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.add(new Property[]{HALF, FACING}));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShaper voxelShaper = pState.getValue(HALF) == Half.BOTTOM ? AllShapes.STEP_BOTTOM : AllShapes.STEP_TOP;
        return voxelShaper.get((Direction)pState.getValue(FACING));
    }

    public static boolean isOccluded(BlockState state, BlockState other, Direction pDirection) {
        boolean vertical;
        state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        other = (BlockState)other.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        Half half = (Half)state.getValue(HALF);
        boolean bl = vertical = pDirection.getAxis() == Direction.Axis.Y;
        if (half != other.getValue(HALF)) {
            return vertical && pDirection == Direction.UP == (half == Half.TOP);
        }
        if (vertical) {
            return false;
        }
        Direction facing = (Direction)state.getValue(FACING);
        if (facing.getOpposite() == other.getValue(FACING) && pDirection == facing) {
            return true;
        }
        if (other.getValue(FACING) != facing) {
            return false;
        }
        return pDirection.getAxis() != facing.getAxis();
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue(FACING, (Comparable)pRot.rotate((Direction)pState.getValue(FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue(FACING)));
    }

    private static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(state -> state.is((Block)AllBlocks.COPYCAT_STEP), state -> ((Direction)state.getValue(FACING)).getClockWise().getAxis(), FACING);
        }

        @Override
        @NotNull
        public Predicate<ItemStack> getItemPredicate() {
            return stack -> stack.is((Item)AllItems.COPYCAT_STEP);
        }

        @Override
        @NotNull
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> (BlockState)s.setValue(HALF, (Comparable)((Half)state.getValue(HALF)))));
            }
            return offset;
        }
    }
}

