/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.encasing;

import com.zurrtum.create.content.decoration.encasing.EncasedBlock;
import com.zurrtum.create.content.decoration.encasing.EncasingRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public interface EncasableBlock {
    default public InteractionResult tryEncase(BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        List<Block> encasedVariants = EncasingRegistry.getVariants(state.getBlock());
        for (Block block : encasedVariants) {
            EncasedBlock encased;
            if (!(block instanceof EncasedBlock) || (encased = (EncasedBlock)block).getCasing().asItem() != heldItem.getItem()) continue;
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            encased.handleEncasing(state, level, pos, heldItem, player, hand, ray);
            this.playEncaseSound(level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    default public void playEncaseSound(Level level, BlockPos pos) {
        BlockState newState = level.getBlockState(pos);
        SoundType soundType = newState.getSoundType();
        level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
    }
}

