/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.palettes;

import com.zurrtum.create.content.decoration.palettes.ConnectedGlassBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WindowBlock
extends ConnectedGlassBlock {
    protected final boolean translucent;

    public WindowBlock(BlockBehaviour.Properties settings, boolean translucent) {
        super(settings);
        this.translucent = translucent;
    }

    public WindowBlock(BlockBehaviour.Properties settings) {
        this(settings, false);
    }

    public static WindowBlock translucent(BlockBehaviour.Properties settings) {
        return new WindowBlock(settings, true);
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    @Override
    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (state.getBlock() == adjacentBlockState.getBlock()) {
            return true;
        }
        Block block = state.getBlock();
        if (block instanceof WindowBlock) {
            WindowBlock windowBlock = (WindowBlock)block;
            if (adjacentBlockState.getBlock() instanceof ConnectedGlassBlock) {
                return !windowBlock.isTranslucent() && side.getAxis().isHorizontal();
            }
        }
        return super.skipRendering(state, adjacentBlockState, side);
    }
}

