/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.slidingDoor;

import com.mojang.serialization.Codec;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum DoorControl implements StringRepresentable
{
    ALL,
    NORTH,
    EAST,
    SOUTH,
    WEST,
    NONE;

    public static final Codec<DoorControl> CODEC;
    public static final StreamCodec<ByteBuf, DoorControl> STREAM_CODEC;

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean matches(Direction doorDirection) {
        return switch (this.ordinal()) {
            case 0 -> true;
            case 1 -> {
                if (doorDirection == Direction.NORTH) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (doorDirection == Direction.EAST) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (doorDirection == Direction.SOUTH) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (doorDirection == Direction.WEST) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    static {
        CODEC = StringRepresentable.fromEnum(DoorControl::values);
        STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(DoorControl.class);
    }
}

