/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment;

import com.zurrtum.create.catnip.levelWrappers.PlacementSimulationServerLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeFertilizerItem
extends Item {
    public TreeFertilizerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockState state = world.getBlockState(context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            if (state.is(BlockTags.SAPLINGS)) {
                if (((Boolean)state.getValueOrElse((Property)BlockStateProperties.HANGING, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                    return InteractionResult.PASS;
                }
                if (world.isClientSide()) {
                    BoneMealItem.addGrowthParticles((LevelAccessor)world, (BlockPos)context.getClickedPos(), (int)100);
                    return InteractionResult.SUCCESS;
                }
                BlockPos saplingPos = context.getClickedPos();
                TreesDreamWorld treesDreamWorld = new TreesDreamWorld((ServerLevel)world, saplingPos);
                for (BlockPos pos : BlockPos.betweenClosed((int)-1, (int)0, (int)-1, (int)1, (int)0, (int)1)) {
                    if (world.getBlockState(saplingPos.offset((Vec3i)pos)).getBlock() != block) continue;
                    treesDreamWorld.setBlockAndUpdate(pos.above(10), this.withStage(state, 1));
                }
                bonemealableBlock.performBonemeal((ServerLevel)treesDreamWorld, treesDreamWorld.getRandom(), BlockPos.ZERO.above(10), this.withStage(state, 1));
                for (BlockPos pos : treesDreamWorld.blocksAdded.keySet()) {
                    BlockPos actualPos = pos.offset((Vec3i)saplingPos).below(10);
                    BlockState newState = (BlockState)treesDreamWorld.blocksAdded.get(pos);
                    if (world.getBlockState(actualPos).getDestroySpeed((BlockGetter)world, actualPos) == -1.0f || !newState.isRedstoneConductor((BlockGetter)treesDreamWorld, pos) && !world.getBlockState(actualPos).getCollisionShape((BlockGetter)world, actualPos).isEmpty()) continue;
                    world.setBlockAndUpdate(actualPos, newState);
                }
                if (context.getPlayer() != null && !context.getPlayer().isCreative()) {
                    context.getItemInHand().shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    private BlockState withStage(BlockState original, int stage) {
        if (!original.hasProperty((Property)BlockStateProperties.STAGE)) {
            return original;
        }
        return (BlockState)original.setValue((Property)BlockStateProperties.STAGE, (Comparable)Integer.valueOf(stage));
    }

    private static class TreesDreamWorld
    extends PlacementSimulationServerLevel {
        private final BlockState soil;

        protected TreesDreamWorld(ServerLevel wrapped, BlockPos saplingPos) {
            super(wrapped);
            BlockState stateUnderSapling = wrapped.getBlockState(saplingPos.below());
            if (stateUnderSapling.is(BlockTags.DIRT)) {
                stateUnderSapling = Blocks.DIRT.defaultBlockState();
            }
            this.soil = stateUnderSapling;
        }

        @Override
        public BlockState getBlockState(BlockPos pos) {
            if (pos.getY() <= 9) {
                return this.soil;
            }
            return super.getBlockState(pos);
        }

        @Override
        public boolean setBlock(BlockPos pos, BlockState newState, int flags) {
            if (newState.getBlock() == Blocks.PODZOL) {
                return true;
            }
            return super.setBlock(pos, newState, flags);
        }
    }
}

