/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.armor;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.armor.BacktankUtil;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.ComparatorUtil;
import com.zurrtum.create.infrastructure.particle.AirParticleData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class BacktankBlockEntity
extends KineticBlockEntity
implements Nameable {
    public int airLevel;
    public int airLevelTimer;
    private final Component defaultName;
    private Component customName;
    private int capacityEnchantLevel;
    private DataComponentPatch componentPatch;

    public BacktankBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.BACKTANK, pos, state);
        this.defaultName = BacktankBlockEntity.getDefaultName(state);
        this.componentPatch = DataComponentPatch.EMPTY;
    }

    public static Component getDefaultName(BlockState state) {
        if (state.is((Block)AllBlocks.NETHERITE_BACKTANK)) {
            AllItems.NETHERITE_BACKTANK.getName();
        }
        return AllItems.COPPER_BACKTANK.getName();
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.BACKTANK);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (this.getSpeed() != 0.0f) {
            this.award(AllAdvancements.BACKTANK);
        }
    }

    @Override
    public void tick() {
        BooleanProperty waterProperty;
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)(waterProperty = BlockStateProperties.WATERLOGGED)) && ((Boolean)state.getValue((Property)waterProperty)).booleanValue()) {
            return;
        }
        if (this.airLevelTimer > 0) {
            --this.airLevelTimer;
            return;
        }
        int max = BacktankUtil.maxAir(this.capacityEnchantLevel);
        if (this.level.isClientSide()) {
            Vec3 centerOf = VecHelper.getCenterOf((Vec3i)this.worldPosition);
            Vec3 v = VecHelper.offsetRandomly(centerOf, this.level.random, 0.65f);
            Vec3 m = centerOf.subtract(v);
            if (this.airLevel != max) {
                this.level.addParticle((ParticleOptions)new AirParticleData(1.0f, 0.05f), v.x, v.y, v.z, m.x, m.y, m.z);
            }
            return;
        }
        if (this.airLevel == max) {
            return;
        }
        int prevComparatorLevel = this.getComparatorOutput();
        float abs = Math.abs(this.getSpeed());
        int increment = Mth.clamp((int)(((int)abs - 100) / 20), (int)1, (int)5);
        this.airLevel = Math.min(max, this.airLevel + increment);
        if (this.getComparatorOutput() != prevComparatorLevel && !this.level.isClientSide()) {
            this.level.updateNeighbourForOutputSignal(this.worldPosition, state.getBlock());
        }
        if (this.airLevel == max) {
            this.sendData();
        }
        this.airLevelTimer = Mth.clamp((int)((int)(128.0f - abs / 5.0f) - 108), (int)0, (int)20);
    }

    public int getComparatorOutput() {
        int max = BacktankUtil.maxAir(this.capacityEnchantLevel);
        return ComparatorUtil.fractionToRedstoneLevel((float)this.airLevel / (float)max);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putInt("Air", this.airLevel);
        view.putInt("Timer", this.airLevelTimer);
        view.putInt("CapacityEnchantment", this.capacityEnchantLevel);
        if (this.customName != null) {
            view.store("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
        }
        view.store("Components", DataComponentPatch.CODEC, (Object)this.componentPatch);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        int prev = this.airLevel;
        this.airLevel = view.getIntOr("Air", 0);
        this.airLevelTimer = view.getIntOr("Timer", 0);
        this.capacityEnchantLevel = view.getIntOr("CapacityEnchantment", 0);
        this.customName = view.read("CustomName", ComponentSerialization.CODEC).orElse(null);
        this.componentPatch = view.read("Components", DataComponentPatch.CODEC).orElse(DataComponentPatch.EMPTY);
        if (prev != 0 && prev != this.airLevel && this.airLevel == BacktankUtil.maxAir(this.capacityEnchantLevel) && clientPacket) {
            this.playFilledEffect();
        }
    }

    protected void applyImplicitComponents(DataComponentGetter componentInput) {
        this.setAirLevel((Integer)componentInput.getOrDefault(AllDataComponents.BACKTANK_AIR, (Object)0));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(AllDataComponents.BACKTANK_AIR, (Object)this.airLevel);
    }

    protected void playFilledEffect() {
        AllSoundEvents.CONFIRM.playAt(this.level, (Vec3i)this.worldPosition, 0.4f, 1.0f, true);
        Vec3 baseMotion = new Vec3(0.25, 0.1, 0.0);
        Vec3 baseVec = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        for (int i = 0; i < 360; i += 10) {
            Vec3 m = VecHelper.rotate(baseMotion, i, Direction.Axis.Y);
            Vec3 v = baseVec.add(m.normalize().scale(0.25));
            this.level.addParticle((ParticleOptions)ParticleTypes.SPIT, v.x, v.y, v.z, m.x, m.y, m.z);
        }
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.defaultName;
    }

    public int getAirLevel() {
        return this.airLevel;
    }

    public void setAirLevel(int airLevel) {
        this.airLevel = airLevel;
        this.sendData();
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
    }

    public void setComponentPatch(DataComponentPatch componentPatch) {
        this.componentPatch = componentPatch;
    }

    public DataComponentPatch getComponentPatch() {
        return this.componentPatch;
    }
}

