/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.armor;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.content.equipment.armor.BacktankUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class BacktankItem
extends BlockItem {
    public static final EquipmentSlot SLOT = EquipmentSlot.CHEST;
    public static final int BAR_COLOR = 0xEFEFEF;

    public BacktankItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public static BacktankItem copper(Item.Properties settings) {
        return new BacktankItem(AllBlocks.COPPER_BACKTANK, settings);
    }

    public static BacktankItem netherite(Item.Properties settings) {
        return new BacktankItem(AllBlocks.NETHERITE_BACKTANK, settings);
    }

    public ItemStack getMaxAirStack() {
        ItemStack stack = this.getDefaultInstance();
        stack.set(AllDataComponents.BACKTANK_AIR, (Object)BacktankUtil.maxAirWithoutEnchants());
        return stack;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * Mth.clamp((float)((float)BacktankItem.getRemainingAir(stack) / (float)BacktankUtil.maxAir(stack)), (float)0.0f, (float)1.0f));
    }

    public int getBarColor(ItemStack stack) {
        return 0xEFEFEF;
    }

    public static int getRemainingAir(ItemStack stack) {
        return (Integer)stack.getOrDefault(AllDataComponents.BACKTANK_AIR, (Object)0);
    }
}

