/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.armor;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.content.equipment.armor.CardboardArmorItem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CardboardArmorHandler {
    public static EntityDimensions playerHitboxChangesWhenHidingAsBox(Entity entity) {
        float scale;
        if (!CardboardArmorHandler.testForStealth(entity)) {
            return null;
        }
        if (!CardboardArmorHandler.testForStealth(entity)) {
            return null;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            scale = le.getScale();
        } else {
            scale = 1.0f;
        }
        if (!entity.level().isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            AllAdvancements.CARDBOARD_ARMOR.trigger(serverPlayer);
        }
        float width = 0.6f * scale;
        float height = 0.8f * scale;
        return new EntityDimensions(width, height, width, EntityAttachments.createDefault((float)width, (float)height), true);
    }

    public static void playerChangesEquipment(Player player) {
        if (player.getPose() == Pose.CROUCHING && (CardboardArmorHandler.isCardboardArmor(player.getItemBySlot(EquipmentSlot.HEAD)) || CardboardArmorHandler.isCardboardArmor(player.getItemBySlot(EquipmentSlot.CHEST)) || CardboardArmorHandler.isCardboardArmor(player.getItemBySlot(EquipmentSlot.LEGS)) || CardboardArmorHandler.isCardboardArmor(player.getItemBySlot(EquipmentSlot.FEET)))) {
            player.getEntityData().set(Entity.DATA_POSE, (Object)Pose.CROUCHING, true);
        }
    }

    public static void mobsMayLoseTargetWhenItIsWearingCardboard(Entity entity) {
        Level tg;
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (mob.tickCount % 16 != 0) {
            return;
        }
        if (CardboardArmorHandler.testForStealth((Entity)mob.getTarget())) {
            mob.setTarget(null);
            if (mob.targetSelector != null) {
                for (WrappedGoal goal : mob.targetSelector.getAvailableGoals()) {
                    Goal goal2;
                    if (!goal.isRunning() || !((goal2 = goal.getGoal()) instanceof TargetGoal)) continue;
                    tg = (TargetGoal)goal2;
                    tg.stop();
                }
            }
        }
        if (entity instanceof NeutralMob) {
            NeutralMob nMob = (NeutralMob)entity;
            tg = entity.level();
            if (tg instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)tg;
                LivingEntity target = EntityReference.getLivingEntity((EntityReference)nMob.getPersistentAngerTarget(), (Level)sl);
                if (CardboardArmorHandler.testForStealth((Entity)target)) {
                    nMob.stopBeingAngry();
                }
            }
        }
        if (CardboardArmorHandler.testForStealth((Entity)mob.getLastHurtByMob())) {
            mob.setLastHurtByMob(null);
            mob.setLastHurtByPlayer((EntityReference)null, 0);
        }
    }

    public static boolean testForStealth(Entity entityIn) {
        if (!(entityIn instanceof LivingEntity)) {
            return false;
        }
        LivingEntity entity = (LivingEntity)entityIn;
        if (entity.getPose() != Pose.CROUCHING) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().flying) {
                return false;
            }
        }
        if (!CardboardArmorHandler.isCardboardArmor(entity.getItemBySlot(EquipmentSlot.HEAD))) {
            return false;
        }
        if (!CardboardArmorHandler.isCardboardArmor(entity.getItemBySlot(EquipmentSlot.CHEST))) {
            return false;
        }
        if (!CardboardArmorHandler.isCardboardArmor(entity.getItemBySlot(EquipmentSlot.LEGS))) {
            return false;
        }
        return CardboardArmorHandler.isCardboardArmor(entity.getItemBySlot(EquipmentSlot.FEET));
    }

    public static boolean isCardboardArmor(ItemStack stack) {
        return stack.getItem() instanceof CardboardArmorItem;
    }
}

