/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.bell;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.infrastructure.packet.s2c.SoulPulseEffectPacket;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;

public class HauntedBellPulser {
    public static final int DISTANCE = 3;
    public static final int RECHARGE_TICKS = 8;
    public static final int WARMUP_TICKS = 10;
    public static final Cache<UUID, IntAttached<Entity>> WARMUP = CacheBuilder.newBuilder().expireAfterAccess(250L, TimeUnit.MILLISECONDS).build();

    public static void hauntedBellCreatesPulse(ServerPlayer player) {
        ServerLevel serverLevel;
        if (player.isSpectator()) {
            return;
        }
        if (!player.isHolding(item -> item.is((Item)AllItems.HAUNTED_BELL))) {
            return;
        }
        boolean firstPulse = false;
        try {
            IntAttached ticker = (IntAttached)WARMUP.get((Object)player.getUUID(), () -> IntAttached.with(10, player));
            firstPulse = (Integer)ticker.getFirst() == 1;
            ticker.decrement();
            if (!ticker.isOrBelowZero()) {
                return;
            }
        }
        catch (ExecutionException ticker) {
            // empty catch block
        }
        long gameTime = player.level().getGameTime();
        if ((firstPulse || gameTime % 8L != 0L) && (serverLevel = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel2 = serverLevel;
            HauntedBellPulser.sendPulse(serverLevel2, player.blockPosition(), 3, false);
        }
    }

    public static void sendPulse(ServerLevel world, BlockPos pos, int distance, boolean canOverlap) {
        ChunkPos chunk = world.getChunk(pos).getPos();
        SoulPulseEffectPacket packet = new SoulPulseEffectPacket(pos, distance, canOverlap);
        for (ServerPlayer player : world.getChunkSource().chunkMap.getPlayers(chunk, false)) {
            player.connection.send((Packet)packet);
        }
    }
}

