/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.blueprint;

import com.google.common.cache.Cache;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.api.schematic.requirement.SpecialEntityItemRequirement;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.blueprint.BlueprintMenu;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.utility.IInteractionChecker;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.BlueprintPreviewPacket;
import com.zurrtum.create.infrastructure.packet.s2c.NbtSpawnPacket;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlueprintEntity
extends HangingEntity
implements SpecialEntityItemRequirement,
IInteractionChecker {
    private static final Cache<String, BlueprintPreviewPacket> PREVIEW_CACHE = new TickBasedCache<String, BlueprintPreviewPacket>(20, true);
    private static final EntityDataAccessor<CompoundTag> RECIPES = SynchedEntityData.defineId(BlueprintEntity.class, AllSynchedDatas.NBT_COMPOUND_HANDLER);
    public int size;
    protected Direction verticalOrientation;
    private final Map<Integer, BlueprintSection> sectionCache = new HashMap<Integer, BlueprintSection>();

    public BlueprintEntity(EntityType<? extends BlueprintEntity> p_i50221_1_, Level p_i50221_2_) {
        super(p_i50221_1_, p_i50221_2_);
        this.size = 1;
    }

    public BlueprintEntity(Level world, BlockPos pos, Direction facing, Direction verticalOrientation) {
        super(AllEntityTypes.CRAFTING_BLUEPRINT, world, pos);
        int size = 3;
        while (size > 0) {
            this.size = size--;
            this.updateFacingWithBoundingBox(facing, verticalOrientation);
            if (this.survives()) break;
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_POSE.equals(data)) {
            this.refreshDimensions();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RECIPES, (Object)new CompoundTag());
    }

    public void addAdditionalSaveData(ValueOutput view) {
        view.store("Orientation", (Codec)Direction.CODEC, (Object)this.verticalOrientation);
        view.store("Facing", (Codec)Direction.CODEC, (Object)this.getDirection());
        view.putInt("Size", this.size);
        view.store("Recipes", CompoundTag.CODEC, (Object)((CompoundTag)this.entityData.get(RECIPES)));
        super.addAdditionalSaveData(view);
    }

    public void readAdditionalSaveData(ValueInput view) {
        this.verticalOrientation = view.read("Orientation", (Codec)Direction.CODEC).orElse(Direction.DOWN);
        this.size = view.getIntOr("Size", 1);
        view.read("Recipes", CompoundTag.CODEC).ifPresent(nbt -> this.entityData.set(RECIPES, nbt));
        super.readAdditionalSaveData(view);
        Direction direction = view.read("Facing", (Codec)Direction.CODEC).orElse(Direction.DOWN);
        this.updateFacingWithBoundingBox(direction, this.verticalOrientation);
    }

    protected void updateFacingWithBoundingBox(Direction facing, Direction verticalOrientation) {
        Objects.requireNonNull(facing);
        this.setDirectionRaw(facing);
        this.verticalOrientation = verticalOrientation;
        if (facing.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(facing.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * facing.getAxisDirection().getStep());
            this.setYRot(verticalOrientation.getAxis().isHorizontal() ? 180.0f + verticalOrientation.toYRot() : 0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    public EntityDimensions getDimensions(Pose pose) {
        return super.getDimensions(pose).withEyeHeight(0.0f);
    }

    protected AABB calculateBoundingBox(BlockPos blockPos, Direction direction) {
        Vec3 pos = Vec3.atLowerCornerOf((Vec3i)this.getPos()).add(0.5, 0.5, 0.5).subtract(Vec3.atLowerCornerOf((Vec3i)direction.getUnitVec3i()).scale(0.46875));
        double d1 = pos.x;
        double d2 = pos.y;
        double d3 = pos.z;
        this.setPosRaw(d1, d2, d3);
        Direction.Axis axis = direction.getAxis();
        if (this.size == 2) {
            pos = pos.add(Vec3.atLowerCornerOf((Vec3i)(axis.isHorizontal() ? direction.getCounterClockWise().getUnitVec3i() : this.verticalOrientation.getClockWise().getUnitVec3i())).scale(0.5)).add(Vec3.atLowerCornerOf((Vec3i)(axis.isHorizontal() ? Direction.UP.getUnitVec3i() : (direction == Direction.UP ? this.verticalOrientation.getUnitVec3i() : this.verticalOrientation.getOpposite().getUnitVec3i()))).scale(0.5));
        }
        d1 = pos.x;
        d2 = pos.y;
        d3 = pos.z;
        double d4 = this.getEntityWidth();
        double d5 = this.getEntityHeight();
        double d6 = d4;
        Direction.Axis direction$axis = this.getDirection().getAxis();
        switch (direction$axis) {
            case X: {
                d4 = 1.0;
                break;
            }
            case Y: {
                d5 = 1.0;
                break;
            }
            case Z: {
                d6 = 1.0;
            }
        }
        return new AABB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6);
    }

    protected void recalculateBoundingBox() {
        Direction direction = this.getDirection();
        if (direction != null && this.verticalOrientation != null) {
            this.setBoundingBox(this.calculateBoundingBox(this.pos, direction));
        }
    }

    public void setPos(double pX, double pY, double pZ) {
        this.setPosRaw(pX, pY, pZ);
        super.setPos(pX, pY, pZ);
    }

    public boolean survives() {
        Level world = this.level();
        if (!world.noCollision((Entity)this)) {
            return false;
        }
        int i = Math.max(1, this.getEntityWidth() / 16);
        int j = Math.max(1, this.getEntityHeight() / 16);
        Direction direction = this.getDirection();
        BlockPos blockpos = this.pos.relative(direction.getOpposite());
        Direction upDirection = direction.getAxis().isHorizontal() ? Direction.UP : (direction == Direction.UP ? this.verticalOrientation : this.verticalOrientation.getOpposite());
        Direction newDirection = direction.getAxis().isVertical() ? this.verticalOrientation.getClockWise() : direction.getCounterClockWise();
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutable.set((Vec3i)blockpos).move(newDirection, k + i1).move(upDirection, l + j1);
                BlockState blockstate = world.getBlockState((BlockPos)blockpos$mutable);
                if (Block.canSupportCenter((LevelReader)world, (BlockPos)blockpos$mutable, (Direction)direction) || blockstate.isSolid() || DiodeBlock.isDiode((BlockState)blockstate)) continue;
                return false;
            }
        }
        return this.canCoexist(true);
    }

    public int getEntityWidth() {
        return 16 * this.size;
    }

    public int getEntityHeight() {
        return 16 * this.size;
    }

    public boolean skipAttackInteraction(Entity source) {
        Player player;
        block7: {
            block6: {
                if (!(source instanceof Player)) break block6;
                player = (Player)source;
                if (!this.level().isClientSide()) break block7;
            }
            return super.skipAttackInteraction(source);
        }
        double attrib = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + (double)(player.isCreative() ? 0.0f : -0.5f);
        Vec3 eyePos = source.getEyePosition(1.0f);
        Vec3 look = source.getViewVector(1.0f);
        Vec3 target = eyePos.add(look.scale(attrib));
        Optional rayTrace = this.getBoundingBox().clip(eyePos, target);
        if (!rayTrace.isPresent()) {
            return super.skipAttackInteraction(source);
        }
        Vec3 hitVec = (Vec3)rayTrace.get();
        BlueprintSection sectionAt = this.getSectionAt(hitVec.subtract(this.position()));
        ItemStackHandler items = sectionAt.getItems();
        if (items.getItem(9).isEmpty()) {
            return super.skipAttackInteraction(source);
        }
        int size = items.getContainerSize();
        for (int i = 0; i < size; ++i) {
            items.setItem(i, ItemStack.EMPTY);
        }
        sectionAt.save(items);
        return true;
    }

    public void dropItem(ServerLevel world, @Nullable Entity p_110128_1_) {
        if (!((Boolean)world.getGameRules().get(GameRules.ENTITY_DROPS)).booleanValue()) {
            return;
        }
        this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
        if (p_110128_1_ instanceof Player) {
            Player playerentity = (Player)p_110128_1_;
            if (playerentity.getAbilities().instabuild) {
                return;
            }
        }
        this.spawnAtLocation(world, AllItems.CRAFTING_BLUEPRINT.getDefaultInstance());
    }

    @Nullable
    public ItemStack getPickResult() {
        return AllItems.CRAFTING_BLUEPRINT.getDefaultInstance();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllItems.CRAFTING_BLUEPRINT);
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.PAINTING_PLACE, 1.0f, 1.0f);
    }

    public void snapTo(double p_70012_1_, double p_70012_3_, double p_70012_5_, float p_70012_7_, float p_70012_8_) {
        this.setPos(p_70012_1_, p_70012_3_, p_70012_5_);
    }

    public void moveOrInterpolateTo(Vec3 pos, float yaw, float pitch) {
        BlockPos blockpos = this.pos.offset((Vec3i)BlockPos.containing((double)(pos.x() - this.getX()), (double)(pos.y() - this.getY()), (double)(pos.z() - this.getZ())));
        this.setPos(blockpos.getX(), blockpos.getY(), blockpos.getZ());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.problemPath(), Create.LOGGER);){
            TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)this.registryAccess());
            this.addAdditionalSaveData((ValueOutput)view);
            NbtSpawnPacket nbtSpawnPacket = new NbtSpawnPacket((Entity)this, entityTrackerEntry, view.buildResult());
            return nbtSpawnPacket;
        }
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        CompoundTag nbt = ((NbtSpawnPacket)packet).getNbt();
        if (nbt == null) {
            return;
        }
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.problemPath(), Create.LOGGER);){
            this.readAdditionalSaveData(TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)this.registryAccess(), (CompoundTag)nbt));
        }
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (FakePlayerHandler.has((Entity)player)) {
            return InteractionResult.PASS;
        }
        boolean holdingWrench = player.getItemInHand(hand).is((Item)AllItems.WRENCH);
        BlueprintSection section = this.getSectionAt(vec);
        ItemStackHandler items = section.getItems();
        Level world = this.level();
        if (!(holdingWrench || world.isClientSide() || items.getItem(9).isEmpty())) {
            RegistryAccess registryManager = world.registryAccess();
            Inventory playerInv = player.getInventory();
            int size = playerInv.getContainerSize();
            boolean firstPass = true;
            int amountCrafted = 0;
            RecipeHolder recipe = null;
            ArrayList<ItemStack> results = null;
            do {
                int[] stacksTaken = new int[size];
                int max = 0;
                ArrayList<ItemStack> craftingStacks = new ArrayList<ItemStack>(9);
                boolean success = true;
                block1: for (int i = 0; i < 9; ++i) {
                    ItemStack filter = items.getItem(i);
                    if (filter.isEmpty()) {
                        craftingStacks.add(ItemStack.EMPTY);
                        continue;
                    }
                    FilterItemStack requestedItem = FilterItemStack.of(filter);
                    for (int slot = 0; slot < size; ++slot) {
                        ItemStack stack = playerInv.getItem(slot);
                        if (!requestedItem.test(world, stack)) continue;
                        int used = stacksTaken[slot];
                        if (stack.getCount() == used) continue;
                        stacksTaken[slot] = used + 1;
                        craftingStacks.add(stack.copyWithCount(1));
                        if (slot <= max) continue block1;
                        max = slot;
                        continue block1;
                    }
                    success = false;
                    break;
                }
                if (success) {
                    CraftingInput input = CraftingInput.of((int)3, (int)3, craftingStacks);
                    recipe = ((ServerLevel)world).recipeAccess().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, world, recipe).orElse(null);
                    if (recipe == null) {
                        success = false;
                    } else {
                        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe.value();
                        ItemStack result = craftingRecipe.assemble((RecipeInput)input, (HolderLookup.Provider)registryManager);
                        if (result.isEmpty() || result.getCount() + amountCrafted > 64) {
                            success = false;
                        } else {
                            amountCrafted += result.getCount();
                            result.onCraftedBy(player, 1);
                            results = new ArrayList<ItemStack>();
                            results.add(result);
                            for (ItemStack stack : craftingRecipe.getRemainingItems(input)) {
                                if (stack.isEmpty()) continue;
                                results.add(stack);
                            }
                            if (firstPass) {
                                world.playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + world.getRandom().nextFloat());
                                firstPass = false;
                            }
                        }
                    }
                }
                if (!success) break;
                for (int slot = 0; slot <= max; ++slot) {
                    int used = stacksTaken[slot];
                    if (used == 0) continue;
                    ItemStack stack = playerInv.getItem(slot);
                    int count = stack.getCount();
                    if (count == used) {
                        stack = ItemStack.EMPTY;
                    } else {
                        stack.setCount(count - used);
                    }
                    playerInv.setItem(slot, stack);
                }
                playerInv.setChanged();
                for (ItemStack stack : results) {
                    player.getInventory().placeItemBackInInventory(stack);
                }
            } while (player.isShiftKeyDown());
            PREVIEW_CACHE.invalidate((Object)(this.getId() + "_" + section.index + "_" + player.getId() + (player.isShiftKeyDown() ? "_sneaking" : "")));
            return InteractionResult.SUCCESS;
        }
        if (!world.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuProvider.openHandledScreen(serverPlayer, section);
        }
        return InteractionResult.SUCCESS;
    }

    public static BlueprintPreviewPacket getPreview(BlueprintEntity be, int index, ServerPlayer player, boolean sneaking) {
        try {
            return (BlueprintPreviewPacket)PREVIEW_CACHE.get((Object)(be.getId() + "_" + index + "_" + player.getId() + (sneaking ? "_sneaking" : "")), () -> BlueprintEntity.createPreview(be, index, player, sneaking));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return BlueprintPreviewPacket.EMPTY;
        }
    }

    private static BlueprintPreviewPacket createPreview(BlueprintEntity be, int index, ServerPlayer player, boolean sneaking) {
        BlueprintSection section = be.getSection(index);
        ItemStackHandler items = section.getItems();
        if (items.isEmpty()) {
            return BlueprintPreviewPacket.EMPTY;
        }
        ServerLevel world = player.level();
        Inventory playerInv = player.getInventory();
        int size = playerInv.getContainerSize();
        int[] stacksTaken = new int[size];
        ArrayList<FilterItemStack> requestedItems = new ArrayList<FilterItemStack>(9);
        ArrayList<ItemStack> craftingStacks = new ArrayList<ItemStack>(9);
        Object2IntLinkedOpenCustomHashMap<ItemStack> missingStacks = BlueprintPreviewPacket.createMap();
        Object2IntLinkedOpenCustomHashMap<ItemStack> availableStacks = BlueprintPreviewPacket.createMap();
        block0: for (int i = 0; i < 9; ++i) {
            FilterItemStack requestedItem = FilterItemStack.of(items.getItem(i));
            if (requestedItem.isEmpty()) {
                requestedItems.add(null);
                craftingStacks.add(ItemStack.EMPTY);
                continue;
            }
            requestedItems.add(requestedItem);
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stack2 = playerInv.getItem(slot);
                if (!requestedItem.test((Level)world, stack2)) continue;
                int used = stacksTaken[slot];
                if (stack2.getCount() == used) continue;
                stacksTaken[slot] = used + 1;
                craftingStacks.add(stack2.copyWithCount(1));
                availableStacks.merge((Object)stack2, 1, Integer::sum);
                continue block0;
            }
            missingStacks.merge((Object)requestedItem.item(), 1, Integer::sum);
        }
        if (!missingStacks.isEmpty()) {
            return new BlueprintPreviewPacket(availableStacks, missingStacks, items.getItem(9));
        }
        CraftingInput input = CraftingInput.of((int)3, (int)3, craftingStacks);
        Optional<ItemStack> result = world.recipeAccess().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, (Level)world).map(entry -> ((CraftingRecipe)entry.value()).assemble((RecipeInput)input, (HolderLookup.Provider)world.registryAccess())).filter(stack -> !stack.isEmpty());
        if (result.isEmpty()) {
            return new BlueprintPreviewPacket(availableStacks, List.of(), ItemStack.EMPTY);
        }
        ItemStack resultStack = result.get();
        if (sneaking) {
            int max = resultStack.getMaxStackSize();
            int craftingCount = resultStack.getCount();
            if (craftingCount < max) {
                int count = craftingCount;
                Object2IntLinkedOpenCustomHashMap<ItemStack> ingredients = BlueprintPreviewPacket.createMap(availableStacks);
                block2: while (count + craftingCount <= max) {
                    block3: for (int i = 0; i < 9; ++i) {
                        FilterItemStack requestedItem = (FilterItemStack)requestedItems.get(i);
                        if (requestedItem == null) continue;
                        for (int slot = 0; slot < size; ++slot) {
                            ItemStack stack3 = playerInv.getItem(slot);
                            if (!requestedItem.test((Level)world, stack3)) continue;
                            int used = stacksTaken[slot];
                            if (stack3.getCount() == used) continue;
                            stacksTaken[slot] = used + 1;
                            continue block3;
                        }
                        break block2;
                    }
                    ObjectBidirectionalIterator iterator = availableStacks.object2IntEntrySet().fastIterator();
                    do {
                        Object2IntMap.Entry entry2 = (Object2IntMap.Entry)iterator.next();
                        entry2.setValue(entry2.getIntValue() + ingredients.getInt(entry2.getKey()));
                    } while (iterator.hasNext());
                    count += craftingCount;
                }
                resultStack.setCount(count);
            }
        }
        return new BlueprintPreviewPacket(availableStacks, List.of(), resultStack);
    }

    public BlueprintSection getSectionAt(Vec3 vec) {
        int index = 0;
        if (this.size > 1) {
            vec = VecHelper.rotate(vec, this.getYRot(), Direction.Axis.Y);
            vec = VecHelper.rotate(vec, -this.getXRot(), Direction.Axis.X);
            vec = vec.add(0.5, 0.5, 0.0);
            if (this.size == 3) {
                vec = vec.add(1.0, 1.0, 0.0);
            }
            int x = Mth.clamp((int)Mth.floor((double)vec.x), (int)0, (int)(this.size - 1));
            int y = Mth.clamp((int)Mth.floor((double)vec.y), (int)0, (int)(this.size - 1));
            index = x + y * this.size;
        }
        return this.getSection(index);
    }

    public Optional<CompoundTag> getRecipeCompound(int index) {
        return ((CompoundTag)this.entityData.get(RECIPES)).getCompound(Integer.toString(index));
    }

    public void putRecipeCompound(int index, CompoundTag compound) {
        CompoundTag recipes = (CompoundTag)this.entityData.get(RECIPES);
        recipes.put(Integer.toString(index), (Tag)compound);
        this.entityData.set(RECIPES, (Object)recipes, true);
    }

    public BlueprintSection getSection(int index) {
        return this.sectionCache.computeIfAbsent(index, x$0 -> new BlueprintSection((int)x$0));
    }

    @Override
    public boolean canPlayerUse(Player player) {
        AABB box = this.getBoundingBox();
        double dx = 0.0;
        if (box.minX > player.getX()) {
            dx = box.minX - player.getX();
        } else if (player.getX() > box.maxX) {
            dx = player.getX() - box.maxX;
        }
        double dy = 0.0;
        if (box.minY > player.getY()) {
            dy = box.minY - player.getY();
        } else if (player.getY() > box.maxY) {
            dy = player.getY() - box.maxY;
        }
        double dz = 0.0;
        if (box.minZ > player.getZ()) {
            dz = box.minZ - player.getZ();
        } else if (player.getZ() > box.maxZ) {
            dz = player.getZ() - box.maxZ;
        }
        return dx * dx + dy * dy + dz * dz <= 64.0;
    }

    public class BlueprintSection
    implements MenuProvider,
    IInteractionChecker {
        private static final Couple<ItemStack> EMPTY_DISPLAY = Couple.create(ItemStack.EMPTY, ItemStack.EMPTY);
        public int index;
        Couple<ItemStack> cachedDisplayItems;
        public boolean inferredIcon = false;

        public BlueprintSection(int index) {
            this.index = index;
        }

        public Couple<ItemStack> getDisplayItems() {
            if (this.cachedDisplayItems != null) {
                return this.cachedDisplayItems;
            }
            return BlueprintEntity.this.getRecipeCompound(this.index).flatMap(nbt -> nbt.read("Inventory", CreateCodecs.ITEM_LIST_CODEC).map(items -> Couple.create((ItemStack)items.get(9), (ItemStack)items.get(10)))).orElse(EMPTY_DISPLAY);
        }

        public ItemStackHandler getItems() {
            ItemStackHandler newInv = new ItemStackHandler(11);
            BlueprintEntity.this.getRecipeCompound(this.index).ifPresentOrElse(nbt -> {
                try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(BlueprintEntity.this.problemPath(), Create.LOGGER);){
                    ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)BlueprintEntity.this.registryAccess(), (CompoundTag)nbt);
                    newInv.readSlots(view);
                    this.inferredIcon = view.getBooleanOr("InferredIcon", false);
                }
            }, () -> {
                this.inferredIcon = false;
            });
            return newInv;
        }

        public void save(ItemStackHandler inventory) {
            this.cachedDisplayItems = null;
            if (!BlueprintEntity.this.level().isClientSide()) {
                try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(BlueprintEntity.this.problemPath(), Create.LOGGER);){
                    TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)BlueprintEntity.this.registryAccess());
                    inventory.writeSlots((ValueOutput)view);
                    view.putBoolean("InferredIcon", this.inferredIcon);
                    BlueprintEntity.this.putRecipeCompound(this.index, view.buildResult());
                }
            }
        }

        public boolean isEntityAlive() {
            return BlueprintEntity.this.isAlive();
        }

        public Level getBlueprintWorld() {
            return BlueprintEntity.this.level();
        }

        public BlueprintMenu createMenu(int id, Inventory inv, Player player, RegistryFriendlyByteBuf extraData) {
            extraData.writeVarInt(BlueprintEntity.this.getId());
            extraData.writeVarInt(this.index);
            return new BlueprintMenu(id, inv, this);
        }

        @Override
        public Component getDisplayName() {
            return AllItems.CRAFTING_BLUEPRINT.getName();
        }

        @Override
        public boolean canPlayerUse(Player player) {
            return BlueprintEntity.this.canPlayerUse(player);
        }
    }
}

