/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.blueprint;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import com.zurrtum.create.foundation.gui.menu.GhostItemMenu;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BlueprintMenu
extends GhostItemMenu<BlueprintEntity.BlueprintSection> {
    public BlueprintMenu(int id, Inventory inv, BlueprintEntity.BlueprintSection section) {
        super(AllMenuTypes.CRAFTING_BLUEPRINT, id, inv, section);
    }

    @Override
    protected boolean allowRepeats() {
        return true;
    }

    @Override
    protected void addSlots() {
        this.addPlayerSlots(8, 131);
        int x = 29;
        int y = 21;
        int index = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.addSlot(new BlueprintCraftSlot(this.ghostInventory, index++, x + col * 18, y + row * 18));
            }
        }
        this.addSlot(new BlueprintCraftSlot(this.ghostInventory, index++, 123, 40));
        this.addSlot(new Slot((Container)this.ghostInventory, index++, 135, 57));
    }

    public void onCraftMatrixChanged() {
        Level level = ((BlueprintEntity.BlueprintSection)this.contentHolder).getBlueprintWorld();
        if (level.isClientSide()) {
            return;
        }
        ServerPlayer serverplayerentity = (ServerPlayer)this.player;
        CraftingInput input = CraftingInput.of((int)3, (int)3, (List)this.ghostInventory.getStacks().subList(0, 9));
        Optional optional = ((ServerLevel)level).recipeAccess().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, level);
        if (optional.isEmpty()) {
            if (this.ghostInventory.getItem(9).isEmpty()) {
                return;
            }
            if (!((BlueprintEntity.BlueprintSection)this.contentHolder).inferredIcon) {
                return;
            }
            this.ghostInventory.setItem(9, ItemStack.EMPTY);
            serverplayerentity.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 45, ItemStack.EMPTY));
            ((BlueprintEntity.BlueprintSection)this.contentHolder).inferredIcon = false;
            return;
        }
        CraftingRecipe icraftingrecipe = (CraftingRecipe)((RecipeHolder)optional.get()).value();
        ItemStack itemstack = icraftingrecipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
        this.ghostInventory.setItem(9, itemstack);
        ((BlueprintEntity.BlueprintSection)this.contentHolder).inferredIcon = true;
        ItemStack toSend = itemstack.copy();
        toSend.set(AllDataComponents.INFERRED_FROM_RECIPE, (Object)true);
        serverplayerentity.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 45, toSend));
    }

    public void setItem(int slotId, int stateId, ItemStack stack) {
        if (slotId == 45) {
            ((BlueprintEntity.BlueprintSection)this.contentHolder).inferredIcon = (Boolean)stack.getOrDefault(AllDataComponents.INFERRED_FROM_RECIPE, (Object)false);
            stack.remove(AllDataComponents.INFERRED_FROM_RECIPE);
        }
        super.setItem(slotId, stateId, stack);
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return ((BlueprintEntity.BlueprintSection)this.contentHolder).getItems();
    }

    @Override
    protected void initAndReadInventory(BlueprintEntity.BlueprintSection contentHolder) {
        super.initAndReadInventory(contentHolder);
    }

    @Override
    protected void saveData(BlueprintEntity.BlueprintSection contentHolder) {
        contentHolder.save(this.ghostInventory);
    }

    @Override
    public boolean stillValid(Player player) {
        return this.contentHolder != null && ((BlueprintEntity.BlueprintSection)this.contentHolder).canPlayerUse(player);
    }

    class BlueprintCraftSlot
    extends Slot {
        public BlueprintCraftSlot(Container itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void setChanged() {
            super.setChanged();
            int index = this.getContainerSlot();
            if (index == 9) {
                if (this.hasItem() && !((BlueprintEntity.BlueprintSection)BlueprintMenu.this.contentHolder).getBlueprintWorld().isClientSide()) {
                    ((BlueprintEntity.BlueprintSection)BlueprintMenu.this.contentHolder).inferredIcon = false;
                    ServerPlayer serverplayerentity = (ServerPlayer)BlueprintMenu.this.player;
                    serverplayerentity.connection.send((Packet)new ClientboundContainerSetSlotPacket(BlueprintMenu.this.containerId, BlueprintMenu.this.incrementStateId(), 45, this.getItem()));
                }
            } else if (index < 9) {
                BlueprintMenu.this.onCraftMatrixChanged();
            }
        }
    }
}

