/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.potatoCannon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileBlockHitAction;
import com.zurrtum.create.api.registry.CreateRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;

public class AllPotatoProjectileBlockHitActions {
    public static void register() {
        AllPotatoProjectileBlockHitActions.register("plant_crop", PlantCrop.CODEC);
        AllPotatoProjectileBlockHitActions.register("place_block_on_ground", PlaceBlockOnGround.CODEC);
    }

    private static void register(String name, MapCodec<? extends PotatoProjectileBlockHitAction> codec) {
        Registry.register(CreateRegistries.POTATO_PROJECTILE_BLOCK_HIT_ACTION, (Identifier)Identifier.fromNamespaceAndPath((String)"create", (String)name), codec);
    }

    public record PlantCrop(Holder<Block> cropBlock) implements PotatoProjectileBlockHitAction
    {
        public static final MapCodec<PlantCrop> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").forGetter(PlantCrop::cropBlock)).apply((Applicative)instance, PlantCrop::new));

        public PlantCrop(Block cropBlock) {
            this((Holder<Block>)cropBlock.builtInRegistryHolder());
        }

        @Override
        public boolean execute(LevelAccessor level, ItemStack projectile, BlockHitResult ray) {
            Level l;
            if (level.isClientSide()) {
                return true;
            }
            BlockPos hitPos = ray.getBlockPos();
            if (level instanceof Level && !(l = (Level)level).isLoaded(hitPos)) {
                return true;
            }
            Direction face = ray.getDirection();
            if (face != Direction.UP) {
                return false;
            }
            BlockPos placePos = hitPos.relative(face);
            return level.getBlockState(placePos).canBeReplaced();
        }

        @Override
        public MapCodec<? extends PotatoProjectileBlockHitAction> codec() {
            return CODEC;
        }
    }

    public record PlaceBlockOnGround(Holder<Block> block) implements PotatoProjectileBlockHitAction
    {
        public static final MapCodec<PlaceBlockOnGround> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").forGetter(PlaceBlockOnGround::block)).apply((Applicative)instance, PlaceBlockOnGround::new));

        public PlaceBlockOnGround(Block block) {
            this((Holder<Block>)block.builtInRegistryHolder());
        }

        @Override
        public boolean execute(LevelAccessor levelAccessor, ItemStack projectile, BlockHitResult ray) {
            Level l;
            if (levelAccessor.isClientSide()) {
                return true;
            }
            BlockPos hitPos = ray.getBlockPos();
            if (levelAccessor instanceof Level && !(l = (Level)levelAccessor).isLoaded(hitPos)) {
                return true;
            }
            Direction face = ray.getDirection();
            BlockPos placePos = hitPos.relative(face);
            if (!levelAccessor.getBlockState(placePos).canBeReplaced()) {
                return false;
            }
            if (face == Direction.UP) {
                levelAccessor.setBlock(placePos, ((Block)this.block.value()).defaultBlockState(), 3);
            } else if (levelAccessor instanceof Level) {
                Level level = (Level)levelAccessor;
                double y = (double)ray.getBlockPos().getY() - 0.5;
                if (!level.isEmptyBlock(placePos.above())) {
                    y = Math.min(y, (double)placePos.getY());
                }
                if (!level.isEmptyBlock(placePos.below())) {
                    y = Math.max(y, (double)placePos.getY());
                }
                FallingBlockEntity falling = new FallingBlockEntity(level, (double)placePos.getX() + 0.5, y, (double)placePos.getZ() + 0.5, ((Block)this.block.value()).defaultBlockState());
                falling.time = 1;
                level.addFreshEntity((Entity)falling);
            }
            return true;
        }

        @Override
        public MapCodec<? extends PotatoProjectileBlockHitAction> codec() {
            return CODEC;
        }
    }
}

