/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.potatoCannon;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoCannonProjectileType;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.armor.BacktankUtil;
import com.zurrtum.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import com.zurrtum.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.zurrtum.create.foundation.item.SwingControlItem;
import com.zurrtum.create.foundation.utility.GlobalRegistryAccess;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.PotatoCannonPacket;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PotatoCannonItem
extends ProjectileWeaponItem
implements SwingControlItem {
    private static final Predicate<ItemStack> AMMO_PREDICATE = s -> PotatoCannonProjectileType.getTypeForItem(GlobalRegistryAccess.getOrThrow(), s.getItem()).isPresent();

    public PotatoCannonItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public static Ammo getAmmo(Player player, ItemStack heldStack) {
        ItemStack ammoStack = player.getProjectile(heldStack);
        if (ammoStack.isEmpty()) {
            return null;
        }
        return PotatoCannonProjectileType.getTypeForItem(player.level().registryAccess(), ammoStack.getItem()).map(r -> new Ammo(ammoStack, (PotatoCannonProjectileType)r.value())).orElse(null);
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
    }

    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.use(context.getLevel(), context.getPlayer(), context.getHand());
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (ShootableGadgetItemMethods.shouldSwap(player, heldStack, hand, s -> s.getItem() instanceof PotatoCannonItem)) {
            return InteractionResult.FAIL;
        }
        Ammo ammo = PotatoCannonItem.getAmmo(player, heldStack);
        if (ammo == null) {
            return InteractionResult.PASS;
        }
        ItemStack ammoStack = ammo.stack();
        PotatoCannonProjectileType projectileType = ammo.type();
        if (level.isClientSide()) {
            player.stopUsingItem();
            AllClientHandle.INSTANCE.cannonDontAnimateItem(hand);
            return InteractionResult.CONSUME.heldItemTransformedTo(heldStack);
        }
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == InteractionHand.MAIN_HAND, new Vec3(0.75, (double)-0.15f, 1.5));
        Vec3 correction = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == InteractionHand.MAIN_HAND, new Vec3((double)-0.05f, 0.0, 0.0)).subtract(player.position().add(0.0, (double)player.getEyeHeight(), 0.0));
        Vec3 lookVec = player.getLookAngle();
        Vec3 motion = lookVec.add(correction).normalize().scale(2.0).scale((double)projectileType.velocityMultiplier());
        float soundPitch = projectileType.soundPitch() + (level.getRandom().nextFloat() - 0.5f) / 4.0f;
        boolean spray = projectileType.split() > 1;
        Vec3 sprayBase = VecHelper.rotate(new Vec3(0.0, 0.1, 0.0), 360.0f * level.getRandom().nextFloat(), Direction.Axis.Z);
        float sprayChange = 360.0f / (float)projectileType.split();
        ItemStack ammoStackCopy = ammoStack.copy();
        for (int i = 0; i < projectileType.split(); ++i) {
            PotatoProjectileEntity projectile = (PotatoProjectileEntity)AllEntityTypes.POTATO_PROJECTILE.create(level, EntitySpawnReason.SPAWN_ITEM_USE);
            projectile.setItem(ammoStackCopy);
            projectile.setEnchantmentEffectsFromCannon(heldStack);
            Vec3 splitMotion = motion;
            if (spray) {
                float imperfection = 40.0f * (level.getRandom().nextFloat() - 0.5f);
                Vec3 sprayOffset = VecHelper.rotate(sprayBase, (float)i * sprayChange + imperfection, Direction.Axis.Z);
                splitMotion = splitMotion.add(VecHelper.lookAt(sprayOffset, motion));
            }
            if (i != 0) {
                projectile.recoveryChance = 0.0f;
            }
            projectile.setPos(barrelPos.x, barrelPos.y, barrelPos.z);
            projectile.setDeltaMovement(splitMotion);
            projectile.setOwner((Entity)player);
            level.addFreshEntity((Entity)projectile);
        }
        if (!player.isCreative()) {
            ammoStack.shrink(1);
            if (ammoStack.isEmpty()) {
                player.getInventory().removeItem(ammoStack);
            }
        }
        if (!BacktankUtil.canAbsorbDamage((LivingEntity)player, PotatoCannonItem.maxUses())) {
            heldStack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
        }
        ShootableGadgetItemMethods.applyCooldown(player, heldStack, hand, s -> s.getItem() instanceof PotatoCannonItem, projectileType.reloadTicks());
        ShootableGadgetItemMethods.sendPackets(player, b -> new PotatoCannonPacket(barrelPos, lookVec.normalize(), ammoStack, hand, soundPitch, (boolean)b));
        player.stopUsingItem();
        return InteractionResult.CONSUME.heldItemTransformedTo(heldStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay displayComponent, Consumer<Component> tooltip, TooltipFlag tooltipType) {
        if (!AllClientHandle.INSTANCE.isClient()) {
            return;
        }
        Player player = AllClientHandle.INSTANCE.getPlayer();
        if (player == null) {
            return;
        }
        Ammo ammo = PotatoCannonItem.getAmmo(player, stack);
        if (ammo == null) {
            return;
        }
        ItemStack ammoStack = ammo.stack();
        PotatoCannonProjectileType type = ammo.type();
        HolderLookup.Provider registries = context.registries();
        if (registries == null) {
            return;
        }
        HolderLookup.RegistryLookup lookup = registries.lookupOrThrow(Registries.ENCHANTMENT);
        ItemEnchantments enchantments = stack.getEnchantments();
        int power = enchantments.getLevel((Holder)lookup.getOrThrow(Enchantments.POWER));
        int punch = enchantments.getLevel((Holder)lookup.getOrThrow(Enchantments.PUNCH));
        float additionalDamageMult = 1.0f + (float)power * 0.2f;
        float additionalKnockback = (float)punch * 0.5f;
        String _attack = "create.potato_cannon.ammo.attack_damage";
        String _reload = "create.potato_cannon.ammo.reload_ticks";
        String _knockback = "create.potato_cannon.ammo.knockback";
        tooltip.accept(CommonComponents.EMPTY);
        tooltip.accept((Component)ammoStack.getHoverName().copy().append((Component)Component.literal((String)":")).withStyle(ChatFormatting.GRAY));
        MutableComponent spacing = CommonComponents.space();
        ChatFormatting green = ChatFormatting.GREEN;
        ChatFormatting darkGreen = ChatFormatting.DARK_GREEN;
        float damageF = (float)type.damage() * additionalDamageMult;
        MutableComponent damage = Component.literal((String)(damageF == (float)Mth.floor((float)damageF) ? "" + Mth.floor((float)damageF) : "" + damageF));
        MutableComponent reloadTicks = Component.literal((String)("" + type.reloadTicks()));
        MutableComponent knockback = Component.literal((String)("" + (type.knockback() + additionalKnockback)));
        damage = damage.withStyle(additionalDamageMult > 1.0f ? green : darkGreen);
        knockback = knockback.withStyle(additionalKnockback > 0.0f ? green : darkGreen);
        reloadTicks = reloadTicks.withStyle(darkGreen);
        tooltip.accept((Component)spacing.plainCopy().append((Component)Component.translatable((String)_attack, (Object[])new Object[]{damage}).withStyle(darkGreen)));
        tooltip.accept((Component)spacing.plainCopy().append((Component)Component.translatable((String)_reload, (Object[])new Object[]{reloadTicks}).withStyle(darkGreen)));
        tooltip.accept((Component)spacing.plainCopy().append((Component)Component.translatable((String)_knockback, (Object[])new Object[]{knockback}).withStyle(darkGreen)));
    }

    public boolean canDestroyBlock(ItemStack stack, BlockState state, Level world, BlockPos pos, LivingEntity player) {
        return false;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return AMMO_PREDICATE;
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible(stack, PotatoCannonItem.maxUses());
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth(stack, PotatoCannonItem.maxUses());
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor(stack, PotatoCannonItem.maxUses());
    }

    private static int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxPotatoCannonShots.get();
    }

    @Override
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    public record Ammo(ItemStack stack, PotatoCannonProjectileType type) {
    }
}

