/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.sandPaper;

import com.google.common.collect.BiMap;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.infrastructure.component.SandPaperItemComponent;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SandPaperItem
extends Item {
    public SandPaperItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (itemstack.has(AllDataComponents.SAND_PAPER_POLISHING)) {
            playerIn.startUsingItem(handIn);
            return InteractionResult.PASS;
        }
        InteractionHand otherHand = handIn == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack itemInOtherHand = playerIn.getItemInHand(otherHand);
        RecipePropertySet recipe = worldIn.recipeAccess().propertySet(AllRecipeSets.SAND_PAPER_POLISHING);
        if (recipe.test(itemInOtherHand)) {
            ItemStack item = itemInOtherHand.copy();
            ItemStack toPolish = item.split(1);
            playerIn.startUsingItem(handIn);
            itemstack.set(AllDataComponents.SAND_PAPER_POLISHING, (Object)new SandPaperItemComponent(toPolish));
            playerIn.setItemInHand(otherHand, item);
            return InteractionResult.SUCCESS.heldItemTransformedTo(itemstack);
        }
        BlockHitResult raytraceresult = SandPaperItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        Vec3 hitVec = raytraceresult.getLocation();
        AABB bb = new AABB(hitVec, hitVec).inflate(1.0);
        ItemEntity pickUp = null;
        for (ItemEntity itemEntity : worldIn.getEntitiesOfClass(ItemEntity.class, bb)) {
            ItemStack stack;
            if (!itemEntity.isAlive() || itemEntity.position().distanceTo(playerIn.position()) > 3.0 || !recipe.test(stack = itemEntity.getItem())) continue;
            pickUp = itemEntity;
            break;
        }
        if (pickUp == null) {
            return InteractionResult.FAIL;
        }
        ItemStack item = pickUp.getItem().copy();
        ItemStack toPolish = item.split(1);
        playerIn.startUsingItem(handIn);
        if (!worldIn.isClientSide()) {
            itemstack.set(AllDataComponents.SAND_PAPER_POLISHING, (Object)new SandPaperItemComponent(toPolish));
            if (item.isEmpty()) {
                pickUp.discard();
            } else {
                pickUp.setItem(item);
            }
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemstack);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        ItemStack polishing;
        RandomSource random = user.getRandom();
        if (stack.has(AllDataComponents.SAND_PAPER_POLISHING) && !(polishing = ((SandPaperItemComponent)stack.get(AllDataComponents.SAND_PAPER_POLISHING)).item()).isEmpty()) {
            user.spawnItemParticles(polishing, 1);
        }
        if ((user.getTicksUsingItem() - 6) % 7 == 0) {
            user.playSound(AllSoundEvents.SANDING_SHORT.getMainEvent(), 0.9f + 0.2f * random.nextFloat(), random.nextFloat() * 0.2f + 0.9f);
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        Player player = (Player)entityLiving;
        SandPaperItemComponent component = (SandPaperItemComponent)stack.get(AllDataComponents.SAND_PAPER_POLISHING);
        if (component == null) {
            return stack;
        }
        ItemStack toPolish = component.item();
        if (world.isClientSide()) {
            SandPaperItem.spawnParticles(entityLiving.getEyePosition(1.0f).add(entityLiving.getLookAngle().scale(0.5)), toPolish, world);
            return stack;
        }
        SingleRecipeInput input = new SingleRecipeInput(toPolish);
        ((ServerLevel)world).recipeAccess().getRecipeFor(AllRecipeTypes.SANDPAPER_POLISHING, (RecipeInput)input, world).ifPresent(recipe -> {
            ItemStack recipeRemainder;
            ItemStack polished = ((SandPaperPolishingRecipe)recipe.value()).assemble(input, (HolderLookup.Provider)world.registryAccess());
            Inventory playerInv = player.getInventory();
            if (!polished.isEmpty()) {
                playerInv.placeItemBackInInventory(polished);
            }
            if (!(recipeRemainder = toPolish.getItem().getCraftingRemainder()).isEmpty()) {
                playerInv.placeItemBackInInventory(recipeRemainder);
            }
        });
        stack.remove(AllDataComponents.SAND_PAPER_POLISHING);
        stack.hurtAndBreak(1, entityLiving, entityLiving.getUsedItemHand().asEquipmentSlot());
        return stack;
    }

    public static void spawnParticles(Vec3 location, ItemStack polishedStack, Level world) {
        for (int i = 0; i < 20; ++i) {
            Vec3 motion = VecHelper.offsetRandomly(Vec3.ZERO, world.random, 0.125f);
            world.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, polishedStack), location.x, location.y, location.z, motion.x, motion.y, motion.z);
        }
    }

    public boolean releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return false;
        }
        Player player = (Player)entityLiving;
        if (stack.has(AllDataComponents.SAND_PAPER_POLISHING)) {
            ItemStack toPolish = ((SandPaperItemComponent)stack.get(AllDataComponents.SAND_PAPER_POLISHING)).item();
            player.getInventory().placeItemBackInInventory(toPolish);
            stack.remove(AllDataComponents.SAND_PAPER_POLISHING);
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        Optional<BlockState> newState = ((AxeItem)Items.DIAMOND_AXE).getStripped(state);
        if (newState.isPresent()) {
            AllSoundEvents.SANDING_LONG.play(level, player, (Vec3i)pos, 1.0f, 1.0f + (level.random.nextFloat() * 0.5f - 1.0f) / 5.0f);
            level.levelEvent((Entity)player, 3005, pos, 0);
        } else {
            newState = Optional.ofNullable((Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
            if (newState.isPresent()) {
                AllSoundEvents.SANDING_LONG.play(level, player, (Vec3i)pos, 1.0f, 1.0f + (level.random.nextFloat() * 0.5f - 1.0f) / 5.0f);
                level.levelEvent((Entity)player, 3004, pos, 0);
            }
        }
        if (newState.isPresent()) {
            level.setBlockAndUpdate(pos, newState.get());
            if (player != null) {
                stack.hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand().asEquipmentSlot());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 32;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.EAT;
    }
}

