/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.symmetryWand;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryPlacementContext;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.SymmetryMirror;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.SymmetryEffectPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;

public class SymmetryWandItem
extends Item {
    public SymmetryWandItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack wand = player.getItemInHand(context.getHand());
        player.getCooldowns().addCooldown(wand, 5);
        SymmetryWandItem.checkComponents(wand);
        if (player.isShiftKeyDown()) {
            if (player.level().isClientSide()) {
                AllClientHandle.INSTANCE.openSymmetryWandScreen(wand, context.getHand());
            }
            return InteractionResult.SUCCESS;
        }
        if (context.getLevel().isClientSide() || context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        pos = pos.relative(context.getClickedFace());
        SymmetryMirror previousElement = (SymmetryMirror)wand.get(AllDataComponents.SYMMETRY_WAND);
        wand.set(AllDataComponents.SYMMETRY_WAND_ENABLE, (Object)true);
        Vec3 pos3d = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        SymmetryMirror newElement = new PlaneMirror(pos3d);
        if (previousElement instanceof EmptyMirror) {
            ((SymmetryMirror)newElement).setOrientation(player.getDirection() == Direction.NORTH || player.getDirection() == Direction.SOUTH ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            newElement.enable = true;
            wand.set(AllDataComponents.SYMMETRY_WAND_ENABLE, (Object)true);
        } else {
            previousElement.setPosition(pos3d);
            if (previousElement instanceof PlaneMirror) {
                previousElement.setOrientation(player.getDirection() == Direction.NORTH || player.getDirection() == Direction.SOUTH ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            }
            if (previousElement instanceof CrossPlaneMirror) {
                float rotation = player.getYHeadRot();
                float abs = Math.abs(rotation % 90.0f);
                boolean diagonal = abs > 22.0f && abs < 67.0f;
                previousElement.setOrientation(diagonal ? CrossPlaneMirror.Align.D.ordinal() : CrossPlaneMirror.Align.Y.ordinal());
            }
            newElement = previousElement;
        }
        wand.set(AllDataComponents.SYMMETRY_WAND, (Object)newElement);
        player.setItemInHand(context.getHand(), wand);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack wand = playerIn.getItemInHand(handIn);
        SymmetryWandItem.checkComponents(wand);
        if (playerIn.isShiftKeyDown()) {
            if (worldIn.isClientSide()) {
                AllClientHandle.INSTANCE.openSymmetryWandScreen(wand, handIn);
                playerIn.getCooldowns().addCooldown(wand, 5);
            }
            return InteractionResult.SUCCESS;
        }
        wand.set(AllDataComponents.SYMMETRY_WAND_ENABLE, (Object)false);
        return InteractionResult.SUCCESS.heldItemTransformedTo(wand);
    }

    private static void checkComponents(ItemStack wand) {
        if (!wand.has(AllDataComponents.SYMMETRY_WAND)) {
            wand.set(AllDataComponents.SYMMETRY_WAND, (Object)new EmptyMirror(new Vec3(0.0, 0.0, 0.0)));
            wand.set(AllDataComponents.SYMMETRY_WAND_ENABLE, (Object)false);
        }
    }

    public static boolean isEnabled(ItemStack stack) {
        SymmetryWandItem.checkComponents(stack);
        return (Boolean)stack.getOrDefault(AllDataComponents.SYMMETRY_WAND_ENABLE, (Object)false) != false && (Boolean)stack.getOrDefault(AllDataComponents.SYMMETRY_WAND_SIMULATE, (Object)false) == false;
    }

    public static SymmetryMirror getMirror(ItemStack stack) {
        SymmetryWandItem.checkComponents(stack);
        return (SymmetryMirror)stack.get(AllDataComponents.SYMMETRY_WAND);
    }

    public static void configureSettings(ItemStack stack, SymmetryMirror mirror) {
        SymmetryWandItem.checkComponents(stack);
        stack.set(AllDataComponents.SYMMETRY_WAND, (Object)mirror);
    }

    public static void apply(ServerLevel world, ItemStack wand, Player player, BlockPos pos, BlockState block, Vec3 hitPos, boolean canReplaceExisting, Direction side, InteractionHand hand) {
        SymmetryWandItem.checkComponents(wand);
        if (!SymmetryWandItem.isEnabled(wand)) {
            return;
        }
        if (!BlockItem.BY_BLOCK.containsKey(block.getBlock())) {
            return;
        }
        HashMap<BlockPos, Pair<Direction, BlockState>> blockSet = new HashMap<BlockPos, Pair<Direction, BlockState>>();
        blockSet.put(pos, Pair.of(side, block));
        SymmetryMirror symmetry = (SymmetryMirror)wand.get(AllDataComponents.SYMMETRY_WAND);
        Vec3 mirrorPos = symmetry.getPosition();
        if (mirrorPos.distanceTo(Vec3.atLowerCornerOf((Vec3i)pos)) > (double)((Integer)AllConfigs.server().equipment.maxSymmetryWandRange.get()).intValue()) {
            return;
        }
        symmetry.process(blockSet);
        BlockPos to = BlockPos.containing((Position)mirrorPos);
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        targets.add(pos);
        double y = hitPos.y();
        for (BlockPos position : blockSet.keySet()) {
            int count;
            ItemStack current;
            List<Runnable> tasks;
            if (position.equals((Object)pos) || !world.isUnobstructed(block, position, CollisionContext.of((Entity)player))) continue;
            Pair pair = (Pair)blockSet.get(position);
            Direction direction = (Direction)pair.getFirst();
            BlockState blockState = (BlockState)pair.getSecond();
            for (Direction face : Iterate.directions) {
                blockState = blockState.updateShape((LevelReader)world, (ScheduledTickAccess)world, position, face, position.relative(face), world.getBlockState(position.relative(face)), world.random);
            }
            if (player.isCreative()) {
                world.setBlockAndUpdate(position, blockState);
                targets.add(position);
                continue;
            }
            BlockState toReplace = world.getBlockState(position);
            if (toReplace.getDestroySpeed((BlockGetter)world, position) == -1.0f) continue;
            if (blockState.is((Block)AllBlocks.CART_ASSEMBLER)) {
                BlockState railBlock = CartAssemblerBlock.getRailBlock(blockState);
                Pair<ItemStack, List<Runnable>> findRail = BlockHelper.findInInventory(toReplace, railBlock, player);
                ItemStack rail = findRail.getFirst();
                if (rail.isEmpty()) continue;
                tasks = findRail.getSecond();
                Pair<ItemStack, List<Runnable>> findBlock = BlockHelper.findInInventory(toReplace, blockState, player);
                ItemStack cartAssembler = findBlock.getFirst();
                if (cartAssembler.isEmpty()) {
                    current = rail;
                } else {
                    tasks.addAll((Collection<Runnable>)findBlock.getSecond());
                    current = cartAssembler;
                }
            } else {
                Pair<ItemStack, List<Runnable>> find = BlockHelper.findInInventory(toReplace, blockState, player);
                current = find.getFirst();
                if (current.isEmpty()) continue;
                tasks = find.getSecond();
            }
            SymmetryPlacementContext placementContext = new SymmetryPlacementContext((Level)world, player, hand, current, position, direction, y, canReplaceExisting, toReplace, blockState);
            if (!toReplace.canBeReplaced() && !toReplace.canBeReplaced((BlockPlaceContext)placementContext)) continue;
            wand.set(AllDataComponents.SYMMETRY_WAND_SIMULATE, (Object)true);
            InteractionResult.Fail actionResult = InteractionResult.FAIL;
            int size = current.getCount();
            for (count = 0; count < size && (actionResult = current.useOn((UseOnContext)placementContext)).consumesAction(); ++count) {
            }
            wand.set(AllDataComponents.SYMMETRY_WAND_SIMULATE, (Object)false);
            if (actionResult.consumesAction()) {
                targets.add(position);
                tasks.forEach(Runnable::run);
                continue;
            }
            if (count == 0) continue;
            targets.add(position);
            tasks.forEach(Runnable::run);
            player.getInventory().placeItemBackInInventory(placementContext.getItemInHand());
        }
        world.getChunkSource().sendToTrackingPlayersAndSelf((Entity)player, (Packet)new SymmetryEffectPacket(to, targets));
    }

    private static boolean isHoldingBlock(Player player, BlockState block) {
        ItemStack itemBlock = BlockHelper.getRequiredItem(block);
        return player.isHolding(itemBlock.getItem());
    }

    public static void remove(ServerLevel world, ItemStack wand, Player player, BlockPos pos, BlockState ogBlock) {
        BlockState air = Blocks.AIR.defaultBlockState();
        SymmetryWandItem.checkComponents(wand);
        if (!SymmetryWandItem.isEnabled(wand)) {
            return;
        }
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        positions.add(pos);
        SymmetryMirror symmetry = (SymmetryMirror)wand.get(AllDataComponents.SYMMETRY_WAND);
        Vec3 mirrorPos = symmetry.getPosition();
        if (mirrorPos.distanceTo(Vec3.atLowerCornerOf((Vec3i)pos)) > (double)((Integer)AllConfigs.server().equipment.maxSymmetryWandRange.get()).intValue()) {
            return;
        }
        symmetry.process(positions);
        BlockPos to = BlockPos.containing((Position)mirrorPos);
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        targets.add(pos);
        boolean noCreative = !player.isCreative();
        for (BlockPos position : positions) {
            BlockState blockstate;
            if (noCreative && ogBlock.getBlock() != world.getBlockState(position).getBlock() || position.equals((Object)pos) || (blockstate = world.getBlockState(position)).isAir()) continue;
            targets.add(position);
            world.levelEvent(2001, position, Block.getId((BlockState)blockstate));
            world.setBlock(position, air, 3);
            if (!noCreative) continue;
            ItemStack stack = player.getMainHandItem();
            if (!stack.isEmpty()) {
                stack.mineBlock((Level)world, blockstate, position, player);
            }
            BlockEntity blockEntity = blockstate.hasBlockEntity() ? world.getBlockEntity(position) : null;
            Block.dropResources((BlockState)blockstate, (Level)world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)stack);
        }
        world.getChunkSource().sendToTrackingPlayersAndSelf((Entity)player, (Packet)new SymmetryEffectPacket(to, targets));
    }

    public static boolean presentInHotbar(Player player) {
        Inventory inv = player.getInventory();
        int size = Inventory.getSelectionSize();
        for (int i = 0; i < size; ++i) {
            if (!inv.getItem(i).is((Item)AllItems.WAND_OF_SYMMETRY)) continue;
            return true;
        }
        return false;
    }
}

