/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.toolbox;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlock;
import com.zurrtum.create.content.equipment.toolbox.ToolboxHandler;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.content.equipment.toolbox.ToolboxMenu;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.utility.ResetableLazy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class ToolboxBlockEntity
extends SmartBlockEntity
implements MenuProvider,
Nameable {
    public LerpedFloat lid = LerpedFloat.linear().startWithValue(0.0);
    public LerpedFloat drawers = LerpedFloat.linear().startWithValue(0.0);
    UUID uniqueId;
    public ToolboxInventory inventory;
    ResetableLazy<DyeColor> colorProvider;
    Map<Integer, WeakHashMap<Player, Integer>> connectedPlayers = new HashMap<Integer, WeakHashMap<Player, Integer>>();
    private Component customName;
    private AnimatedContainerBehaviour<ToolboxMenu> openTracker;
    private boolean keepAlive;

    public ToolboxBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.TOOLBOX, pos, state);
        this.inventory = new ToolboxInventory(this);
        this.colorProvider = ResetableLazy.of(() -> {
            BlockState blockState = this.getBlockState();
            if (blockState != null && blockState.getBlock() instanceof ToolboxBlock) {
                return ((ToolboxBlock)blockState.getBlock()).getColor();
            }
            return DyeColor.BROWN;
        });
        this.setLazyTickRate(10);
    }

    public DyeColor getColor() {
        return this.colorProvider.get();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.openTracker = new AnimatedContainerBehaviour<ToolboxMenu>(this, ToolboxMenu.class);
        behaviours.add(this.openTracker);
    }

    @Override
    public void initialize() {
        super.initialize();
        ToolboxHandler.onLoad(this);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        ToolboxHandler.onUnload(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            this.tickAudio();
        } else {
            this.tickPlayers();
        }
        this.lid.chase(this.openTracker.openCount > 0 ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.LINEAR);
        this.drawers.chase(this.openTracker.openCount > 0 ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.EXP);
        this.lid.tickChaser();
        this.drawers.tickChaser();
    }

    private void tickPlayers() {
        boolean update = false;
        Iterator<Map.Entry<Integer, WeakHashMap<Player, Integer>>> toolboxSlots = this.connectedPlayers.entrySet().iterator();
        while (toolboxSlots.hasNext()) {
            Map.Entry<Integer, WeakHashMap<Player, Integer>> toolboxSlotEntry = toolboxSlots.next();
            WeakHashMap<Player, Integer> set = toolboxSlotEntry.getValue();
            int slot = toolboxSlotEntry.getKey();
            ItemStack referenceItem = (ItemStack)this.inventory.filters.get(slot);
            boolean clear = referenceItem.isEmpty();
            Iterator<Map.Entry<Player, Integer>> playerEntries = set.entrySet().iterator();
            while (playerEntries.hasNext()) {
                int deposited;
                int targetAmount;
                Map.Entry<Player, Integer> playerEntry = playerEntries.next();
                Player player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                if (!clear && !ToolboxHandler.withinRange(player, this)) continue;
                Inventory playerInv = player.getInventory();
                ItemStack playerStack = playerInv.getItem(hotbarSlot);
                if (clear || !playerStack.isEmpty() && !ToolboxInventory.canItemsShareCompartment(playerStack, referenceItem)) {
                    CompoundTag compound = AllSynchedDatas.TOOLBOX.get((Entity)player);
                    compound.remove(String.valueOf(hotbarSlot));
                    playerEntries.remove();
                    if (!(player instanceof ServerPlayer)) continue;
                    ToolboxHandler.syncData(player, compound);
                    continue;
                }
                int count = playerStack.getCount();
                if (count < (targetAmount = (referenceItem.getMaxStackSize() + 1) / 2)) {
                    ItemStack extracted;
                    int amountToReplenish = targetAmount - count;
                    if (this.isOpenInContainer(player) && !(extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, true)).isEmpty()) {
                        ToolboxHandler.unequip(player, hotbarSlot, false);
                        ToolboxHandler.syncData(player, AllSynchedDatas.TOOLBOX.get((Entity)player));
                        continue;
                    }
                    extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, false);
                    if (!extracted.isEmpty()) {
                        update = true;
                        ItemStack template = playerStack.isEmpty() ? extracted : playerStack;
                        playerInv.setItem(hotbarSlot, template.copyWithCount(count + extracted.getCount()));
                    }
                }
                if (count <= targetAmount) continue;
                int amountToDeposit = count - targetAmount;
                ItemStack toDistribute = playerStack.copyWithCount(amountToDeposit);
                if (this.isOpenInContainer(player) && (deposited = this.inventory.distributeToCompartment(toDistribute, slot, true)) > 0) {
                    ToolboxHandler.unequip(player, hotbarSlot, true);
                    ToolboxHandler.syncData(player, AllSynchedDatas.TOOLBOX.get((Entity)player));
                    continue;
                }
                int deposited2 = this.inventory.distributeToCompartment(toDistribute, slot, false);
                if (deposited2 <= 0) continue;
                update = true;
                playerInv.setItem(hotbarSlot, playerStack.copyWithCount(count - deposited2));
            }
            if (!clear) continue;
            toolboxSlots.remove();
        }
        if (update) {
            this.sendData();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOpenInContainer(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof ToolboxMenu)) return false;
        ToolboxMenu toolboxMenu = (ToolboxMenu)abstractContainerMenu;
        if (toolboxMenu.contentHolder != this) return false;
        return true;
    }

    public void unequipTracked() {
        if (this.level.isClientSide()) {
            return;
        }
        HashSet<ServerPlayer> affected = new HashSet<ServerPlayer>();
        for (Map.Entry<Integer, WeakHashMap<Player, Integer>> toolboxSlotEntry : this.connectedPlayers.entrySet()) {
            WeakHashMap<Player, Integer> set = toolboxSlotEntry.getValue();
            for (Map.Entry<Player, Integer> playerEntry : set.entrySet()) {
                Player player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                ToolboxHandler.unequip(player, hotbarSlot, false);
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                affected.add(serverPlayer);
            }
        }
        for (ServerPlayer player : affected) {
            ToolboxHandler.syncData((Player)player, AllSynchedDatas.TOOLBOX.get((Entity)player));
        }
        this.connectedPlayers.clear();
    }

    public void unequip(int slot, Player player, int hotbarSlot, boolean keepItems) {
        if (!this.connectedPlayers.containsKey(slot)) {
            return;
        }
        this.connectedPlayers.get(slot).remove(player);
        if (keepItems) {
            return;
        }
        Inventory playerInv = player.getInventory();
        ItemStack playerStack = playerInv.getItem(hotbarSlot);
        ItemStack toInsert = ToolboxInventory.cleanItemNBT(playerStack.copy());
        int insert = this.inventory.distributeToCompartment(toInsert, slot, false);
        if (insert != 0) {
            int count = playerStack.getCount();
            if (insert == count) {
                playerInv.setItem(hotbarSlot, ItemStack.EMPTY);
            } else {
                playerStack.setCount(count - insert);
            }
        }
    }

    private void tickAudio() {
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        if (this.lid.settled()) {
            if (this.openTracker.openCount > 0 && this.lid.getChaseTarget() == 0.0f) {
                this.level.playLocalSound(vec.x, vec.y, vec.z, SoundEvents.IRON_DOOR_OPEN, SoundSource.BLOCKS, 0.25f, this.level.random.nextFloat() * 0.1f + 1.2f, true);
                this.level.playLocalSound(vec.x, vec.y, vec.z, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.1f, this.level.random.nextFloat() * 0.1f + 1.1f, true);
            }
            if (this.openTracker.openCount == 0 && this.lid.getChaseTarget() == 1.0f) {
                this.level.playLocalSound(vec.x, vec.y, vec.z, SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.1f, this.level.random.nextFloat() * 0.1f + 1.1f, true);
            }
        } else if (this.openTracker.openCount == 0 && this.lid.getChaseTarget() == 0.0f && this.lid.getValue(0.0f) > 0.0625f && this.lid.getValue(1.0f) < 0.0625f) {
            this.level.playLocalSound(vec.x, vec.y, vec.z, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 0.25f, this.level.random.nextFloat() * 0.1f + 1.2f, true);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.inventory.read(view.childOrEmpty("Inventory"));
        super.read(view, clientPacket);
        view.read("UniqueId", UUIDUtil.CODEC).ifPresent(uuid -> {
            this.uniqueId = uuid;
        });
        view.read("CustomName", ComponentSerialization.CODEC).ifPresent(name -> {
            this.customName = name;
        });
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        if (this.uniqueId == null) {
            this.uniqueId = UUID.randomUUID();
        }
        this.inventory.write(view.child("Inventory"));
        view.store("UniqueId", UUIDUtil.CODEC, (Object)this.uniqueId);
        if (this.customName != null) {
            view.store("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
        }
        super.write(view, clientPacket);
    }

    public ToolboxMenu createMenu(int id, Inventory inv, Player player, RegistryFriendlyByteBuf extraData) {
        this.sendToMenu(extraData);
        return new ToolboxMenu(id, inv, this);
    }

    @Override
    public void lazyTick() {
        ToolboxHandler.onLoad(this);
        super.lazyTick();
    }

    public void connectPlayer(int slot, Player player, int hotbarSlot) {
        if (this.level.isClientSide()) {
            return;
        }
        WeakHashMap map = this.connectedPlayers.computeIfAbsent(slot, WeakHashMap::new);
        Integer previous = (Integer)map.get(player);
        if (previous != null) {
            if (previous == hotbarSlot) {
                return;
            }
            ToolboxHandler.unequip(player, previous, false);
        }
        map.put(player, hotbarSlot);
    }

    public void readInventory(ToolboxInventory inv) {
        if (inv != null) {
            int i;
            NonNullList<ItemStack> filters = inv.filters;
            int size = filters.size();
            for (i = 0; i < size; ++i) {
                this.inventory.filters.set(i, (Object)((ItemStack)filters.get(i)));
            }
            size = inv.getContainerSize();
            for (i = 0; i < size; ++i) {
                this.inventory.setItem(i, inv.getItem(i));
            }
        }
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public boolean isFullyInitialized() {
        return this.uniqueId != null;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    @Override
    public Component getDisplayName() {
        return this.customName != null ? this.customName : this.getBlockState().getBlock().getName();
    }

    public Component getCustomName() {
        return this.customName;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public Component getName() {
        return this.customName;
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.colorProvider.reset();
    }

    protected void applyImplicitComponents(DataComponentGetter componentInput) {
        this.setUniqueId((UUID)componentInput.get(AllDataComponents.TOOLBOX_UUID));
        this.readInventory((ToolboxInventory)componentInput.get(AllDataComponents.TOOLBOX_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(AllDataComponents.TOOLBOX_UUID, (Object)this.uniqueId);
        components.set(AllDataComponents.TOOLBOX_INVENTORY, (Object)this.inventory);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        BlockState state = this.level.getBlockState(pos);
        if (this.getType().isValid(state)) {
            this.keepAlive = true;
            this.setBlockState(state);
        } else {
            super.preRemoveSideEffects(pos, oldState);
        }
    }

    @Override
    public void setRemoved() {
        if (this.keepAlive) {
            this.keepAlive = false;
            this.level.getChunk(this.worldPosition).setBlockEntity((BlockEntity)this);
        } else {
            super.setRemoved();
        }
    }
}

