/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.toolbox;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemSlots;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolboxInventory
implements ItemInventory {
    public static final int STACKS_PER_COMPARTMENT = 4;
    public static final int SIZE = 32;
    public static final Codec<ToolboxInventory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemSlots.maxSizeCodec(32).fieldOf("items").forGetter(ItemSlots::fromHandler), (App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("filters").forGetter(toolbox -> toolbox.filters)).apply((Applicative)instance, ToolboxInventory::deserialize));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToolboxInventory> STREAM_CODEC = StreamCodec.composite(ItemSlots.STREAM_CODEC, ItemSlots::fromHandler, CatnipStreamCodecBuilders.list(ItemStack.OPTIONAL_STREAM_CODEC), toolbox -> toolbox.filters, ToolboxInventory::deserialize);
    public NonNullList<ItemStack> filters = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    NonNullList<ItemStack> stacks = NonNullList.withSize((int)32, (Object)ItemStack.EMPTY);
    @Nullable
    private final ToolboxBlockEntity blockEntity;
    private boolean limitedMode;

    public ToolboxInventory(@Nullable ToolboxBlockEntity be) {
        this.blockEntity = be;
        this.limitedMode = false;
    }

    public void inLimitedMode(Consumer<ToolboxInventory> action) {
        this.limitedMode = true;
        action.accept(this);
        this.limitedMode = false;
    }

    public int getContainerSize() {
        return 32;
    }

    public ItemStack getItem(int slot) {
        if (slot >= 32) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (!stack.getItem().canFitInsideContainerItems()) {
            return false;
        }
        if (slot >= 32) {
            return false;
        }
        ItemStack filter = (ItemStack)this.filters.get(slot / 4);
        boolean empty = filter.isEmpty();
        if (this.limitedMode && empty) {
            return false;
        }
        return empty || ToolboxInventory.canItemsShareCompartment(filter, stack);
    }

    public void setItem(int slot, ItemStack stack) {
        int compartment;
        if (slot >= 32) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
        if (!stack.isEmpty() && ((ItemStack)this.filters.get(compartment = slot / 4)).isEmpty()) {
            this.filters.set(compartment, (Object)stack.copyWithCount(1));
        }
    }

    public int distributeToCompartment(@NotNull ItemStack stack, int compartment, boolean simulate) {
        int i;
        if (stack.isEmpty() || !stack.getItem().canFitInsideContainerItems()) {
            return 0;
        }
        ItemStack filter = (ItemStack)this.filters.get(compartment);
        if (filter.isEmpty() || !ToolboxInventory.canItemsShareCompartment(filter, stack)) {
            return 0;
        }
        int maxAmount = stack.getCount();
        int stackSize = stack.getMaxStackSize();
        if (simulate) {
            int i2;
            int count = 0;
            int end = i2 + 4;
            for (i2 = compartment * 4; i2 < end; ++i2) {
                ItemStack target = this.getItem(i2);
                if (target.isEmpty()) {
                    return maxAmount;
                }
                if ((count += stackSize - target.getCount()) < maxAmount) continue;
                return maxAmount;
            }
            return count;
        }
        int remaining = maxAmount;
        int end = i + 4;
        for (i = compartment * 4; i < end; ++i) {
            ItemStack target = this.getItem(i);
            if (target.isEmpty()) {
                this.setItem(i, this.directCopy(stack, remaining));
                this.setChanged();
                return maxAmount;
            }
            int count = target.getCount();
            if (count == stackSize) continue;
            int insert = Math.min(remaining, stackSize - count);
            target.setCount(count + insert);
            if (remaining == insert) {
                this.setChanged();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.setChanged();
        return maxAmount - remaining;
    }

    public ItemStack takeFromCompartment(int maxAmount, int compartment, boolean simulate) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        int index = compartment * 4;
        if (simulate) {
            for (int i = index + 4 - 1; i >= index; --i) {
                ItemStack findStack = (ItemStack)this.stacks.get(i);
                if (findStack.isEmpty()) continue;
                int count = findStack.getCount();
                if (count >= maxAmount) {
                    return this.directCopy(findStack, maxAmount);
                }
                for (int j = i - 1; j >= index; --j) {
                    ItemStack stack = this.getItem(i);
                    if (stack.isEmpty() || (count += stack.getCount()) < maxAmount) continue;
                    return this.directCopy(findStack, maxAmount);
                }
                return this.directCopy(findStack, count);
            }
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.takeFromCompartment(maxAmount, index, index + 4 - 1);
        if (stack == ItemStack.EMPTY) {
            return stack;
        }
        this.setChanged();
        return stack;
    }

    protected ItemStack takeFromCompartment(int maxAmount, int start, int end) {
        for (int i = end; i >= start; --i) {
            ItemStack findStack = (ItemStack)this.stacks.get(i);
            if (findStack.isEmpty()) continue;
            int count = findStack.getCount();
            if (count > maxAmount) {
                findStack.setCount(count - maxAmount);
                return this.directCopy(findStack, maxAmount);
            }
            this.setItem(i, ItemStack.EMPTY);
            if (count == maxAmount) {
                return findStack;
            }
            int remaining = maxAmount - count;
            for (int j = i - 1; j >= start; --j) {
                ItemStack stack = (ItemStack)this.stacks.get(j);
                if (stack.isEmpty()) continue;
                count = stack.getCount();
                if (count < remaining) {
                    this.setItem(i, ItemStack.EMPTY);
                    remaining -= count;
                    continue;
                }
                if (count == remaining) {
                    this.setItem(i, ItemStack.EMPTY);
                } else {
                    stack.setCount(count - remaining);
                }
                findStack.setCount(maxAmount);
                return findStack;
            }
            findStack.setCount(maxAmount - remaining);
            return findStack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setChanged() {
        if (this.blockEntity != null) {
            this.blockEntity.notifyUpdate();
        }
    }

    public static ItemStack cleanItemNBT(ItemStack stack) {
        if (stack.is((Item)AllItems.BELT_CONNECTOR)) {
            stack.remove(AllDataComponents.BELT_FIRST_SHAFT);
        }
        return stack;
    }

    public static boolean canItemsShareCompartment(ItemStack stack1, ItemStack stack2) {
        if (!stack1.isStackable() && !stack2.isStackable() && stack1.isDamageableItem() && stack2.isDamageableItem()) {
            return stack1.getItem() == stack2.getItem();
        }
        if (stack1.is((Item)AllItems.BELT_CONNECTOR) && stack2.is((Item)AllItems.BELT_CONNECTOR)) {
            return true;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public void write(ValueOutput view) {
        view.store("Items", ItemSlots.CODEC, (Object)ItemSlots.fromHandler(this));
        view.store("Compartments", CreateCodecs.ITEM_LIST_CODEC, this.filters);
    }

    public void read(ValueInput view) {
        view.read("Items", ItemSlots.CODEC).ifPresentOrElse(slots -> {
            boolean[] fill = new boolean[32];
            slots.forEach((slot, stack) -> {
                this.stacks.set(slot, (Object)stack);
                fill[slot] = true;
            });
            for (int i = 0; i < 32; ++i) {
                if (fill[i]) continue;
                this.stacks.set(i, (Object)ItemStack.EMPTY);
            }
        }, () -> this.stacks.clear());
        view.read("Compartments", CreateCodecs.ITEM_LIST_CODEC).ifPresentOrElse(list -> {
            int size = Math.min(list.size(), 32);
            for (int i = 0; i < size; ++i) {
                this.filters.set(i, (Object)((ItemStack)list.get(i)));
            }
        }, () -> this.filters.clear());
    }

    private static ToolboxInventory deserialize(ItemSlots slots, List<ItemStack> filters) {
        ToolboxInventory inventory = new ToolboxInventory(null);
        slots.forEach((arg_0, arg_1) -> inventory.stacks.set(arg_0, arg_1));
        int size = Math.min(filters.size(), 32);
        for (int i = 0; i < size; ++i) {
            inventory.filters.set(i, (Object)filters.get(i));
        }
        return inventory;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ToolboxInventory)) {
            return false;
        }
        ToolboxInventory that = (ToolboxInventory)o;
        return this.limitedMode == that.limitedMode && this.filters.equals(that.filters) && Objects.equals(this.blockEntity, that.blockEntity);
    }

    public int hashCode() {
        int result = this.filters.hashCode();
        result = 31 * result + Objects.hashCode(this.blockEntity);
        result = 31 * result + Boolean.hashCode(this.limitedMode);
        return result;
    }
}

